/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.audit;

import java.io.Serializable;
import org.beangle.cdi.Container;
import org.beangle.cdi.ContainerAware;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.domain.AuditPlanContext;
import org.openurp.edu.grade.domain.AuditPlanListener;
import org.openurp.edu.grade.domain.CourseGradeProvider;
import org.openurp.edu.grade.domain.DefaultPlanAuditor;
import org.openurp.edu.grade.domain.StdGrade;
import org.openurp.edu.grade.model.AuditPlanResult;
import org.openurp.edu.grade.service.AuditPlanService;
import org.openurp.edu.grade.service.audit.AuditPlanResultMerger$;
import org.openurp.edu.program.domain.CoursePlanProvider;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.service.Features;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class AuditPlanServiceImpl
extends DefaultPlanAuditor
implements AuditPlanService,
Logging,
ContainerAware {
    private Logger logger;
    private EntityDao entityDao;
    private CoursePlanProvider coursePlanProvider;
    private CourseGradeProvider courseGradeProvider;
    private ProjectConfigService projectConfigService;
    private Container container;
    private scala.collection.immutable.Map listeners;
    private String defaultListenerNames;

    public AuditPlanServiceImpl() {
        Logging.$init$((Logging)this);
        this.listeners = Predef$.MODULE$.Map().empty();
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public CoursePlanProvider coursePlanProvider() {
        return this.coursePlanProvider;
    }

    public void coursePlanProvider_$eq(CoursePlanProvider x$1) {
        this.coursePlanProvider = x$1;
    }

    public CourseGradeProvider courseGradeProvider() {
        return this.courseGradeProvider;
    }

    public void courseGradeProvider_$eq(CourseGradeProvider x$1) {
        this.courseGradeProvider = x$1;
    }

    public ProjectConfigService projectConfigService() {
        return this.projectConfigService;
    }

    public void projectConfigService_$eq(ProjectConfigService x$1) {
        this.projectConfigService = x$1;
    }

    public Container container() {
        return this.container;
    }

    public void container_$eq(Container x$1) {
        this.container = x$1;
    }

    public scala.collection.immutable.Map<Object, scala.collection.immutable.Seq<AuditPlanListener>> listeners() {
        return this.listeners;
    }

    public void listeners_$eq(scala.collection.immutable.Map<Object, scala.collection.immutable.Seq<AuditPlanListener>> x$1) {
        this.listeners = x$1;
    }

    public String defaultListenerNames() {
        return this.defaultListenerNames;
    }

    public void defaultListenerNames_$eq(String x$1) {
        this.defaultListenerNames = x$1;
    }

    @Override
    public AuditPlanResult audit(Student std, Map<String, Object> params, boolean persist) {
        scala.collection.immutable.Seq seq;
        Option existResults = this.entityDao().findBy(AuditPlanResult.class, "std", (Object)std).headOption();
        if (existResults.nonEmpty() && ((AuditPlanResult)existResults.get()).archived()) {
            return (AuditPlanResult)existResults.get();
        }
        Logger$.MODULE$.debug$extension(this.logger(), () -> AuditPlanServiceImpl.audit$$anonfun$1(std));
        CoursePlan coursePlan = (CoursePlan)this.coursePlanProvider().getCoursePlan(std).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option sharePlan = this.coursePlanProvider().getSharePlan(std);
        StdGrade stdGrade = new StdGrade(this.courseGradeProvider().getPublished(std));
        Option option = this.listeners().get(std.project().id());
        if (None$.MODULE$.equals(option)) {
            String s = (String)this.projectConfigService().get(std.project(), Features.Grade$.MODULE$.AuditPlanRules(), ClassTag$.MODULE$.apply(String.class));
            String string = s.trim();
            String string2 = "default";
            String lsnNames = !(string != null ? !string.equals(string2) : string2 != null) ? this.defaultListenerNames() : s;
            Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(lsnNames, ","));
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)n -> this.container().getBean((Object)("AuditPlanListener." + n)), ClassTag$.MODULE$.apply(AuditPlanListener.class)));
            scala.collection.immutable.Seq lsners = ArrayOps$.MODULE$.toSeq$extension(object2);
            Integer n2 = (Integer)Predef$.MODULE$.ArrowAssoc(std.project().id());
            this.listeners_$eq((scala.collection.immutable.Map<Object, scala.collection.immutable.Seq<AuditPlanListener>>)((scala.collection.immutable.Map)this.listeners().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n2, (Object)lsners))));
            seq = lsners;
        } else if (option instanceof Some) {
            scala.collection.immutable.Seq lsn;
            seq = lsn = (scala.collection.immutable.Seq)((Some)option).value();
        } else {
            throw new MatchError((Object)option);
        }
        scala.collection.immutable.Seq projectListeners = seq;
        AuditPlanContext context = new AuditPlanContext(std, coursePlan, sharePlan, stdGrade, (Seq)projectListeners);
        context.params().$plus$plus$eq(params);
        AuditPlanResult newResult = this.audit(context);
        if (persist) {
            AuditPlanResult rs = existResults.isEmpty() ? newResult : AuditPlanResultMerger$.MODULE$.merge(newResult, (AuditPlanResult)existResults.get());
            this.entityDao().saveOrUpdate((Object)rs, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditPlanResult[0]));
            return rs;
        }
        return newResult;
    }

    private Option<AuditPlanResult> getResult(Student std, EntityDao entityDao) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(AuditPlanResult.class, "planResult");
        query.where("planResult.std = :std", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        return entityDao.search((QueryBuilder)query).headOption();
    }

    @Override
    public Option<AuditPlanResult> getResult(Student std) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(AuditPlanResult.class, "planResult");
        query.where("planResult.std = :std", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        return this.entityDao().search((QueryBuilder)query).headOption();
    }

    @Override
    public void batchAudit(Iterable<Student> stds, Map<String, Object> params) {
        stds.foreach((Function1 & Serializable)std -> this.audit((Student)std, params, true));
    }

    private static final String audit$$anonfun$1(Student std$1) {
        return "start audit " + std$1.code();
    }
}

