/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.audit;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.time.Weeks$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.model.Semester;
import org.openurp.code.edu.model.ExamType$;
import org.openurp.code.edu.model.GradeType$;
import org.openurp.edu.exam.model.ExamTaker;
import org.openurp.edu.grade.domain.AuditPlanContext;
import org.openurp.edu.grade.domain.AuditPlanListener;
import org.openurp.edu.grade.model.ExamGrade;
import org.openurp.edu.grade.model.Grade;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class AuditExamTakerListener
implements AuditPlanListener {
    private EntityDao entityDao;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public void end(AuditPlanContext context) {
        if (context.result().passed()) {
            return;
        }
        OqlBuilder builder = (OqlBuilder)OqlBuilder$.MODULE$.from(ExamTaker.class, "et").where("et.std=:std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{context.std()}));
        builder.where("et.examType.id in(:makeupTypeIds)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{ExamType$.MODULE$.Makeup(), ExamType$.MODULE$.Delay()}))}));
        builder.where("not exists(from " + ExamGrade.class.getName() + " eg where  eg.courseGrade.clazz=et.clazz and eg.courseGrade.std=et.std" + (" and eg.gradeType.id in(" + GradeType$.MODULE$.Makeup() + "," + GradeType$.MODULE$.Delay() + ") and eg.status=:status)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Grade.Status$.MODULE$.Published())}));
        Seq examTakers = this.entityDao().search((QueryBuilder)builder);
        if (examTakers.nonEmpty()) {
            LocalDate today = LocalDate.now();
            Map examCourses = Collections$.MODULE$.newMap();
            ((IterableOnceOps)examTakers.filter((Function1 & Serializable)x -> Math.abs(Weeks$.MODULE$.between(x.semester().endOn(), today)) <= 25)).foreach((Function1 & Serializable)taker -> (Semester)examCourses.getOrElseUpdate((Object)taker.clazz().course(), () -> AuditExamTakerListener.end$$anonfun$2$$anonfun$1(taker)));
            context.result().groupResults().foreach((Function1)(JProcedure1 & Serializable)groupResult -> groupResult.courseResults().foreach((Function1)(JProcedure1 & Serializable)car -> {
                if (!car.passed() && examCourses.keySet().contains((Object)car.course())) {
                    Semester semester = (Semester)examCourses.apply((Object)car.course());
                    car.addRemark("\u672a\u51fa\u8865\u7f13\u8003\u6210\u7ee9(" + semester.schoolYear() + "\u5b66\u5e74" + semester.name() + "\u5b66\u671f)");
                    car.taking_$eq(true);
                    groupResult.addCourseResult(car);
                    return;
                }
            }));
            return;
        }
    }

    private static final Semester end$$anonfun$2$$anonfun$1(ExamTaker taker$1) {
        return taker$1.semester();
    }
}

