/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.finalmakeup.service.impl;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.model.Semester;
import org.openurp.edu.exam.model.FinalMakeupCourse;
import org.openurp.edu.finalmakeup.service.MakeupCourseCrnGenerator;
import org.openurp.edu.finalmakeup.service.impl.MakeupCourseCrnGeneratorImpl$;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map;
import scala.runtime.BooleanRef;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class MakeupCourseCrnGeneratorImpl
implements MakeupCourseCrnGenerator {
    private EntityDao entityDao;

    public static String initCrnNo() {
        return MakeupCourseCrnGeneratorImpl$.MODULE$.initCrnNo();
    }

    public static String prefix() {
        return MakeupCourseCrnGeneratorImpl$.MODULE$.prefix();
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    @Override
    public void gen(FinalMakeupCourse makeupCourse) {
        if (!Strings$.MODULE$.isEmpty((CharSequence)makeupCourse.crn())) {
            return;
        }
        MakeupCourseCrnGeneratorImpl makeupCourseCrnGeneratorImpl = this;
        synchronized (makeupCourseCrnGeneratorImpl) {
            scala.collection.immutable.Seq<String> crns = this.loadCrns(makeupCourse.semester());
            IntRef newCrn = IntRef.create((int)0);
            BooleanRef breaked = BooleanRef.create((boolean)false);
            crns.withFilter((Function1 & Serializable)s -> !breaked$1.elem).foreach((Function1)(JProcedure1 & Serializable)s -> {
                String crn = s.substring(MakeupCourseCrnGeneratorImpl$.MODULE$.prefix().length());
                if (!crn.matches(".*[^\\d]+.*")) {
                    if (Numbers$.MODULE$.toInt(crn, Numbers$.MODULE$.toInt$default$2()) - newCrn$1.elem >= 2) {
                        breaked$2.elem = true;
                        return;
                    }
                    newCrn$1.elem = Numbers$.MODULE$.toInt(crn, Numbers$.MODULE$.toInt$default$2());
                    return;
                }
            });
            ++newCrn.elem;
            this.putCrn(makeupCourse, newCrn.elem);
        }
    }

    private void putCrn(FinalMakeupCourse makeupCourse, int crn) {
        makeupCourse.crn_$eq("BK" + Strings$.MODULE$.repeat("0", 4 - String.valueOf(crn).length()) + crn);
    }

    private scala.collection.immutable.Seq<String> loadCrns(Semester semester) {
        OqlBuilder builder = OqlBuilder$.MODULE$.from(FinalMakeupCourse.class.getName() + " makeupCourse");
        builder.where("makeupCourse.semester = :semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        builder.orderBy("makeupCourse.crn");
        builder.select("makeupCourse.crn");
        return this.entityDao().search((QueryBuilder)builder);
    }

    @Override
    public void gen(Seq<FinalMakeupCourse> makeupCourses) {
        Map courseBySemesterMap = Collections$.MODULE$.newMap();
        makeupCourses.foreach((Function1)(JProcedure1 & Serializable)makeupCourse -> {
            if (Strings$.MODULE$.isEmpty((CharSequence)makeupCourse.crn())) {
                ((Growable)courseBySemesterMap.getOrElseUpdate((Object)makeupCourse.semester(), MakeupCourseCrnGeneratorImpl::gen$$anonfun$3$$anonfun$1)).$plus$eq(makeupCourse);
                return;
            }
        });
        courseBySemesterMap.keySet().foreach((Function1)(JProcedure1 & Serializable)semester -> this.genCourseCrns((Semester)semester, (Seq<FinalMakeupCourse>)((Seq)courseBySemesterMap.apply(semester))));
    }

    private void genCourseCrns(Semester semester, Seq<FinalMakeupCourse> courses) {
        if (courses.isEmpty()) {
            return;
        }
        MakeupCourseCrnGeneratorImpl makeupCourseCrnGeneratorImpl = this;
        synchronized (makeupCourseCrnGeneratorImpl) {
            scala.collection.immutable.Seq<String> allCrns = this.loadCrns(semester);
            IntRef newCrn = IntRef.create((int)0);
            IntRef seq = IntRef.create((int)0);
            IntRef allocated = IntRef.create((int)0);
            Iterator courseIter = courses.iterator();
            BooleanRef breaked = BooleanRef.create((boolean)false);
            allCrns.withFilter((Function1 & Serializable)s -> !breaked$3.elem).foreach((Function1)(JProcedure1 & Serializable)s -> {
                String crn = s.substring(MakeupCourseCrnGeneratorImpl$.MODULE$.prefix().length());
                seq$1.elem = Numbers$.MODULE$.toInt(crn, Numbers$.MODULE$.toInt$default$2());
                if (seq$1.elem - newCrn$2.elem >= 2) {
                    int gap = seq$1.elem - newCrn$2.elem - 1;
                    int i = 0;
                    while (i < gap) {
                        ++allocated$1.elem;
                        ++newCrn$2.elem;
                        this.putCrn((FinalMakeupCourse)courseIter.next(), newCrn$2.elem);
                        if (allocated$1.elem >= courses.size()) {
                            i = gap;
                            continue;
                        }
                        ++i;
                    }
                    if (allocated$1.elem >= courses.size()) {
                        breaked$4.elem = true;
                        return;
                    }
                    newCrn$2.elem = seq$1.elem;
                    return;
                }
            });
            while (allocated.elem < courses.size()) {
                ++newCrn.elem;
                ++allocated.elem;
                this.putCrn((FinalMakeupCourse)courseIter.next(), newCrn.elem);
            }
        }
    }

    private static final Buffer gen$$anonfun$3$$anonfun$1() {
        return Collections$.MODULE$.newBuffer();
    }
}

