/*
 * Copyright (C) 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.openurp.edu.grade.service

import org.beangle.data.dao.EntityDao
import org.beangle.data.dao.OqlBuilder
import org.openurp.base.model.Department
import org.openurp.base.model.Semester
import org.openurp.code.edu.model.GradeType
import org.openurp.base.edu.model.Course
import org.openurp.base.model.Project
import org.openurp.base.std.model.Student

trait StdGradeService {

  def stdByCode(stdCode: String,
      project: Project,
      departments: List[Department],
      entityDao: EntityDao): Student

  def buildGradeTypeQuery(): OqlBuilder[GradeType]

  def getStatus(crn: String,
      stdId: String,
      semesterId: String,
      entityDao: EntityDao): Array[Any]

  def checkStdGradeExists(std: Student,
      semester: Semester,
      course: Course,
      project: Project): Boolean
}
