/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.audit;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.logging.Logging;
import org.openurp.edu.grade.model.AuditCourseResult;
import org.openurp.edu.grade.model.AuditGroupResult;
import org.openurp.edu.grade.model.AuditPlanResult;
import org.slf4j.Logger;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class AuditPlanResultMerger$
implements Logging,
Serializable {
    private static Logger logger;
    public static final AuditPlanResultMerger$ MODULE$;

    private AuditPlanResultMerger$() {
    }

    static {
        MODULE$ = new AuditPlanResultMerger$();
        Logging.$init$((Logging)MODULE$);
        Statics.releaseFence();
    }

    public Logger logger() {
        return logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AuditPlanResultMerger$.class);
    }

    public AuditPlanResult merge(AuditPlanResult newResult, AuditPlanResult existedResult) {
        if (existedResult.archived()) {
            throw new RuntimeException("Cannot merge into a archived audit plan results " + existedResult.id());
        }
        existedResult.remark_$eq(newResult.remark());
        existedResult.updatedAt_$eq(Instant.now());
        existedResult.requiredCredits_$eq(newResult.requiredCredits());
        existedResult.owedCredits_$eq(newResult.owedCredits());
        existedResult.owedCredits2_$eq(newResult.owedCredits2());
        existedResult.owedCredits3_$eq(newResult.owedCredits3());
        existedResult.passedCredits_$eq(newResult.passedCredits());
        existedResult.passed_$eq(newResult.passed());
        existedResult.predicted_$eq(newResult.predicted());
        StringBuilder updates = new StringBuilder();
        this.mergePlanResult(existedResult, newResult, updates);
        if (updates.nonEmpty()) {
            updates.deleteCharAt(updates.length() - 1);
        }
        existedResult.updates_$eq((Option)Some$.MODULE$.apply((Object)updates.toString()));
        return existedResult;
    }

    private void mergePlanResult(AuditPlanResult target, AuditPlanResult source, StringBuilder updates) {
        Map tarGroupResults = Collections$.MODULE$.newMap();
        Map sourceGroupResults = Collections$.MODULE$.newMap();
        Seq tarTops = target.topGroupResults();
        Seq srcTops = source.topGroupResults();
        tarTops.foreach((Function1 & Serializable)result -> tarGroupResults.put((Object)result.name(), result));
        tarTops.foreach((Function1)(JProcedure1 & Serializable)result -> {
            if (!tarGroupResults.get((Object)result.name()).contains(result)) {
                result.parent().foreach((Function1)(JProcedure1 & Serializable)p -> p.removeChild(result));
                target.removeGroupResult(result);
                return;
            }
        });
        srcTops.foreach((Function1 & Serializable)result -> sourceGroupResults.put((Object)result.name(), result));
        List removed = Collections$.MODULE$.subtract((Iterable)tarGroupResults.keySet(), (Iterable)sourceGroupResults.keySet());
        removed.foreach((Function1)(JProcedure1 & Serializable)groupName -> ((AuditGroupResult)tarGroupResults.apply(groupName)).detach());
        List added = Collections$.MODULE$.subtract((Iterable)sourceGroupResults.keySet(), (Iterable)tarGroupResults.keySet());
        added.foreach((Function1)(JProcedure1 & Serializable)groupName -> ((AuditGroupResult)sourceGroupResults.apply(groupName)).attachTo(target));
        List common = Collections$.MODULE$.intersection((Iterable)sourceGroupResults.keySet(), (Iterable)tarGroupResults.keySet());
        common.foreach((Function1)(JProcedure1 & Serializable)groupName -> MODULE$.mergeGroupResult(target, (AuditGroupResult)tarGroupResults.apply(groupName), (AuditGroupResult)sourceGroupResults.apply(groupName), updates));
    }

    private void mergeGroupResult(AuditPlanResult existedResult, AuditGroupResult target, AuditGroupResult source, StringBuilder updates) {
        float delta = source.passedCredits() - target.passedCredits();
        if (Float.compare(delta, 0.0f) != 0) {
            updates.append(source.name());
            StringBuilder stringBuilder = delta > 0.0f ? updates.append('+').append(delta) : updates.append(delta);
            updates.append(';');
        }
        target.indexno_$eq(source.indexno());
        target.requiredCredits_$eq(source.requiredCredits());
        target.subCount_$eq(source.subCount());
        target.passed_$eq(source.passed());
        target.convertedCredits_$eq(source.convertedCredits());
        target.passedCredits_$eq(source.passedCredits());
        target.owedCredits_$eq(source.owedCredits());
        target.owedCredits2_$eq(source.owedCredits2());
        target.owedCredits3_$eq(source.owedCredits3());
        Map tarGroupResults = Collections$.MODULE$.newMap();
        Map sourceGroupResults = Collections$.MODULE$.newMap();
        target.children().foreach((Function1 & Serializable)result -> tarGroupResults.put((Object)result.name(), result));
        source.children().foreach((Function1 & Serializable)result -> sourceGroupResults.put((Object)result.name(), result));
        Map tarCourseResults = Collections$.MODULE$.newMap();
        Map sourceCourseResults = Collections$.MODULE$.newMap();
        target.courseResults().foreach((Function1 & Serializable)courseResult -> tarCourseResults.put((Object)courseResult.course(), courseResult));
        source.courseResults().foreach((Function1 & Serializable)courseResult -> sourceCourseResults.put((Object)courseResult.course(), courseResult));
        List removed = Collections$.MODULE$.subtract((Iterable)tarGroupResults.keySet(), (Iterable)sourceGroupResults.keySet());
        removed.foreach((Function1)(JProcedure1 & Serializable)groupName -> {
            AuditGroupResult gg = (AuditGroupResult)tarGroupResults.apply(groupName);
            gg.detach();
            target.removeChild(gg);
        });
        List added = Collections$.MODULE$.subtract((Iterable)sourceGroupResults.keySet(), (Iterable)tarGroupResults.keySet());
        added.foreach((Function1)(JProcedure1 & Serializable)groupName -> {
            AuditGroupResult groupResult = (AuditGroupResult)sourceGroupResults.apply(groupName);
            target.addChild(groupResult);
            groupResult.attachTo(existedResult);
        });
        List common = Collections$.MODULE$.intersection((Iterable)sourceGroupResults.keySet(), (Iterable)tarGroupResults.keySet());
        common.foreach((Function1)(JProcedure1 & Serializable)groupName -> MODULE$.mergeGroupResult(existedResult, (AuditGroupResult)tarGroupResults.apply(groupName), (AuditGroupResult)sourceGroupResults.apply(groupName), updates));
        List removedCourses = Collections$.MODULE$.subtract((Iterable)tarCourseResults.keySet(), (Iterable)sourceCourseResults.keySet());
        removedCourses.foreach((Function1 & Serializable)course -> {
            AuditCourseResult courseResult = (AuditCourseResult)tarCourseResults.apply(course);
            return (Buffer)target.courseResults().$minus$eq((Object)courseResult);
        });
        List addedCourses = Collections$.MODULE$.subtract((Iterable)sourceCourseResults.keySet(), (Iterable)tarCourseResults.keySet());
        addedCourses.foreach((Function1 & Serializable)course -> {
            AuditCourseResult courseResult = (AuditCourseResult)sourceCourseResults.apply(course);
            courseResult.groupResult().courseResults().$minus$eq((Object)courseResult);
            courseResult.groupResult_$eq(target);
            return (Buffer)target.courseResults().$plus$eq((Object)courseResult);
        });
        List commonCourses = Collections$.MODULE$.intersection((Iterable)sourceCourseResults.keySet(), (Iterable)tarCourseResults.keySet());
        commonCourses.foreach((Function1)(JProcedure1 & Serializable)course -> {
            AuditCourseResult tar = (AuditCourseResult)tarCourseResults.apply(course);
            AuditCourseResult src = (AuditCourseResult)sourceCourseResults.apply(course);
            tar.passed_$eq(src.passed());
            tar.scores_$eq(src.scores());
            tar.compulsory_$eq(src.compulsory());
            tar.hasGrade_$eq(src.hasGrade());
            tar.predicted_$eq(src.predicted());
            tar.taking_$eq(src.taking());
            tar.passedWay_$eq(src.passedWay());
            tar.remark_$eq(src.remark());
        });
    }
}

