/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.service;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.logging.Logging;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.CourseJournal;
import org.openurp.base.edu.model.CourseJournalHour;
import org.openurp.base.edu.model.Terms$;
import org.openurp.code.edu.model.CourseModule;
import org.openurp.code.edu.model.CourseRank;
import org.openurp.code.edu.model.CourseRank$;
import org.openurp.code.edu.model.CourseType;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.code.edu.model.TeachingNature$;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.service.CategoryStat;
import org.openurp.edu.program.service.PlanCategoryStat$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Short$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class PlanCategoryStat
implements Logging {
    private Logger logger;
    private final CoursePlan plan;
    private final float credits;
    private final Seq<TeachingNature> natures;
    private TeachingNature lectureNature;
    private TeachingNature practicalNature;
    private short maxterm;
    private boolean hasOptional;
    private final Buffer categoryStats;
    private final EducationLevel level;

    public static PlanCategoryStat stat(CoursePlan coursePlan, Seq<TeachingNature> seq) {
        return PlanCategoryStat$.MODULE$.stat(coursePlan, seq);
    }

    public PlanCategoryStat(CoursePlan plan, float credits, Seq<TeachingNature> natures) {
        this.plan = plan;
        this.credits = credits;
        this.natures = natures;
        Logging.$init$((Logging)this);
        this.lectureNature = (TeachingNature)natures.find((Function1 & Serializable)_$2 -> BoxesRunTime.unboxToInt((Object)_$2.id()) == 1).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.practicalNature = (TeachingNature)natures.find((Function1 & Serializable)_$3 -> BoxesRunTime.unboxToInt((Object)_$3.id()) == 9).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.maxterm = plan.program().endTerm();
        this.hasOptional = false;
        this.categoryStats = Collections$.MODULE$.newBuffer();
        this.level = plan.program().level();
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public float credits() {
        return this.credits;
    }

    public TeachingNature lectureNature() {
        return this.lectureNature;
    }

    public void lectureNature_$eq(TeachingNature x$1) {
        this.lectureNature = x$1;
    }

    public TeachingNature practicalNature() {
        return this.practicalNature;
    }

    public void practicalNature_$eq(TeachingNature x$1) {
        this.practicalNature = x$1;
    }

    public short maxterm() {
        return this.maxterm;
    }

    public void maxterm_$eq(short x$1) {
        this.maxterm = x$1;
    }

    public boolean hasOptional() {
        return this.hasOptional;
    }

    public void hasOptional_$eq(boolean x$1) {
        this.hasOptional = x$1;
    }

    public Buffer<CategoryStat> categoryStats() {
        return this.categoryStats;
    }

    public void statOptionalGroup(CourseGroup group, CategoryStat theory, CategoryStat practical) {
        this.hasOptional_$eq(true);
        scala.collection.immutable.Map ghours = group.getHours(this.natures);
        ghours.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                TeachingNature n = (TeachingNature)tuple2._1();
                int hours = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (group.courseType().practical()) {
                    if (BoxesRunTime.unboxToInt((Object)n.id()) == TeachingNature$.MODULE$.Practice()) {
                        Object[] objectArray = new Tuple2[1];
                        TeachingNature teachingNature = (TeachingNature)Predef$.MODULE$.ArrowAssoc((Object)this.practicalNature());
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)teachingNature, (Object)BoxesRunTime.boxToInteger((int)hours));
                        practical.addGroup(group.credits(), (Map<TeachingNature, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), group.termCredits());
                        return;
                    }
                    Object[] objectArray = new Tuple2[1];
                    TeachingNature teachingNature = (TeachingNature)Predef$.MODULE$.ArrowAssoc((Object)this.lectureNature());
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)teachingNature, (Object)BoxesRunTime.boxToInteger((int)hours));
                    theory.addCourse(0.0f, (Map<TeachingNature, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), Terms$.MODULE$.empty());
                    return;
                }
                if (BoxesRunTime.unboxToInt((Object)n.id()) == TeachingNature$.MODULE$.Theory()) {
                    Object[] objectArray = new Tuple2[1];
                    TeachingNature teachingNature = (TeachingNature)Predef$.MODULE$.ArrowAssoc((Object)this.lectureNature());
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)teachingNature, (Object)BoxesRunTime.boxToInteger((int)hours));
                    theory.addGroup(group.credits(), (Map<TeachingNature, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), group.termCredits());
                    return;
                }
                Object[] objectArray = new Tuple2[1];
                TeachingNature teachingNature = (TeachingNature)Predef$.MODULE$.ArrowAssoc((Object)this.practicalNature());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)teachingNature, (Object)BoxesRunTime.boxToInteger((int)hours));
                practical.addCourse(0.0f, (Map<TeachingNature, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), Terms$.MODULE$.empty());
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Option<Object> isPurePractical(Course course, CourseJournal courseJournal, CourseType courseType) {
        if (courseJournal.hours().isEmpty()) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((course.practical() || courseType.module().exists((Function1 & Serializable)_$4 -> _$4.practical()) ? 1 : 0) != 0));
        }
        Buffer hours = (Buffer)courseJournal.hours().filter((Function1 & Serializable)_$5 -> _$5.creditHours() > 0);
        if (hours.size() == 1) {
            CourseJournalHour h = (CourseJournalHour)hours.head();
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((BoxesRunTime.unboxToInt((Object)h.nature().id()) == BoxesRunTime.unboxToInt((Object)this.practicalNature().id()) ? 1 : 0) != 0));
        }
        return None$.MODULE$;
    }

    public void org$openurp$edu$program$service$PlanCategoryStat$$statCompulsoryGroup(CourseGroup g) {
        CategoryStat theory = this.org$openurp$edu$program$service$PlanCategoryStat$$getOrCreateCategory(g, true, false, false, Short$.MODULE$.short2int(this.maxterm()));
        CategoryStat innerTheory = this.org$openurp$edu$program$service$PlanCategoryStat$$getOrCreateCategory(g, true, false, true, Short$.MODULE$.short2int(this.maxterm()));
        CategoryStat practical = this.org$openurp$edu$program$service$PlanCategoryStat$$getOrCreateCategory(g, true, true, false, Short$.MODULE$.short2int(this.maxterm()));
        CategoryStat innerPractical = this.org$openurp$edu$program$service$PlanCategoryStat$$getOrCreateCategory(g, true, true, true, Short$.MODULE$.short2int(this.maxterm()));
        g.orderedPlanCourses().foreach((Function1)(JProcedure1 & Serializable)pc -> {
            CourseJournal cj;
            Course c = pc.course();
            Option<Object> option = this.isPurePractical(c, cj = c.getJournal(this.plan.program().grade()), g.courseType());
            if (option instanceof Some) {
                boolean pp = BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
                if (pp) {
                    Object[] objectArray = new Tuple2[1];
                    TeachingNature teachingNature = (TeachingNature)Predef$.MODULE$.ArrowAssoc((Object)this.practicalNature());
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)teachingNature, (Object)BoxesRunTime.boxToInteger((int)cj.creditHours()));
                    practical.addCourse(c.getCredits(this.level), (Map<TeachingNature, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), pc.terms());
                    return;
                }
                Object[] objectArray = new Tuple2[1];
                TeachingNature teachingNature = (TeachingNature)Predef$.MODULE$.ArrowAssoc((Object)this.lectureNature());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)teachingNature, (Object)BoxesRunTime.boxToInteger((int)cj.creditHours()));
                theory.addCourse(c.getCredits(this.level), (Map<TeachingNature, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), pc.terms());
                return;
            }
            if (None$.MODULE$.equals(option)) {
                cj.hours().foreach((Function1)(JProcedure1 & Serializable)h -> {
                    if (c.practical() || g.courseType().module().nonEmpty() && ((CourseModule)g.courseType().module().get()).practical()) {
                        if (BoxesRunTime.unboxToInt((Object)h.nature().id()) == BoxesRunTime.unboxToInt((Object)this.practicalNature().id())) {
                            Object[] objectArray = new Tuple2[1];
                            TeachingNature teachingNature = (TeachingNature)Predef$.MODULE$.ArrowAssoc((Object)this.practicalNature());
                            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)teachingNature, (Object)BoxesRunTime.boxToInteger((int)h.creditHours()));
                            practical.addCourse(c.getCredits(this.level), (Map<TeachingNature, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), pc.terms());
                            return;
                        }
                        Object[] objectArray = new Tuple2[1];
                        TeachingNature teachingNature = (TeachingNature)Predef$.MODULE$.ArrowAssoc((Object)this.lectureNature());
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)teachingNature, (Object)BoxesRunTime.boxToInteger((int)h.creditHours()));
                        innerTheory.addCourse(0.0f, (Map<TeachingNature, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), Terms$.MODULE$.empty());
                        return;
                    }
                    if (BoxesRunTime.unboxToInt((Object)h.nature().id()) == BoxesRunTime.unboxToInt((Object)this.lectureNature().id())) {
                        Object[] objectArray = new Tuple2[1];
                        TeachingNature teachingNature = (TeachingNature)Predef$.MODULE$.ArrowAssoc((Object)this.lectureNature());
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)teachingNature, (Object)BoxesRunTime.boxToInteger((int)h.creditHours()));
                        theory.addCourse(c.getCredits(this.level), (Map<TeachingNature, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), pc.terms());
                        return;
                    }
                    Object[] objectArray = new Tuple2[1];
                    TeachingNature teachingNature = (TeachingNature)Predef$.MODULE$.ArrowAssoc((Object)this.practicalNature());
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)teachingNature, (Object)BoxesRunTime.boxToInteger((int)h.creditHours()));
                    innerPractical.addCourse(0.0f, (Map<TeachingNature, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), Terms$.MODULE$.empty());
                });
                return;
            }
            throw new MatchError(option);
        });
        g.children().foreach((Function1)(JProcedure1 & Serializable)child -> {
            if (child.optional()) {
                this.statOptionalGroup((CourseGroup)child, theory, practical);
                return;
            }
            this.org$openurp$edu$program$service$PlanCategoryStat$$statCompulsoryGroup((CourseGroup)child);
        });
    }

    public CategoryStat org$openurp$edu$program$service$PlanCategoryStat$$getOrCreateCategory(CourseGroup group, boolean compulsory, boolean practical, boolean inner, int maxTerm) {
        CategoryStat categoryStat;
        Object object = new Object();
        try {
            this.categoryStats().foreach((Function1)(JProcedure1 & Serializable)s -> {
                String string = s.name();
                String string2 = group.name();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    if (s.compulsory() == compulsory && s.practical() == practical && s.inner() == inner) {
                        throw new NonLocalReturnControl(object, s);
                    }
                }
            });
            CategoryStat newer = new CategoryStat(group.indexno() + " " + group.name(), (CourseRank)group.rank().get(), compulsory, practical, inner, maxTerm);
            this.categoryStats().addOne((Object)newer);
            categoryStat = newer;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                categoryStat = (CategoryStat)ex.value();
            }
            throw ex;
        }
        return categoryStat;
    }

    public CategoryStat optionalStat() {
        Buffer results = Collections$.MODULE$.newBuffer();
        this.categoryStats().foreach((Function1)(JProcedure1 & Serializable)cs -> {
            if (!cs.compulsory()) {
                results.addOne(cs);
                return;
            }
        });
        return this.merge((Seq<CategoryStat>)results);
    }

    public CategoryStat allStat() {
        return this.merge((Seq<CategoryStat>)this.categoryStats());
    }

    public CategoryStat theoreticalStat() {
        Buffer results = Collections$.MODULE$.newBuffer();
        this.categoryStats().foreach((Function1)(JProcedure1 & Serializable)cs -> {
            if (!cs.practical()) {
                results.addOne(cs);
                return;
            }
        });
        return this.merge((Seq<CategoryStat>)results);
    }

    public CategoryStat practicalStat() {
        Buffer results = Collections$.MODULE$.newBuffer();
        this.categoryStats().foreach((Function1)(JProcedure1 & Serializable)cs -> {
            if (cs.practical()) {
                results.addOne(cs);
                return;
            }
        });
        return this.merge((Seq<CategoryStat>)results);
    }

    public double practicalCredits() {
        DoubleRef total = DoubleRef.create((double)0.0);
        IntRef innerHours = IntRef.create((int)0);
        ((IterableOnceOps)this.categoryStats().sortBy((Function1 & Serializable)_$6 -> _$6.name(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)cs -> {
            if (cs.practical()) {
                if (cs.credits() > 0.0) {
                    total$1.elem += cs.credits();
                    return;
                }
                innerHours$1.elem += cs.hours();
                return;
            }
        });
        double c = total.elem + (double)innerHours.elem / 16.0;
        if (c % 1.0 >= 0.5) {
            if (c % 1.0 >= 0.7) {
                return Int$.MODULE$.int2double(Predef$.MODULE$.double2Double(c).intValue() + 1);
            }
            return (double)Predef$.MODULE$.double2Double(c).intValue() + 0.5;
        }
        return Int$.MODULE$.int2double(Predef$.MODULE$.double2Double(c).intValue());
    }

    public CategoryStat getCompulsoryStat(boolean containsPractical) {
        Buffer results = Collections$.MODULE$.newBuffer();
        this.categoryStats().foreach((Function1)(JProcedure1 & Serializable)cs -> {
            if (cs.compulsory()) {
                if (cs.practical()) {
                    if (containsPractical) {
                        results.addOne(cs);
                        return;
                    }
                    return;
                }
                results.addOne(cs);
                return;
            }
        });
        return this.merge((Seq<CategoryStat>)results);
    }

    private CategoryStat merge(Seq<CategoryStat> results) {
        if (results.isEmpty()) {
            return new CategoryStat("\u5408\u8ba1", null, false, false, false, 0);
        }
        CategoryStat head = (CategoryStat)results.head();
        if (results.size() == 1) {
            return head;
        }
        CategoryStat target = new CategoryStat(head);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), results.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> target.merge((CategoryStat)results.apply(i)));
        return target;
    }

    public CategoryStat designatedSelectiveStat() {
        Buffer results = Collections$.MODULE$.newBuffer();
        this.categoryStats().foreach((Function1)(JProcedure1 & Serializable)cs -> cs.rank().foreach((Function1)(JProcedure1 & Serializable)r -> {
            if (BoxesRunTime.unboxToInt((Object)r.id()) == CourseRank$.MODULE$.DesignatedSelective()) {
                results.addOne(cs);
                return;
            }
        }));
        return this.merge((Seq<CategoryStat>)results);
    }

    public CategoryStat freeSelectiveStat() {
        Buffer results = Collections$.MODULE$.newBuffer();
        this.categoryStats().foreach((Function1)(JProcedure1 & Serializable)cs -> cs.rank().foreach((Function1)(JProcedure1 & Serializable)r -> {
            if (BoxesRunTime.unboxToInt((Object)r.id()) == CourseRank$.MODULE$.FreeSelective() || BoxesRunTime.unboxToInt((Object)r.id()) == CourseRank$.MODULE$.Selective()) {
                results.addOne(cs);
                return;
            }
        }));
        return this.merge((Seq<CategoryStat>)results);
    }

    public boolean isHasOptional() {
        return this.hasOptional();
    }

    public boolean isHasPractice() {
        return this.practicalStat().credits() > 0.0;
    }
}

