/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.schedule.service;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import org.beangle.commons.bean.orderings.PropertyOrdering$;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.time.WeekDay;
import org.beangle.commons.lang.time.WeekState;
import org.beangle.commons.lang.time.WeekTime$;
import org.beangle.commons.lang.time.Weeks$;
import org.openurp.base.model.Semester;
import org.openurp.base.resource.model.Classroom;
import org.openurp.edu.clazz.domain.WeekTimeBuilder$;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.ClazzActivity;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.runtime.BooleanRef;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public final class ScheduleDigestor$
implements Serializable {
    private static final String singleTeacher;
    private static final String multiTeacher;
    private static final String moreThan1Teacher;
    private static final String day;
    private static final String units;
    private static final String weeks;
    private static final String time;
    private static final String room;
    private static final String building;
    private static final String district;
    private static final String clazz;
    private static final String course;
    private static final String starton;
    private static final String defaultFormat;
    private static final String delimeter;
    private static final String[] weekdayNamesCn;
    public static final ScheduleDigestor$ MODULE$;

    private ScheduleDigestor$() {
    }

    static {
        MODULE$ = new ScheduleDigestor$();
        singleTeacher = ":teacher1";
        multiTeacher = ":teacher+";
        moreThan1Teacher = ":teacher2";
        day = ":day";
        units = ":units";
        weeks = ":weeks";
        time = ":time";
        room = ":room";
        building = ":building";
        district = ":district";
        clazz = ":clazz";
        course = ":course";
        starton = ":starton";
        defaultFormat = ":teacher+ :day :units :weeks :room";
        delimeter = ",";
        weekdayNamesCn = new String[]{"empty", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d", "\u661f\u671f\u65e5"};
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ScheduleDigestor$.class);
    }

    public String singleTeacher() {
        return singleTeacher;
    }

    public String multiTeacher() {
        return multiTeacher;
    }

    public String moreThan1Teacher() {
        return moreThan1Teacher;
    }

    public String day() {
        return day;
    }

    public String units() {
        return units;
    }

    public String weeks() {
        return weeks;
    }

    public String time() {
        return time;
    }

    public String room() {
        return room;
    }

    public String building() {
        return building;
    }

    public String district() {
        return district;
    }

    public String clazz() {
        return clazz;
    }

    public String course() {
        return course;
    }

    public String starton() {
        return starton;
    }

    public String defaultFormat() {
        return defaultFormat;
    }

    public String[] weekdayNamesCn() {
        return weekdayNamesCn;
    }

    private boolean isSameActivityExcept(ClazzActivity target, ClazzActivity other, boolean teacher, boolean room) {
        if (teacher) {
            Set set = target.teachers();
            Set set2 = other.teachers();
            if (set == null ? set2 != null : !set.equals(set2)) {
                return false;
            }
        }
        if (room) {
            Set set = target.rooms();
            Set set3 = other.rooms();
            if (set == null ? set3 != null : !set.equals(set3)) {
                return false;
            }
        }
        return target.time().mergeable(other.time(), 31);
    }

    public Seq<ClazzActivity> merge(Semester semester, Iterable<ClazzActivity> activities, boolean hasTeacher, boolean hasRoom) {
        Buffer mergedActivities = Collections$.MODULE$.newBuffer();
        ObjectRef activitiesList = ObjectRef.create((Object)Collections$.MODULE$.newBuffer());
        activities.foreach((Function1 & Serializable)ca -> (Buffer)((Buffer)activitiesList$1.elem).addOne((Object)ca.clone()));
        activitiesList.elem = (Buffer)((Buffer)activitiesList.elem).sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        int semesterStartYear = semester.beginOn().getYear();
        ((Buffer)activitiesList.elem).foreach((Function1)(JProcedure1 & Serializable)ca -> {
            ClazzActivity activity = ca;
            if (ca.time().startOn().getYear() != semesterStartYear) {
                LocalDate nextYearStart = activity.time().startOn();
                LocalDate thisYearStart = WeekTime$.MODULE$.getStartOn(semesterStartYear, activity.time().weekday());
                int weeks = Weeks$.MODULE$.between(thisYearStart, nextYearStart);
                activity.time().startOn_$eq(thisYearStart);
                activity.time().weekstate_$eq(new WeekState(activity.time().weekstate().value() << weeks));
            }
            BooleanRef merged = BooleanRef.create((boolean)false);
            mergedActivities.foreach((Function1)(JProcedure1 & Serializable)added -> {
                Clazz clazz = added.clazz();
                Clazz clazz2 = activity.clazz();
                if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) && MODULE$.isSameActivityExcept((ClazzActivity)added, activity, hasTeacher, hasRoom)) {
                    added.mergeTime(activity);
                    merged$1.elem = true;
                    return;
                }
            });
            if (!merged.elem) {
                mergedActivities.addOne((Object)activity);
                return;
            }
        });
        return mergedActivities;
    }

    public String digest(Clazz clazz) {
        return this.digest(clazz, this.defaultFormat());
    }

    public String digest(Clazz clazz, String format) {
        return this.digest((Iterable<ClazzActivity>)clazz.schedule().activities(), format);
    }

    public String digest(Iterable<ClazzActivity> activities) {
        return this.digest(activities, this.defaultFormat());
    }

    public String digest(Iterable<ClazzActivity> activities, String f) {
        if (activities.isEmpty()) {
            return "";
        }
        ObjectRef format = ObjectRef.create((Object)f);
        if (Strings$.MODULE$.isEmpty((CharSequence)((String)format.elem))) {
            format.elem = this.defaultFormat();
        }
        Clazz clazzx = ((ClazzActivity)activities.iterator().next()).clazz();
        Semester semester = clazzx.semester();
        Set teachers = Collections$.MODULE$.newSet();
        boolean hasRoom = Strings$.MODULE$.contains((CharSequence)((String)format.elem), (CharSequence)this.room());
        boolean hasTeacher = Strings$.MODULE$.contains((CharSequence)((String)format.elem), (CharSequence)"teacher");
        if (hasTeacher) {
            activities.foreach((Function1)(JProcedure1 & Serializable)ca -> {
                if (ca.teachers().nonEmpty()) {
                    teachers.addAll((IterableOnce)ca.teachers());
                    return;
                }
            });
        }
        Seq mergedActivities = this.merge(semester, activities, hasTeacher, hasRoom);
        BooleanRef addTeacher = BooleanRef.create((boolean)false);
        if (hasTeacher) {
            addTeacher.elem = true;
            if (((String)format.elem).indexOf(this.singleTeacher()) != -1 && teachers.size() != 1) {
                addTeacher.elem = false;
            }
            if (((String)format.elem).indexOf(this.moreThan1Teacher()) != -1 && teachers.size() < 2) {
                addTeacher.elem = false;
            }
            if (((String)format.elem).indexOf(this.multiTeacher()) != -1 && teachers.isEmpty()) {
                addTeacher.elem = false;
            }
        }
        StringBuffer CourseArrangeBuf = new StringBuffer();
        mergedActivities = (Seq)mergedActivities.sorted(PropertyOrdering$.MODULE$.by("clazz.course.code,time.startOn"));
        mergedActivities.foreach((Function1 & Serializable)activity -> {
            CourseArrangeBuf.append((String)format$1.elem);
            IntRef replaceStart = IntRef.create((int)0);
            replaceStart.elem = CourseArrangeBuf.indexOf(":teacher");
            if (addTeacher$1.elem) {
                StringBuilder teacherStr = new StringBuilder("");
                activity.teachers().foreach((Function1 & Serializable)teacher -> teacherStr.append(teacher.name()));
                CourseArrangeBuf.replace(replaceStart.elem, replaceStart.elem + 9, teacherStr.toString());
            } else if (-1 != replaceStart.elem) {
                CourseArrangeBuf.replace(replaceStart.elem, replaceStart.elem + 9, "");
            }
            replaceStart.elem = CourseArrangeBuf.indexOf(MODULE$.day());
            if (-1 != replaceStart.elem) {
                WeekDay weekday = activity.time().weekday();
                CourseArrangeBuf.replace(replaceStart.elem, replaceStart.elem + MODULE$.day().length(), MODULE$.weekdayNamesCn()[weekday.id()]);
            }
            replaceStart.elem = CourseArrangeBuf.indexOf(MODULE$.units());
            if (-1 != replaceStart.elem) {
                CourseArrangeBuf.replace(replaceStart.elem, replaceStart.elem + MODULE$.units().length(), activity.beginUnit() + "-" + activity.endUnit());
            }
            replaceStart.elem = CourseArrangeBuf.indexOf(MODULE$.time());
            if (-1 != replaceStart.elem) {
                CourseArrangeBuf.replace(replaceStart.elem, replaceStart.elem + MODULE$.time().length(), activity.time().beginAt().toString() + "-" + activity.time().endAt().toString());
            }
            replaceStart.elem = CourseArrangeBuf.indexOf(MODULE$.clazz());
            if (-1 != replaceStart.elem) {
                CourseArrangeBuf.replace(replaceStart.elem, replaceStart.elem + MODULE$.clazz().length(), activity.clazz().crn());
            }
            replaceStart.elem = CourseArrangeBuf.indexOf(MODULE$.course());
            if (-1 != replaceStart.elem) {
                CourseArrangeBuf.replace(replaceStart.elem, replaceStart.elem + MODULE$.course().length(), activity.clazz().course().name() + "(" + activity.clazz().course().code() + ")");
            }
            replaceStart.elem = CourseArrangeBuf.indexOf(MODULE$.weeks());
            if (-1 != replaceStart.elem) {
                CourseArrangeBuf.replace(replaceStart.elem, replaceStart.elem + MODULE$.weeks().length(), WeekTimeBuilder$.MODULE$.digest(activity.time(), semester) + " ");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("M\u6708dd\u65e5\u8d77");
            replaceStart.elem = CourseArrangeBuf.indexOf(MODULE$.starton());
            if (-1 != replaceStart.elem) {
                activity.clazz().schedule().firstDateTime().foreach((Function1 & Serializable)f -> CourseArrangeBuf.replace(replaceStart$1.elem, replaceStart$1.elem + MODULE$.starton().length(), sdf.format(f)));
            }
            replaceStart.elem = CourseArrangeBuf.indexOf(MODULE$.room());
            if (-1 != replaceStart.elem) {
                Set rooms = activity.rooms();
                StringBuilder roomStr = new StringBuilder("");
                Iterator it = rooms.iterator();
                while (it.hasNext()) {
                    Classroom room = (Classroom)it.next();
                    roomStr.append(room.name());
                    if (!it.hasNext()) continue;
                    roomStr.append(",");
                }
                if (roomStr.isEmpty() && activity.remark().nonEmpty()) {
                    roomStr.append((String)activity.remark().get());
                }
                CourseArrangeBuf.replace(replaceStart.elem, replaceStart.elem + MODULE$.room().length(), roomStr.toString());
                replaceStart.elem = CourseArrangeBuf.indexOf(MODULE$.building());
                if (-1 != replaceStart.elem) {
                    StringBuilder buildingStr = new StringBuilder("");
                    Iterator iterator = rooms.iterator();
                    while (iterator.hasNext()) {
                        Classroom room = (Classroom)iterator.next();
                        room.building().foreach((Function1 & Serializable)b -> buildingStr.append(b.name()));
                        if (!iterator.hasNext()) continue;
                        buildingStr.append(",");
                    }
                    CourseArrangeBuf.replace(replaceStart.elem, replaceStart.elem + MODULE$.building().length(), buildingStr.toString());
                }
                replaceStart.elem = CourseArrangeBuf.indexOf(MODULE$.district());
                if (-1 != replaceStart.elem) {
                    StringBuilder districtStr = new StringBuilder("");
                    Iterator it2 = rooms.iterator();
                    while (it2.hasNext()) {
                        Classroom room = (Classroom)it2.next();
                        districtStr.append(room.campus().name());
                        if (!it2.hasNext()) continue;
                        districtStr.append(",");
                    }
                    CourseArrangeBuf.replace(replaceStart.elem, replaceStart.elem + MODULE$.district().length(), districtStr.toString());
                }
            }
            return CourseArrangeBuf.append(" ").append(delimeter);
        });
        if (CourseArrangeBuf.lastIndexOf(delimeter) != -1) {
            CourseArrangeBuf.delete(CourseArrangeBuf.lastIndexOf(delimeter), CourseArrangeBuf.length());
        }
        return CourseArrangeBuf.toString();
    }
}

