/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.audit;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.model.pojo.Hierarchical;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseAbilityRate;
import org.openurp.edu.clazz.model.StdCourseAbility;
import org.openurp.edu.grade.domain.AuditPlanContext;
import org.openurp.edu.grade.domain.AuditPlanListener;
import org.openurp.edu.grade.model.AuditCourseResult;
import org.openurp.edu.grade.model.AuditGroupResult;
import org.openurp.edu.grade.model.AuditPlanResult;
import org.openurp.edu.program.domain.AlternativeCourseProvider;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class AuditCourseAbilityListener
implements AuditPlanListener {
    private AlternativeCourseProvider alternativeCourseProvider;
    private EntityDao entityDao;

    public AlternativeCourseProvider alternativeCourseProvider() {
        return this.alternativeCourseProvider;
    }

    public void alternativeCourseProvider_$eq(AlternativeCourseProvider x$1) {
        this.alternativeCourseProvider = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public void start(AuditPlanContext context) {
        Student std = context.std();
        Set rates = ((IterableOnceOps)this.entityDao().findBy(StdCourseAbility.class, "std", (Object)context.std()).map((Function1 & Serializable)_$3 -> _$3.rate())).toSet();
        Map subjectRates = rates.groupBy((Function1 & Serializable)_$4 -> _$4.subject());
        AuditPlanResult result = context.result();
        context.sharePlan().foreach((Function1)(JProcedure1 & Serializable)sharePlan -> {
            Buffer groups = (Buffer)sharePlan.groups().filter((Function1 & Serializable)g -> g.courseAbilityRate().nonEmpty() && rates.contains(g.courseAbilityRate().get()) && result.getGroupResult(g.courseType().name()).nonEmpty() && ((Hierarchical)result.getGroupResult(g.courseType().name()).get()).children().isEmpty());
            if (groups.nonEmpty()) {
                scala.collection.mutable.Map abilityGroups = Collections$.MODULE$.newMap();
                groups.foreach((Function1)(JProcedure1 & Serializable)g -> {
                    AuditGroupResult auditGroupResult;
                    String groupName = g.courseType().name() + " " + ((CourseAbilityRate)g.courseAbilityRate().get()).subject().name();
                    AuditGroupResult subjectGroupResult = (AuditGroupResult)result.getGroupResult(g.courseType().name()).get();
                    BooleanRef overCredits = BooleanRef.create((boolean)false);
                    Option option = abilityGroups.get((Object)groupName);
                    if (None$.MODULE$.equals(option)) {
                        AuditGroupResult groupResult = new AuditGroupResult(groupName, g.courseType());
                        subjectGroupResult.subCount_$eq((short)1);
                        groupResult.indexno_$eq(subjectGroupResult.indexno() + ".1");
                        groupResult.planResult_$eq(context.result());
                        groupResult.requiredCredits_$eq(BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)g.planCourses().map((Function1 & Serializable)pc -> {
                            if (pc.compulsory()) {
                                return pc.course().getCredits(std.level());
                            }
                            return 0.0f;
                        })).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)));
                        if (groupResult.requiredCredits() > subjectGroupResult.requiredCredits()) {
                            groupResult.requiredCredits_$eq(subjectGroupResult.requiredCredits());
                            overCredits.elem = true;
                        }
                        abilityGroups.put((Object)groupName, (Object)groupResult);
                        result.addGroupResult(groupResult);
                        subjectGroupResult.addChild(groupResult);
                        auditGroupResult = groupResult;
                    } else if (option instanceof Some) {
                        AuditGroupResult gr = (AuditGroupResult)((Some)option).value();
                        float required = BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)g.planCourses().map((Function1 & Serializable)pc -> {
                            if (pc.compulsory()) {
                                return pc.course().getCredits(std.level());
                            }
                            return 0.0f;
                        })).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
                        if (required < gr.requiredCredits()) {
                            gr.requiredCredits_$eq(required);
                        }
                        if (gr.requiredCredits() > subjectGroupResult.requiredCredits()) {
                            gr.requiredCredits_$eq(subjectGroupResult.requiredCredits());
                            overCredits.elem = true;
                        }
                        auditGroupResult = gr;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    AuditGroupResult gr = auditGroupResult;
                    g.planCourses().foreach((Function1)(JProcedure1 & Serializable)pc -> {
                        AuditCourseResult cr = new AuditCourseResult(pc);
                        CourseAbilityRate rate = (CourseAbilityRate)pc.group().courseAbilityRate().get();
                        cr.addRemark(rate.name());
                        if (cr.compulsory() && (((IterableOnceOps)subjectRates.apply((Object)rate.subject())).size() > 1 || overCredits$1.elem)) {
                            cr.compulsory_$eq(false);
                        }
                        Option courseGrades = context.stdGrade().useGrade(pc.course());
                        cr.updatePassed(Option$.MODULE$.option2Iterable(courseGrades));
                        if (cr.passed() || pc.compulsory() || cr.hasGrade()) {
                            gr.addCourseResult(cr);
                            return;
                        }
                    });
                });
                return;
            }
        });
    }
}

