/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.impl;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.lang.Numbers$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.model.NumId;
import org.beangle.security.Securities$;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseTakeType$;
import org.openurp.code.edu.model.ExamStatus$;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.CourseGradeState;
import org.openurp.edu.grade.model.ExamGrade;
import org.openurp.edu.grade.model.GaGrade;
import org.openurp.edu.grade.model.Grade;
import org.openurp.edu.grade.service.CourseGradeCalculator;
import org.openurp.edu.grade.service.GradeRateService;
import org.openurp.edu.grade.service.ScoreConverter;
import org.openurp.edu.grade.service.impl.DefaultCourseGradeCalculator$;
import org.openurp.edu.service.Features;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.FloatRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class DefaultCourseGradeCalculator
implements CourseGradeCalculator {
    private EntityDao entityDao;
    private GradeRateService gradeRateService;
    private ProjectConfigService projectConfigService;
    private float minEndScore = 0.0f;
    private boolean endIsGaWhenFreeListening = true;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    @Override
    public GradeRateService gradeRateService() {
        return this.gradeRateService;
    }

    public void gradeRateService_$eq(GradeRateService x$1) {
        this.gradeRateService = x$1;
    }

    public ProjectConfigService projectConfigService() {
        return this.projectConfigService;
    }

    public void projectConfigService_$eq(ProjectConfigService x$1) {
        this.projectConfigService = x$1;
    }

    public float minEndScore() {
        return this.minEndScore;
    }

    public void minEndScore_$eq(float x$1) {
        this.minEndScore = x$1;
    }

    public boolean endIsGaWhenFreeListening() {
        return this.endIsGaWhenFreeListening;
    }

    public void endIsGaWhenFreeListening_$eq(boolean x$1) {
        this.endIsGaWhenFreeListening = x$1;
    }

    @Override
    public void calcFinal(CourseGrade grade) {
        if (!grade.published()) {
            grade.status_$eq(this.guessFinalStatus(grade));
        }
        this.updateScore(grade, this.calcScore(grade), null);
    }

    @Override
    public void calcAll(CourseGrade grade, CourseGradeState state) {
        this.calcEndGa(grade, state);
        this.calcMakeupDelayGa(grade, state);
    }

    @Override
    public GaGrade calcEndGa(CourseGrade grade, CourseGradeState state) {
        long stdId = BoxesRunTime.unboxToLong((Object)grade.std().id());
        grade.std_$eq((Student)this.entityDao().get(Student.class, (Object)BoxesRunTime.boxToLong((long)stdId)));
        GaGrade gag = this.getGaGrade(grade, DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$EndGa);
        Option<Object> gaScore = this.calcEndGaScore(grade, state);
        this.updateScore(gag, gaScore, null);
        if (!gag.published() && state != null) {
            gag.status_$eq(state.getStatus(gag.gradeType()));
        }
        if (!grade.published()) {
            grade.status_$eq(this.guessFinalStatus(grade));
        }
        if (gag.status() == grade.status()) {
            this.updateScore(grade, this.calcScore(grade), null);
        }
        return gag;
    }

    public Option<Object> calcEndGaScore(CourseGrade grade, CourseGradeState state) {
        BooleanRef isCheating = BooleanRef.create((boolean)false);
        grade.examGrades().withFilter((Function1 & Serializable)eg -> !isCheating$1.elem).foreach((Function1)(JProcedure1 & Serializable)eg -> {
            GradeType gradeType = eg.gradeType();
            GradeType gradeType2 = DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$Makeup;
            if (gradeType == null ? gradeType2 != null : !gradeType.equals(gradeType2)) {
                GradeType gradeType3 = eg.gradeType();
                GradeType gradeType4 = DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$Delay;
                if (gradeType3 == null ? gradeType4 != null : !gradeType3.equals(gradeType4)) {
                    if (eg.examStatus() != null && eg.examStatus().cheating()) {
                        isCheating$2.elem = true;
                        return;
                    }
                    return;
                }
            }
        });
        if (isCheating.elem) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.0f));
        }
        None$ ga = None$.MODULE$;
        GaGrade gaGrade = (GaGrade)grade.getGaGrade(DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$EndGa).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (gaGrade != null) {
            ga = gaGrade.score();
            if (grade.examGrades().isEmpty()) {
                return ga;
            }
        }
        ExamGrade endGrade = (ExamGrade)grade.getExamGrade(DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$End).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        gaGrade = this.getGaGrade(grade, DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$EndGa);
        if (endGrade != null) {
            if (this.endIsGaWhenFreeListening() && grade.freeListening()) {
                return this.addDelta(gaGrade, (Option<Object>)endGrade.score(), state);
            }
            if (!this.hasDelta(gaGrade) && endGrade.score().isDefined() && Float.compare(BoxesRunTime.unboxToFloat((Object)endGrade.score().get()), this.minEndScore()) < 0) {
                return this.addDelta(gaGrade, (Option<Object>)endGrade.score(), state);
            }
        }
        FloatRef totalGa = FloatRef.create((float)0.0f);
        FloatRef totalPercent = FloatRef.create((float)0.0f);
        FloatRef scorePercent = FloatRef.create((float)0.0f);
        BooleanRef hasEmptyEndGrade = BooleanRef.create((boolean)false);
        grade.examGrades().withFilter((Function1 & Serializable)examGrade -> {
            GradeType gradeType = examGrade.gradeType();
            GradeType gradeType2 = DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$Delay;
            return gradeType == null ? gradeType2 != null : !gradeType.equals(gradeType2);
        }).foreach((Function1)(JProcedure1 & Serializable)examGrade -> {
            GradeType gradeType = examGrade.gradeType();
            GradeType gradeType2 = DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$End;
            if (!(gradeType != null ? !gradeType.equals(gradeType2) : gradeType2 != null) && examGrade.score() == null) {
                hasEmptyEndGrade$1.elem = true;
            }
            this.getPercent((ExamGrade)examGrade, grade, state).foreach((Function1 & Serializable)v1 -> {
                DefaultCourseGradeCalculator.calcEndGaScore$$anonfun$4$$anonfun$1(examGrade, totalPercent, scorePercent, totalGa, BoxesRunTime.unboxToShort((Object)v1));
                return BoxedUnit.UNIT;
            });
        });
        if (totalPercent.elem < (float)100) {
            if (totalPercent.elem > 0.0f) {
                return null;
            }
            return gaGrade.score();
        }
        if (scorePercent.elem <= (float)51 || hasEmptyEndGrade.elem) {
            return null;
        }
        return this.addDelta(gaGrade, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)totalGa.elem)), state);
    }

    @Override
    public GaGrade calcMakeupDelayGa(CourseGrade grade, CourseGradeState state) {
        long stdId = BoxesRunTime.unboxToLong((Object)grade.std().id());
        grade.std_$eq((Student)this.entityDao().get(Student.class, (Object)BoxesRunTime.boxToLong((long)stdId)));
        List gatypes = (List)new .colon.colon((Object)DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$DelayGa, (List)new .colon.colon((Object)DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$MakeupGa, (List)Nil$.MODULE$));
        ObjectRef makeupDelayGa = ObjectRef.create(null);
        ObjectRef makeupDelayGrade = ObjectRef.create((Object)None$.MODULE$);
        gatypes.foreach((Function1)(JProcedure1 & Serializable)gatype -> {
            GaGrade gag = this.getGaGrade(grade, (GradeType)gatype);
            Option<Object> gaScore = None$.MODULE$;
            GradeType gradeType = gatype;
            GradeType gradeType2 = DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$DelayGa;
            if (!(gradeType != null ? !gradeType.equals(gradeType2) : gradeType2 != null)) {
                gaScore = this.calcDelayGaScore(grade, state);
                makeupDelayGrade$1.elem = grade.getExamGrade(DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$Delay);
            } else {
                gaScore = this.calcMakeupGaScore(grade, state);
                makeupDelayGrade$1.elem = grade.getExamGrade(DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$Makeup);
            }
            if (gaScore.isEmpty() && (((Option)makeupDelayGrade$1.elem).isEmpty() || BoxesRunTime.unboxToLong((Object)((NumId)((Option)makeupDelayGrade$1.elem).get()).id()) == (long)ExamStatus$.MODULE$.Normal())) {
                grade.getGaGrade(gatype).foreach((Function1 & Serializable)gaGrade -> (Buffer)grade.gaGrades().$minus$eq(gaGrade));
                return;
            }
            this.updateScore(gag, gaScore, null);
            if (!gag.published() && state != null) {
                gag.status_$eq(state.getStatus(gag.gradeType()));
            }
            makeupDelayGa$1.elem = gag;
        });
        if ((GaGrade)makeupDelayGa.elem != null) {
            if (!grade.published()) {
                grade.status_$eq(this.guessFinalStatus(grade));
            }
            if (((GaGrade)makeupDelayGa.elem).status() == grade.status()) {
                this.updateScore(grade, this.calcScore(grade), null);
            }
        }
        return (GaGrade)makeupDelayGa.elem;
    }

    private Option<Object> getPercent(ExamGrade eg, CourseGrade cg, CourseGradeState cgs) {
        if (eg.scorePercent().isDefined()) {
            return eg.scorePercent();
        }
        GradeType gradeType = eg.gradeType();
        GradeType gradeType2 = DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$Delay;
        if (!(gradeType != null ? !gradeType.equals(gradeType2) : gradeType2 != null)) {
            Option end = cg.getExamGrade(DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$End);
            if (end.isDefined() && ((ExamGrade)end.get()).scorePercent().isDefined()) {
                return ((ExamGrade)end.get()).scorePercent();
            }
            if (cgs == null) {
                return None$.MODULE$;
            }
            return cgs.getPercent(DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$End);
        }
        if (cgs == null) {
            return None$.MODULE$;
        }
        return cgs.getPercent(eg.gradeType());
    }

    public Option<Object> calcDelayGaScore(CourseGrade grade, CourseGradeState state) {
        ExamGrade deGrade;
        None$ gascore = None$.MODULE$;
        GaGrade gaGrade = (GaGrade)grade.getGaGrade(DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$DelayGa).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (gaGrade != null) {
            gascore = gaGrade.score();
            if (grade.getExamGrade(DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$Delay).isEmpty()) {
                return gascore;
            }
        }
        if ((deGrade = (ExamGrade)grade.getExamGrade(DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$Delay).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())) == null) {
            return None$.MODULE$;
        }
        if (deGrade.examStatus() != null && deGrade.examStatus().cheating()) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.0f));
        }
        boolean delayIsGa = BoxesRunTime.unboxToBoolean((Object)this.projectConfigService().get(grade.project(), Features.Grade$.MODULE$.DelayIsGa(), ClassTag$.MODULE$.apply(Boolean.TYPE)));
        if (delayIsGa) {
            return deGrade.score();
        }
        gaGrade = this.getGaGrade(grade, DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$DelayGa);
        if (this.endIsGaWhenFreeListening() && grade.freeListening()) {
            return this.addDelta(gaGrade, (Option<Object>)deGrade.score(), state);
        }
        if (!this.hasDelta(gaGrade) && deGrade.score().isDefined() && Float.compare(BoxesRunTime.unboxToFloat((Object)deGrade.score().get()), this.minEndScore()) < 0) {
            return this.addDelta(gaGrade, (Option<Object>)deGrade.score(), state);
        }
        FloatRef ga = FloatRef.create((float)0.0f);
        FloatRef totalPercent = FloatRef.create((float)0.0f);
        FloatRef scorePercent = FloatRef.create((float)0.0f);
        grade.examGrades().withFilter((Function1 & Serializable)examGrade -> {
            GradeType gradeType = examGrade.gradeType();
            GradeType gradeType2 = DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$End;
            return gradeType == null ? gradeType2 != null : !gradeType.equals(gradeType2);
        }).foreach((Function1)(JProcedure1 & Serializable)examGrade -> this.getPercent((ExamGrade)examGrade, grade, state).foreach((Function1 & Serializable)v1 -> {
            DefaultCourseGradeCalculator.calcDelayGaScore$$anonfun$2$$anonfun$1(examGrade, totalPercent, scorePercent, ga, BoxesRunTime.unboxToShort((Object)v1));
            return BoxedUnit.UNIT;
        }));
        if (totalPercent.elem < (float)100) {
            return None$.MODULE$;
        }
        if (scorePercent.elem < (float)51) {
            return None$.MODULE$;
        }
        return this.addDelta(gaGrade, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)ga.elem)), state);
    }

    public Option<Object> calcMakeupGaScore(CourseGrade grade, CourseGradeState gradeState) {
        Option option = grade.getExamGrade(DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$Makeup);
        if (None$.MODULE$.equals(option)) {
            return grade.getGaGrade(DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$MakeupGa).flatMap((Function1 & Serializable)_$4 -> _$4.score());
        }
        if (option instanceof Some) {
            ExamGrade m = (ExamGrade)((Some)option).value();
            if (m.examStatus() != null && m.examStatus().cheating()) {
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.0f));
            }
            if (m.score().isEmpty()) {
                return None$.MODULE$;
            }
            GaGrade gaGrade = this.getGaGrade(grade, DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$MakeupGa);
            this.addDelta(gaGrade, (Option<Object>)m.score(), gradeState);
            boolean makeupIsGa = BoxesRunTime.unboxToBoolean((Object)this.projectConfigService().get(grade.project(), Features.Grade$.MODULE$.MakeupIsGa(), ClassTag$.MODULE$.apply(Boolean.TYPE)));
            if (makeupIsGa) {
                return gaGrade.score();
            }
            if (Float.compare(BoxesRunTime.unboxToFloat((Object)gaGrade.score().get()), 60.0f) >= 0) {
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)60.0f));
            }
            return gaGrade.score();
        }
        throw new MatchError((Object)option);
    }

    public Option<Object> calcScore(CourseGrade grade) {
        ObjectRef best = ObjectRef.create((Object)None$.MODULE$);
        grade.gaGrades().withFilter((Function1 & Serializable)gg -> gg.score() != null && gg.score().isDefined()).foreach((Function1)(JProcedure1 & Serializable)gg -> {
            ObjectRef myScore = ObjectRef.create((Object)None$.MODULE$);
            GradeType gradeType = gg.gradeType();
            GradeType gradeType2 = DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$EndGa;
            if (gradeType == null ? gradeType2 != null : !gradeType.equals(gradeType2)) {
                if (gg.published()) {
                    myScore.elem = gg.score();
                }
            } else {
                myScore.elem = gg.score();
            }
            ((Option)myScore.elem).foreach((Function1)(JFunction1.mcVF.sp & Serializable)ms -> {
                Option option = (Option)best$2.elem;
                if (None$.MODULE$.equals(option)) {
                    best$2.elem = (Option)myScore$1.elem;
                    return;
                }
                if (option instanceof Some) {
                    float b = BoxesRunTime.unboxToFloat((Object)((Some)option).value());
                    if (Predef$.MODULE$.float2Float(ms).compareTo(Predef$.MODULE$.float2Float(b)) > 0) {
                        best$2.elem = Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)ms));
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)option);
            });
        });
        return (Option)best.elem;
    }

    private GaGrade getGaGrade(CourseGrade grade, GradeType gradeType) {
        Option option = grade.getGaGrade(gradeType);
        if (None$.MODULE$.equals(option)) {
            GaGrade gaGrade = new GaGrade();
            gaGrade.gradingMode_$eq(grade.gradingMode());
            gaGrade.gradeType_$eq(gradeType);
            gaGrade.createdAt_$eq(Instant.now());
            gaGrade.updatedAt_$eq(Instant.now());
            grade.addGaGrade(gaGrade);
            return gaGrade;
        }
        if (option instanceof Some) {
            GaGrade gaGrade = (GaGrade)((Some)option).value();
            return gaGrade;
        }
        throw new MatchError((Object)option);
    }

    private int guessFinalStatus(CourseGrade grade) {
        IntRef status = IntRef.create((int)Grade.Status$.MODULE$.New());
        grade.getGaGrade(DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$EndGa).foreach((Function1)(JProcedure1 & Serializable)ga -> {
            if (ga.status() > status$1.elem) {
                status$1.elem = ga.status();
                return;
            }
        });
        grade.getGaGrade(DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$MakeupGa).foreach((Function1)(JProcedure1 & Serializable)ga -> {
            if (ga.status() > status$2.elem) {
                status$2.elem = ga.status();
                return;
            }
        });
        grade.getGaGrade(DefaultCourseGradeCalculator$.org$openurp$edu$grade$service$impl$DefaultCourseGradeCalculator$$$DelayGa).foreach((Function1)(JProcedure1 & Serializable)ga -> {
            if (ga.status() > status$3.elem) {
                status$3.elem = ga.status();
                return;
            }
        });
        return status.elem;
    }

    @Override
    public void updateScore(CourseGrade grade, Option<Object> score, GradingMode newStyle) {
        GradingMode gradingMode = newStyle;
        if (gradingMode == null) {
            gradingMode = grade.gradingMode();
        } else {
            grade.gradingMode_$eq(gradingMode);
        }
        ScoreConverter converter = this.gradeRateService().getConverter(grade.project(), gradingMode);
        grade.score_$eq(score);
        grade.scoreText_$eq(converter.convert(score));
        if (grade.courseTakeType() != null && BoxesRunTime.unboxToInt((Object)grade.courseTakeType().id()) == CourseTakeType$.MODULE$.Exemption()) {
            grade.passed_$eq(true);
        } else {
            grade.passed_$eq(converter.passed((Option<Object>)grade.score()));
        }
        grade.gp_$eq(converter.calcGp((Option<Object>)grade.score()));
        grade.operator_$eq((Option)Some$.MODULE$.apply((Object)Securities$.MODULE$.user()));
        grade.updatedAt_$eq(Instant.now());
    }

    @Override
    public void updateScore(ExamGrade eg, Option<Object> score, GradingMode newStyle) {
        eg.score_$eq(score);
        GradingMode gradingMode = newStyle;
        if (gradingMode == null) {
            gradingMode = eg.gradingMode();
        } else {
            eg.gradingMode_$eq(gradingMode);
        }
        ScoreConverter converter = this.gradeRateService().getConverter(eg.courseGrade().project(), eg.gradingMode());
        eg.scoreText_$eq(converter.convert((Option<Object>)eg.score()));
        eg.passed_$eq(converter.passed((Option<Object>)eg.score()));
        eg.updatedAt_$eq(Instant.now());
        eg.operator_$eq((Option)Some$.MODULE$.apply((Object)Securities$.MODULE$.user()));
    }

    @Override
    public void updateScore(GaGrade gag, Option<Object> score, GradingMode newStyle) {
        gag.score_$eq(score);
        GradingMode gradingMode = newStyle;
        if (gradingMode == null) {
            gradingMode = gag.gradingMode();
        } else {
            gag.gradingMode_$eq(gradingMode);
        }
        ScoreConverter converter = this.gradeRateService().getConverter(gag.courseGrade().project(), gradingMode);
        gag.scoreText_$eq(converter.convert((Option<Object>)gag.score()));
        gag.passed_$eq(converter.passed((Option<Object>)gag.score()));
        gag.updatedAt_$eq(Instant.now());
        gag.operator_$eq((Option)Some$.MODULE$.apply((Object)Securities$.MODULE$.user()));
        gag.gp_$eq(converter.calcGp((Option<Object>)gag.score()));
    }

    public boolean hasDelta(GaGrade gaGrade) {
        return gaGrade.delta().isDefined();
    }

    public float getDelta(GaGrade gaGrade, Option<Object> score, CourseGradeState state) {
        return BoxesRunTime.unboxToFloat((Object)gaGrade.delta().getOrElse(DefaultCourseGradeCalculator::getDelta$$anonfun$1));
    }

    private Option<Object> addDelta(GaGrade gaGrade, Option<Object> score, CourseGradeState state) {
        if (score.isEmpty()) {
            return None$.MODULE$;
        }
        float delta = this.getDelta(gaGrade, score, state);
        Project project = gaGrade.courseGrade().project();
        float ga = this.reserve(project, delta + BoxesRunTime.unboxToFloat((Object)score.get()), state);
        gaGrade.score_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)ga)));
        return gaGrade.score();
    }

    public float reserve(Project project, float score, CourseGradeState state) {
        return (float)Numbers$.MODULE$.round((double)score, state == null ? this.getDefaultScorePrecision(project) : state.scorePrecision());
    }

    private int getDefaultScorePrecision(Project project) {
        return this.projectConfigService().getInt(project, Features.Grade$.MODULE$.ScorePrecision());
    }

    private static final /* synthetic */ void calcEndGaScore$$anonfun$4$$anonfun$1(ExamGrade examGrade$1, FloatRef totalPercent$2, FloatRef scorePercent$2, FloatRef totalGa$2, short myPercent) {
        if (examGrade$1.score().isDefined() || examGrade$1.examStatus() != null && BoxesRunTime.unboxToInt((Object)examGrade$1.examStatus().id()) != ExamStatus$.MODULE$.Normal()) {
            totalPercent$2.elem += (float)myPercent;
            examGrade$1.score().foreach((Function1)(JFunction1.mcVF.sp & Serializable)score -> {
                scorePercent$3.elem += (float)myPercent;
                totalGa$3.elem += (float)myPercent / 100.0f * score;
            });
            return;
        }
    }

    private static final /* synthetic */ void calcDelayGaScore$$anonfun$2$$anonfun$1(ExamGrade examGrade$2, FloatRef totalPercent$4, FloatRef scorePercent$5, FloatRef ga$2, short myPercent) {
        if (examGrade$2.score() != null || examGrade$2.examStatus() != null && BoxesRunTime.unboxToInt((Object)examGrade$2.examStatus().id()) != ExamStatus$.MODULE$.Normal()) {
            totalPercent$4.elem += (float)myPercent;
            examGrade$2.score().foreach((Function1)(JFunction1.mcVF.sp & Serializable)score -> {
                scorePercent$6.elem += (float)myPercent;
                ga$3.elem += (float)myPercent / 100.0f * score;
            });
            return;
        }
    }

    private static final float getDelta$$anonfun$1() {
        return 0.0f;
    }
}

