/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.stat;

import java.io.Serializable;
import org.beangle.commons.bean.orderings.PropertyOrdering;
import org.beangle.commons.collection.Collections$;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.Semester;
import org.openurp.base.std.model.Squad;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.service.stat.CourseStdNum;
import org.openurp.edu.grade.service.stat.StdGrade;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class MultiStdGrade {
    private Semester semester;
    private float ratio;
    private Squad squad;
    private Buffer courses;
    private scala.collection.immutable.Seq stdGrades;
    private scala.collection.mutable.Map extraGradeMap;
    private int maxDisplay;

    public MultiStdGrade(Semester semester, Map<Student, scala.collection.immutable.Seq<CourseGrade>> grades, float ratio) {
        this.semester = semester;
        this.ratio = ratio;
        this.courses = Collections$.MODULE$.newBuffer();
        this.stdGrades = null;
        this.extraGradeMap = Collections$.MODULE$.newMap();
        if (!grades.isEmpty()) {
            scala.collection.mutable.Map gradesMap = Collections$.MODULE$.newMap();
            scala.collection.mutable.Map courseStdNumMap = Collections$.MODULE$.newMap();
            grades.withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Student key = (Student)tuple2._1();
                    scala.collection.immutable.Seq value = (scala.collection.immutable.Seq)tuple2._2();
                    return true;
                }
                return false;
            }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Student key = (Student)tuple2._1();
                    scala.collection.immutable.Seq value = (scala.collection.immutable.Seq)tuple2._2();
                    StdGrade stdGrade = new StdGrade(key, (scala.collection.immutable.Seq<CourseGrade>)value, null, null);
                    gradesMap.put(key.id(), (Object)stdGrade);
                    value.foreach((Function1 & Serializable)grade -> {
                        CourseStdNum courseStdNum = (CourseStdNum)courseStdNumMap.get((Object)grade.course());
                        if (courseStdNum == null) {
                            return courseStdNumMap.put((Object)grade.course(), (Object)new CourseStdNum(grade.course(), 1));
                        }
                        courseStdNum.count_$eq(courseStdNum.count() + 1);
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            this.stdGrades_$eq((scala.collection.immutable.Seq<StdGrade>)gradesMap.values().toSeq());
            scala.collection.immutable.Seq courseStdNums = (scala.collection.immutable.Seq)courseStdNumMap.values().toSeq().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            IntRef maxStdCount = IntRef.create((int)0);
            if (Collections$.MODULE$.isNotEmpty((Iterable)courseStdNums)) {
                maxStdCount.elem = ((CourseStdNum)courseStdNums.head()).count();
            }
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), courseStdNums.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                CourseStdNum rank = (CourseStdNum)courseStdNums.apply(i);
                if ((float)rank.count() / (float)maxStdCount$1.elem > this.ratio()) {
                    this.courses().$plus$eq((Object)rank.course());
                    return;
                }
            });
            int maxExtra = 0;
            for (StdGrade stdGrade : this.stdGrades()) {
                int myExtra = 0;
                Buffer extraGrades = Collections$.MODULE$.newBuffer();
                Set commonCourseSet = Collections$.MODULE$.newSet();
                for (CourseGrade courseGrade : stdGrade.grades()) {
                    if (commonCourseSet.contains((Object)courseGrade.course())) continue;
                    extraGrades.$plus$eq((Object)courseGrade);
                    ++myExtra;
                }
                if (myExtra > maxExtra) {
                    maxExtra = myExtra;
                }
                this.maxDisplay_$eq(this.courses().size() + maxExtra);
                if (!extraGrades.nonEmpty()) continue;
                this.extraGradeMap().put((Object)stdGrade.std().id().toString(), (Object)extraGrades);
            }
        }
    }

    public Semester semester() {
        return this.semester;
    }

    public void semester_$eq(Semester x$1) {
        this.semester = x$1;
    }

    public float ratio() {
        return this.ratio;
    }

    public void ratio_$eq(float x$1) {
        this.ratio = x$1;
    }

    public Squad squad() {
        return this.squad;
    }

    public void squad_$eq(Squad x$1) {
        this.squad = x$1;
    }

    public Buffer<Course> courses() {
        return this.courses;
    }

    public void courses_$eq(Buffer<Course> x$1) {
        this.courses = x$1;
    }

    public scala.collection.immutable.Seq<StdGrade> stdGrades() {
        return this.stdGrades;
    }

    public void stdGrades_$eq(scala.collection.immutable.Seq<StdGrade> x$1) {
        this.stdGrades = x$1;
    }

    public scala.collection.mutable.Map<String, Seq<CourseGrade>> extraGradeMap() {
        return this.extraGradeMap;
    }

    public void extraGradeMap_$eq(scala.collection.mutable.Map<String, Seq<CourseGrade>> x$1) {
        this.extraGradeMap = x$1;
    }

    public int maxDisplay() {
        return this.maxDisplay;
    }

    public void maxDisplay_$eq(int x$1) {
        this.maxDisplay = x$1;
    }

    public void sortStdGrades(String cmpWhat, boolean isAsc) {
        if (this.stdGrades() != null) {
            PropertyOrdering cmp = new PropertyOrdering(cmpWhat, isAsc);
            this.stdGrades_$eq((scala.collection.immutable.Seq<StdGrade>)((scala.collection.immutable.Seq)this.stdGrades().sorted((Ordering)cmp)));
            return;
        }
    }

    public int extraCourseNum() {
        return this.maxDisplay() - this.courses().size();
    }
}

