/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.audit;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.pojo.Coded;
import org.openurp.base.edu.model.Course;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.domain.AuditPlanContext;
import org.openurp.edu.grade.domain.AuditPlanListener;
import org.openurp.edu.grade.model.AuditGroupResult;
import org.openurp.edu.grade.model.CoursePassedWay$;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.ExemptCourse;
import org.openurp.edu.program.model.StdExemptCourse;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class AuditExemptCourseListener
implements AuditPlanListener {
    private EntityDao entityDao;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public void start(AuditPlanContext context) {
        Student std = context.result().std();
        OqlBuilder query = OqlBuilder$.MODULE$.from(ExemptCourse.class, "ec");
        query.where("ec.project=:project and ec.level=:level", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std.project(), std.level()}));
        query.where("ec.fromGrade.code <= :gradeCode", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std.grade().code()}));
        query.cacheable(query.cacheable$default$1());
        Seq ecs = this.entityDao().search((QueryBuilder)query);
        Set exemptCourseTypes = Collections$.MODULE$.newSet();
        Set exemptCourses = Collections$.MODULE$.newSet();
        ecs.foreach((Function1)(JProcedure1 & Serializable)ec -> {
            if (ec.toGrade().isEmpty() || ((Coded)ec.toGrade().get()).code().compareTo(std.grade().code()) >= 0) {
                if (ec.stdTypes().contains((Object)std.stdType())) {
                    Option option = ec.course();
                    if (None$.MODULE$.equals(option)) {
                        exemptCourseTypes.add((Object)ec.courseType());
                        return;
                    }
                    if (option instanceof Some) {
                        Course c = (Course)((Some)option).value();
                        exemptCourses.add((Object)c);
                        return;
                    }
                    throw new MatchError((Object)option);
                }
                return;
            }
        });
        exemptCourses.$plus$plus$eq((IterableOnce)this.entityDao().findBy(StdExemptCourse.class, "std", (Object)std).map((Function1 & Serializable)_$2 -> _$2.course()));
        context.params().put((Object)"exemptCourseTypes", (Object)exemptCourseTypes.toSet());
        context.params().put((Object)"exemptCourses", (Object)exemptCourses.toSet());
    }

    public boolean startGroup(AuditPlanContext context, CourseGroup courseGroup, AuditGroupResult groupResult) {
        scala.collection.immutable.Set courseTypes = (scala.collection.immutable.Set)context.getParam("exemptCourseTypes", scala.collection.immutable.Set.class);
        return !courseTypes.contains((Object)courseGroup.courseType());
    }

    public void end(AuditPlanContext context) {
        if (context.result().passed()) {
            return;
        }
        Student std = context.result().std();
        scala.collection.immutable.Set exemptCourses = (scala.collection.immutable.Set)context.getParam("exemptCourses", scala.collection.immutable.Set.class);
        if (exemptCourses.isEmpty()) {
            return;
        }
        context.result().groupResults().foreach((Function1)(JProcedure1 & Serializable)groupResult -> {
            if (!groupResult.passed()) {
                groupResult.courseResults().foreach((Function1)(JProcedure1 & Serializable)car -> {
                    if (!car.passed() && exemptCourses.contains((Object)car.course())) {
                        car.scores_$eq("\u514d\u4fee");
                        car.passed_$eq(true);
                        car.passedWay_$eq((Option)Some$.MODULE$.apply((Object)CoursePassedWay$.ByExemption));
                        groupResult.addCourseResult(car);
                        return;
                    }
                });
                return;
            }
        });
    }
}

