/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.service.impl;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.CourseDirector;
import org.openurp.base.edu.model.TeachingOffice;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.model.User;
import org.openurp.code.edu.model.CourseType;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.course.model.CourseTask;
import org.openurp.edu.course.service.CourseTaskService;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class CourseTaskServiceImpl
implements CourseTaskService {
    private EntityDao entityDao;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    @Override
    public int initTask(Project project, Semester semester) {
        OqlBuilder builder = OqlBuilder$.MODULE$.from(Clazz.class.getName(), "clazz");
        builder.where("clazz.semester=:semester and clazz.project=:project and clazz.course.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester, project}));
        builder.join("clazz.teachers", "teacher");
        builder.select("clazz.course,clazz.courseType,teacher");
        Seq allTasks = this.entityDao().search((QueryBuilder)builder);
        Map allTasksMap = Collections$.MODULE$.newMap();
        allTasks.foreach((Function1 & Serializable)d -> {
            Course course = (Course)d[0];
            CourseType courseType = (CourseType)d[1];
            Teacher teacher = (Teacher)d[2];
            Map task = (Map)allTasksMap.getOrElseUpdate((Object)course, CourseTaskServiceImpl::$anonfun$1);
            Set ts = (Set)task.getOrElseUpdate((Object)courseType, CourseTaskServiceImpl::$anonfun$2);
            return (Set)ts.$plus$eq((Object)teacher);
        });
        OqlBuilder builder2 = OqlBuilder$.MODULE$.from(Clazz.class.getName(), "clazz");
        builder2.where("clazz.semester=:semester and clazz.project=:project and clazz.course.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester, project}));
        builder2.where("size(clazz.teachers)=0", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        builder2.select("clazz.course,clazz.courseType");
        Seq allTasks2 = this.entityDao().search((QueryBuilder)builder2);
        allTasks2.foreach((Function1 & Serializable)d -> {
            Course course = (Course)d[0];
            CourseType courseType = (CourseType)d[1];
            Map task = (Map)allTasksMap.getOrElseUpdate((Object)course, CourseTaskServiceImpl::$anonfun$3);
            return (Set)task.getOrElseUpdate((Object)courseType, CourseTaskServiceImpl::initTask$$anonfun$2$$anonfun$1);
        });
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class, "task");
        q.where("task.course.project=:project and task.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project, semester}));
        Seq existTasks = this.entityDao().search((QueryBuilder)q);
        Map existMap = Collections$.MODULE$.newMap();
        existTasks.foreach((Function1 & Serializable)t -> {
            Buffer ts = (Buffer)existMap.getOrElseUpdate((Object)t.course(), CourseTaskServiceImpl::$anonfun$4);
            return (Buffer)ts.addOne(t);
        });
        IntRef total = IntRef.create((int)0);
        allTasksMap.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Course course = (Course)tuple2._1();
                Map taskMap = (Map)tuple2._2();
                ObjectRef courseType = ObjectRef.create((Object)((CourseType)((Tuple2)taskMap.head())._1()));
                IntRef teacherCnt = IntRef.create((int)((IterableOnceOps)((Tuple2)taskMap.head())._2()).size());
                Set teachers = Collections$.MODULE$.newSet();
                taskMap.foreach((Function1 & Serializable)t -> {
                    if (((IterableOnceOps)t._2()).size() > teacherCnt$1.elem) {
                        teacherCnt$1.elem = ((IterableOnceOps)t._2()).size();
                        courseType$1.elem = (CourseType)t._1();
                    }
                    return (Set)teachers.$plus$plus$eq((IterableOnce)t._2());
                });
                Buffer tasks = (Buffer)existMap.getOrElse((Object)course, CourseTaskServiceImpl::$anonfun$5);
                Department depart = course.getJournal(semester).department();
                if (tasks.isEmpty()) {
                    CourseTask nt = new CourseTask(course, depart, semester, (CourseType)courseType.elem);
                    if (this.updateTask(nt, (CourseType)courseType.elem, depart, (Iterable<Teacher>)teachers)) {
                        ++total$1.elem;
                        return;
                    }
                    return;
                }
                tasks.find((Function1 & Serializable)_$2 -> !_$2.confirmed()).foreach((Function1 & Serializable)t -> this.updateTask((CourseTask)t, (CourseType)courseType$2.elem, depart, (Iterable<Teacher>)teachers));
                this.entityDao().remove((Iterable)tasks.filter((Function1 & Serializable)x -> {
                    Department department = x.department();
                    Department department2 = depart;
                    return department == null ? department2 != null : !department.equals(department2);
                }));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.entityDao().remove((Iterable)existTasks.filter((Function1 & Serializable)t -> !allTasksMap.contains((Object)t.course())));
        return total.elem;
    }

    private boolean updateTask(CourseTask task, CourseType courseType, Department department, Iterable<Teacher> teachers) {
        task.courseType_$eq(courseType);
        task.department_$eq(department);
        task.teachers().clear();
        task.teachers().$plus$plus$eq(teachers);
        boolean newer = !task.persisted();
        this.entityDao().saveOrUpdate((Object)task, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseTask[0]));
        return newer;
    }

    @Override
    public boolean isDirector(Course course, Teacher teacher) {
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class, "c");
        q.where("c.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        q.where("c.director=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{teacher}));
        return this.entityDao().search((QueryBuilder)q).nonEmpty();
    }

    @Override
    public boolean isDirector(Semester semester, Course course, Teacher teacher) {
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class, "c");
        q.where("c.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        q.where("c.course=:course and c.director=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course, teacher}));
        return this.entityDao().search((QueryBuilder)q).nonEmpty();
    }

    @Override
    public Seq<CourseTask> getTasks(Project project, Semester semester, Teacher teacher) {
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class, "c");
        q.where("c.course.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        q.where("c.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        q.where("c.director=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{teacher}));
        return this.entityDao().search((QueryBuilder)q);
    }

    @Override
    public Option<CourseTask> getTask(Semester semester, Course course, Teacher teacher) {
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class, "c");
        q.where("c.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        q.where("c.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        q.where("c.director=:teacher", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{teacher}));
        return this.entityDao().search((QueryBuilder)q).headOption();
    }

    @Override
    public Option<CourseTask> getOrCreateTask(Semester semester, Course course, Teacher teacher) {
        Option option;
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class, "c");
        q.where("c.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        q.where("c.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        Seq tasks = this.entityDao().search((QueryBuilder)q);
        if (tasks.isEmpty()) {
            option = this.createTask(semester, course);
        } else {
            Option myTask = tasks.find((Function1 & Serializable)_$3 -> _$3.teachers().contains((Object)teacher));
            if (myTask.isEmpty() && this.hasClazz(semester, course, teacher)) {
                ((CourseTask)tasks.head()).teachers().add((Object)teacher);
                this.entityDao().saveOrUpdate((Iterable)tasks);
                myTask = tasks.headOption();
            }
            option = myTask;
        }
        Option task = option;
        task.foreach((Function1)(JProcedure1 & Serializable)t -> {
            if (!t.confirmed()) {
                if (t.director().isEmpty() && t.teachers().size() == 1 && t.teachers().contains((Object)teacher)) {
                    if (t.office().isEmpty()) {
                        this.entityDao().findBy(CourseDirector.class, "course", (Object)course).foreach((Function1)(JProcedure1 & Serializable)cd -> t.office_$eq(cd.office()));
                    }
                    t.director_$eq((Option)Some$.MODULE$.apply((Object)teacher));
                    this.entityDao().saveOrUpdate(t, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseTask[0]));
                    return;
                }
                return;
            }
        });
        return task;
    }

    private Option<CourseTask> createTask(Semester semester, Course course) {
        OqlBuilder cq = OqlBuilder$.MODULE$.from(Clazz.class, "clazz");
        cq.where("clazz.project=:project and clazz.course=:course and clazz.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course.project(), course, semester}));
        Seq clazzes = this.entityDao().search((QueryBuilder)cq);
        if (clazzes.isEmpty()) {
            return None$.MODULE$;
        }
        scala.collection.immutable.Set teachers = ((IterableOnceOps)clazzes.flatMap((Function1 & Serializable)_$4 -> _$4.teachers())).toSet();
        CourseTask task = new CourseTask(course, course.department(), semester, ((Clazz)clazzes.head()).courseType());
        task.teachers().addAll((IterableOnce)teachers);
        this.entityDao().saveOrUpdate((Object)task, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseTask[0]));
        return Some$.MODULE$.apply((Object)task);
    }

    public Option<User> getDirector(Semester semester, Course course, Department depart) {
        Option option;
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class, "ct");
        q.where("ct.course=:course and ct.department=:department", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course, depart}));
        q.where("ct.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        Seq tasks = this.entityDao().search((QueryBuilder)q);
        Option director = tasks.headOption().flatMap((Function1 & Serializable)_$5 -> _$5.director());
        if (director.isEmpty()) {
            OqlBuilder dq = OqlBuilder$.MODULE$.from(CourseDirector.class, "cd");
            dq.where("cd.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
            dq.where("cd.beginOn <= :endOn and (cd.endOn is null or cd.endOn >= :beginOn)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester.endOn(), semester.beginOn()}));
            director = this.entityDao().search((QueryBuilder)dq).headOption().map((Function1 & Serializable)_$6 -> _$6.director());
        }
        if (None$.MODULE$.equals(option = director)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Teacher d = (Teacher)((Some)option).value();
            return this.entityDao().findBy(User.class, "code", (Object)d.code()).headOption();
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Option<User> getOfficeDirector(Semester semester, Course course, Department depart) {
        Option option;
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class, "ct");
        q.where("ct.course=:course and ct.department=:department", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course, depart}));
        q.where("ct.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        Seq tasks = this.entityDao().search((QueryBuilder)q);
        Option director = tasks.headOption().flatMap((Function1 & Serializable)_$7 -> _$7.office().flatMap((Function1 & Serializable)_$8 -> _$8.director()));
        if (director.isEmpty()) {
            director = this.entityDao().findBy(CourseDirector.class, "course", (Object)course).headOption().flatMap((Function1 & Serializable)_$9 -> _$9.office().flatMap((Function1 & Serializable)_$10 -> _$10.director()));
        }
        if (None$.MODULE$.equals(option = director)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Teacher d = (Teacher)((Some)option).value();
            return this.entityDao().findBy(User.class, "code", (Object)d.code()).headOption();
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Option<TeachingOffice> getOffice(Semester semester, Course course, Department depart) {
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class, "ct");
        q.where("ct.course=:course and ct.department=:department", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course, depart}));
        q.where("ct.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        Seq tasks = this.entityDao().search((QueryBuilder)q);
        return tasks.headOption().flatMap((Function1 & Serializable)_$11 -> _$11.office());
    }

    private boolean hasClazz(Semester semester, Course course, Teacher teacher) {
        OqlBuilder q = OqlBuilder$.MODULE$.from(Clazz.class, "clazz");
        q.where("clazz.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course.project()}));
        q.where("clazz.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        q.where("clazz.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        q.where(":teacher in elements(clazz.teachers)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{teacher}));
        return this.entityDao().search((QueryBuilder)q).nonEmpty();
    }

    private static final Map $anonfun$1() {
        return (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final Set $anonfun$2() {
        return (Set)HashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Teacher[0]));
    }

    private static final Map $anonfun$3() {
        return (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final Set initTask$$anonfun$2$$anonfun$1() {
        return (Set)HashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Teacher[0]));
    }

    private static final Buffer $anonfun$4() {
        return new ArrayBuffer();
    }

    private static final Buffer $anonfun$5() {
        return new ArrayBuffer();
    }
}

