/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exempt.service.impl;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.lang.Numbers$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.service.SemesterService;
import org.openurp.code.edu.model.ExamStatus;
import org.openurp.code.edu.model.ExamStatus$;
import org.openurp.edu.exempt.flow.CertExemptApply;
import org.openurp.edu.exempt.service.CertExemptApplyService;
import org.openurp.edu.exempt.service.ExemptionService;
import org.openurp.edu.extern.model.CertificateGrade;
import org.openurp.edu.grade.model.Grade;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class CertExemptApplyServiceImpl
implements CertExemptApplyService {
    private EntityDao entityDao;
    private ExemptionService exemptionService;
    private SemesterService semesterService;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public ExemptionService exemptionService() {
        return this.exemptionService;
    }

    public void exemptionService_$eq(ExemptionService x$1) {
        this.exemptionService = x$1;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    @Override
    public void accept(CertExemptApply apply) {
        CertificateGrade grade = this.convert(apply);
        this.entityDao().saveOrUpdate((Object)grade, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertificateGrade[0]));
        this.exemptionService().addExemption(grade, (Iterable<Course>)grade.exempts(), this.exemptionService().calcExemptScore(grade));
        apply.status_$eq(AuditStatus$.Passed);
        this.entityDao().saveOrUpdate((Object)apply, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertExemptApply[0]));
    }

    @Override
    public void reject(CertExemptApply apply) {
        CertificateGrade grade = this.convert(apply);
        if (grade.persisted()) {
            this.entityDao().remove((Object)grade, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertificateGrade[0]));
        }
        grade.exempts().foreach((Function1)(JProcedure1 & Serializable)c -> this.exemptionService().removeExemption(grade, (Course)c));
        apply.status_$eq(AuditStatus$.Rejected);
        this.entityDao().saveOrUpdate((Object)apply, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertExemptApply[0]));
    }

    private CertificateGrade convert(CertExemptApply apply) {
        CertificateGrade certificateGrade;
        OqlBuilder query = OqlBuilder$.MODULE$.from(CertificateGrade.class, "cg");
        query.where("cg.std = :std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{apply.std()}));
        query.where("cg.certificate = :certificate", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{apply.certificate()}));
        query.where("cg.acquiredIn = :acquiredIn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{apply.acquiredIn()}));
        Seq grades = this.entityDao().search((QueryBuilder)query);
        Option option = grades.headOption();
        if (None$.MODULE$.equals(option)) {
            CertificateGrade g = new CertificateGrade();
            g.std_$eq(apply.std());
            g.certificate_$eq(apply.certificate());
            g.acquiredIn_$eq(apply.acquiredIn());
            certificateGrade = g;
        } else if (option instanceof Some) {
            CertificateGrade g;
            certificateGrade = g = (CertificateGrade)((Some)option).value();
        } else {
            throw new MatchError((Object)option);
        }
        CertificateGrade grade = certificateGrade;
        grade.scoreText_$eq(apply.scoreText());
        if (Numbers$.MODULE$.isDigits(apply.scoreText())) {
            grade.score_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Numbers$.MODULE$.toFloat(apply.scoreText(), Numbers$.MODULE$.toFloat$default$2()))));
        }
        grade.semester_$eq(this.semesterService().get(apply.std().project(), apply.acquiredIn().atDay(1)));
        if (grade.semester() == null) {
            grade.semester_$eq(apply.semester());
        }
        grade.passed_$eq(true);
        grade.certificateNo_$eq(apply.certificateNo());
        grade.status_$eq(Grade.Status$.MODULE$.Published());
        grade.examStatus_$eq(new ExamStatus(ExamStatus$.MODULE$.Normal()));
        grade.exempts().$plus$plus$eq((IterableOnce)apply.courses());
        grade.gradingMode_$eq(apply.gradingMode());
        grade.updatedAt_$eq(Instant.now());
        return grade;
    }
}

