/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exempt.service.impl;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.YearMonth;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.commons.jexl3.scripting.JexlScriptEngine;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.script.ExpressionEvaluator;
import org.beangle.commons.script.ExpressionEvaluator$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.Semester;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.ExternStudent;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseTakeType$;
import org.openurp.code.edu.model.CourseType;
import org.openurp.edu.exempt.config.CertExemptSetting;
import org.openurp.edu.exempt.service.ExemptionService;
import org.openurp.edu.exempt.service.impl.CourseGradeConvertor;
import org.openurp.edu.exempt.service.impl.ExemptionCourse$;
import org.openurp.edu.extern.model.CertificateGrade;
import org.openurp.edu.extern.model.ExternGrade;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.Grade;
import org.openurp.edu.grade.service.GradeRateService;
import org.openurp.edu.program.domain.CoursePlanProvider;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.Program;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class ExemptionServiceImpl
implements ExemptionService {
    private EntityDao entityDao;
    private SemesterService semesterService;
    private CoursePlanProvider coursePlanProvider;
    private GradeRateService gradeRateService;
    private ExpressionEvaluator evaluator;

    public ExemptionServiceImpl() {
        JexlScriptEngine.setPermissions((JexlPermissions)JexlPermissions.UNRESTRICTED);
        this.evaluator = ExpressionEvaluator$.MODULE$.jsr223("jexl3");
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public CoursePlanProvider coursePlanProvider() {
        return this.coursePlanProvider;
    }

    public void coursePlanProvider_$eq(CoursePlanProvider x$1) {
        this.coursePlanProvider = x$1;
    }

    public GradeRateService gradeRateService() {
        return this.gradeRateService;
    }

    public void gradeRateService_$eq(GradeRateService x$1) {
        this.gradeRateService = x$1;
    }

    public ExpressionEvaluator evaluator() {
        return this.evaluator;
    }

    public void evaluator_$eq(ExpressionEvaluator x$1) {
        this.evaluator = x$1;
    }

    @Override
    public Option<Object> calcExemptScore(CertificateGrade grade) {
        OqlBuilder q = OqlBuilder$.MODULE$.from(CertExemptSetting.class, "setting");
        q.where("setting.certificate=:certificate", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade.certificate()}));
        q.where("setting.config.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade.std().project()}));
        Option option = ((IterableOps)this.entityDao().search((QueryBuilder)q).flatMap((Function1 & Serializable)_$5 -> _$5.scoreExpr())).headOption();
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            String expr = (String)((Some)option).value();
            if (Strings$.MODULE$.isNotBlank((CharSequence)expr)) {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"grade");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)grade);
                Object object = this.evaluator().eval(expr, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                if (object == null) {
                    return None$.MODULE$;
                }
                if (object instanceof Number) {
                    Number v = (Number)object;
                    return Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)v.floatValue()));
                }
                throw new MatchError(object);
            }
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Option<Semester> getSemester(Program program, Option<Object> term) {
        Option<Object> option = term;
        if (option instanceof Some) {
            int t = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            return this.semesterService().get(program.project(), program.beginOn(), program.endOn(), t);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    @Override
    public Seq<PlanCourse> getConvertablePlanCourses(Student std, CoursePlan plan) {
        Map coursesMap = Collections$.MODULE$.newMap();
        plan.planCourses().foreach((Function1 & Serializable)pc -> coursesMap.put((Object)pc.course(), pc));
        OqlBuilder query = OqlBuilder$.MODULE$.from(CourseGrade.class, "cg");
        query.where("cg.std=:std and cg.status=:status", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std, BoxesRunTime.boxToInteger((int)Grade.Status$.MODULE$.Published())}));
        Seq courseGrades = this.entityDao().search((QueryBuilder)query);
        courseGrades.foreach((Function1)(JProcedure1 & Serializable)courseGrade -> {
            if (courseGrade.passed()) {
                coursesMap.remove((Object)courseGrade.course());
                return;
            }
        });
        coursesMap.filterInPlace((Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                PlanCourse pc = (PlanCourse)tuple2._2();
                return pc.terms().termList().nonEmpty() && this.semesterService().get(std.project(), std.beginOn(), std.endOn(), BoxesRunTime.unboxToInt((Object)pc.terms().termList().head())).nonEmpty();
            }
            throw new MatchError((Object)tuple2);
        });
        return coursesMap.values().toSeq();
    }

    @Override
    public Seq<CourseGrade> getConvertedGrades(Student std, Iterable<Course> courses) {
        if (courses.isEmpty()) {
            return package$.MODULE$.List().empty();
        }
        OqlBuilder query2 = OqlBuilder$.MODULE$.from(CourseGrade.class, "cg");
        query2.where("cg.std=:std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        query2.where("cg.course in(:courses)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{courses}));
        query2.where("cg.courseTakeType.id=:exemption", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)CourseTakeType$.MODULE$.Exemption())}));
        return this.entityDao().search((QueryBuilder)query2);
    }

    @Override
    public void removeExemption(ExternGrade eg, Course course) {
        eg.exempts().subtractOne((Object)course);
        this.entityDao().saveOrUpdate((Object)eg, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExternGrade[0]));
        ExternStudent es = eg.externStudent();
        this.removeExemption(es.std(), course);
        this.entityDao().saveOrUpdate((Object)eg, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExternGrade[0]));
    }

    private void removeExemption(Student std, Course course) {
        Iterable<CourseGrade> cgs = this.getExemptionGrades(std, course);
        if (cgs.size() > 1) {
            throw new RuntimeException("found " + cgs.size() + " exemption grades of " + std.code());
        }
        this.entityDao().remove(cgs);
    }

    @Override
    public void removeExemption(CertificateGrade cg, Course course) {
        cg.exempts().subtractOne((Object)course);
        this.entityDao().saveOrUpdate((Object)cg, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertificateGrade[0]));
        this.removeExemption(cg.std(), course);
        this.entityDao().saveOrUpdate((Object)cg, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertificateGrade[0]));
    }

    @Override
    public void addExemption(ExternGrade eg, Iterable<Course> courses, Option<Object> score) {
        String remark = eg.externStudent().school().name() + " " + eg.courseName() + " " + eg.scoreText();
        Student std = eg.externStudent().std();
        this.addCourseGrades(std, courses, eg.id() + "@ExternGrade", (Option<YearMonth>)Some$.MODULE$.apply((Object)eg.acquiredIn()), score, remark);
        Set emptyCourses = (Set)eg.exempts().filter((Function1 & Serializable)x -> this.getExemptionGrades(std, (Course)x).isEmpty());
        eg.exempts().subtractAll((IterableOnce)emptyCourses);
        eg.exempts().$plus$plus$eq(courses);
        this.entityDao().saveOrUpdate((Object)eg, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExternGrade[0]));
    }

    @Override
    public void addExemption(CertificateGrade cg, Iterable<Course> courses, Option<Object> score) {
        String remark = cg.certificate().name() + " " + cg.scoreText();
        Student std = cg.std();
        this.addCourseGrades(std, courses, cg.id() + "@CertificateGrade", (Option<YearMonth>)None$.MODULE$, score, remark);
        Set emptyCourses = (Set)cg.exempts().filter((Function1 & Serializable)x -> this.getExemptionGrades(std, (Course)x).isEmpty());
        cg.exempts().subtractAll((IterableOnce)emptyCourses);
        cg.exempts().$plus$plus$eq(courses);
        this.entityDao().saveOrUpdate((Object)cg, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertificateGrade[0]));
    }

    private Iterable<CourseGrade> getExemptionGrades(Student std, Course course) {
        OqlBuilder cgQuery = OqlBuilder$.MODULE$.from(CourseGrade.class, "cg");
        cgQuery.where("cg.std=:std and cg.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std, course}));
        cgQuery.where("cg.courseTakeType.id=:exemption", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)CourseTakeType$.MODULE$.Exemption())}));
        return this.entityDao().search((QueryBuilder)cgQuery);
    }

    private void addCourseGrades(Student std, Iterable<Course> courses, String provider, Option<YearMonth> acquireOn, Option<Object> score, String remark) {
        OqlBuilder cgQuery = OqlBuilder$.MODULE$.from(CourseGrade.class, "cg");
        cgQuery.where("cg.std=:std and cg.courseTakeType.id=:exemptionTypeId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std, BoxesRunTime.boxToInteger((int)CourseTakeType$.MODULE$.Exemption())}));
        cgQuery.where("cg.provider=:provider", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{provider}));
        Seq exemptGrades = this.entityDao().search((QueryBuilder)cgQuery);
        scala.collection.immutable.Set courseSet = courses.toSet();
        this.entityDao().remove((Iterable)exemptGrades.filter((Function1 & Serializable)x -> !courseSet.contains((Object)x.course())));
        CourseGradeConvertor convertor = new CourseGradeConvertor(this.entityDao(), this.gradeRateService());
        Option coursePlan = this.coursePlanProvider().getCoursePlan(std);
        courses.foreach((Function1)(JProcedure1 & Serializable)c -> {
            ObjectRef semester = ObjectRef.create(null);
            ObjectRef courseType = ObjectRef.create(null);
            this.coursePlanProvider().getPlanCourse(std, c).foreach((Function1)(JProcedure1 & Serializable)pc -> {
                courseType$1.elem = pc.group().courseType();
                if (acquireOn.isEmpty() || ((YearMonth)acquireOn.get()).atDay(1).isBefore(std.beginOn())) {
                    pc.terms().termList().headOption().foreach((Function1)(JFunction1.mcVI.sp & Serializable)term -> coursePlan.foreach((Function1)(JProcedure1 & Serializable)plan -> {
                        Program program = plan.program();
                        semester$3.elem = (Semester)this.semesterService().get(std.project(), program.beginOn(), program.endOn(), term).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    }));
                    return;
                }
                semester$1.elem = this.semesterService().get(std.project(), ((YearMonth)acquireOn.get()).atDay(1));
            });
            if ((Semester)semester.elem == null) {
                semester.elem = this.semesterService().get(std.project(), LocalDate.now());
            }
            if ((CourseType)courseType.elem == null) {
                courseType.elem = (CourseType)c.courseType().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            CourseGrade grade = convertor.convert(std, ExemptionCourse$.MODULE$.apply((Course)c, (CourseType)courseType.elem, (Semester)semester.elem, score), provider, remark);
            this.entityDao().saveOrUpdate((Object)grade, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseGrade[0]));
        });
    }
}

