/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.audit;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.code.edu.model.CourseType;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.grade.domain.AuditPlanContext;
import org.openurp.edu.grade.domain.AuditPlanListener;
import org.openurp.edu.grade.model.AuditCourseResult;
import org.openurp.edu.grade.model.AuditGroupResult;
import org.openurp.edu.grade.model.AuditPlanResult;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.Grade;
import org.openurp.edu.program.domain.AlternativeCourseProvider;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class AuditCourseTakerListener
implements AuditPlanListener {
    private EntityDao entityDao;
    private AlternativeCourseProvider alternativeCourseProvider;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public AlternativeCourseProvider alternativeCourseProvider() {
        return this.alternativeCourseProvider;
    }

    public void alternativeCourseProvider_$eq(AlternativeCourseProvider x$1) {
        this.alternativeCourseProvider = x$1;
    }

    public void end(AuditPlanContext context) {
        if (context.result().passed()) {
            return;
        }
        OqlBuilder builder = (OqlBuilder)OqlBuilder$.MODULE$.from(CourseTaker.class, "ct").where("ct.std=:std", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{context.std()}));
        builder.where("not exists(from " + CourseGrade.class.getName() + " cg where cg.semester=ct.clazz.semester and cg.course=ct.clazz.course and cg.std=ct.std and cg.status=:status)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Grade.Status$.MODULE$.Published())}));
        scala.collection.immutable.Seq courseTakers = this.entityDao().search((QueryBuilder)builder);
        Option<AuditGroupResult> last = this.getTargetGroupResult(context);
        AuditPlanResult result = context.result();
        Buffer used = Collections$.MODULE$.newBuffer();
        courseTakers.foreach((Function1)(JProcedure1 & Serializable)ct -> result.getCourseResult(ct.course()).foreach((Function1)(JProcedure1 & Serializable)cr -> {
            used.addOne(ct);
            cr.taking_$eq(true);
            cr.addRemark("\u5728\u8bfb");
            cr.groupResult().addCourseResult(cr);
        }));
        scala.collection.immutable.Set reminded = ((IterableOnceOps)((IterableOps)courseTakers.toBuffer().subtractAll((IterableOnce)used)).map((Function1 & Serializable)_$3 -> _$3.course())).toSet();
        if (reminded.nonEmpty()) {
            Map courseMap = Collections$.MODULE$.newMap();
            context.result().groupResults().foreach((Function1)(JProcedure1 & Serializable)groupResult -> groupResult.courseResults().foreach((Function1)(JProcedure1 & Serializable)car -> {
                if (!(car.passed() || car.taking() || car.predicted())) {
                    courseMap.put((Object)car.course(), car);
                    return;
                }
            }));
            if (courseMap.nonEmpty()) {
                Seq substitutions = this.alternativeCourseProvider().getAlternatives(context.result().std());
                substitutions.withFilter((Function1 & Serializable)sc -> sc.olds().subsetOf(courseMap.keySet()) && sc.news().subsetOf((Set)reminded)).foreach((Function1)(JProcedure1 & Serializable)sc -> sc.olds().foreach((Function1 & Serializable)ori -> {
                    AuditCourseResult cr = (AuditCourseResult)courseMap.apply(ori);
                    cr.taking_$eq(true);
                    cr.addRemark("\u5728\u8bfb");
                    cr.addRemark(((IterableOnceOps)sc.news().map((Function1 & Serializable)_$4 -> _$4.name())).mkString(","));
                    cr.groupResult().addCourseResult(cr);
                    return (Buffer)used.addAll((IterableOnce)courseTakers.filter((Function1 & Serializable)x -> sc.news().contains((Object)x.course())));
                }));
            }
        }
        ((IterableOnceOps)courseTakers.toBuffer().subtractAll((IterableOnce)used)).foreach((Function1)(JProcedure1 & Serializable)ct -> {
            CourseType courseType = ct.courseType();
            if (courseType == null) {
                courseType = ct.clazz().courseType();
            }
            Option target = context.getGroup(ct.course(), courseType).flatMap((Function1 & Serializable)x -> result.getGroupResult(x.name())).orElse(() -> AuditCourseTakerListener.$anonfun$3(last));
            target.foreach((Function1)(JProcedure1 & Serializable)t -> {
                used.addOne(ct);
                this.add2Group((CourseTaker)ct, (AuditGroupResult)t, last.contains(t));
            });
        });
    }

    private void add2Group(CourseTaker taker, AuditGroupResult groupResult, boolean isLast) {
        AuditCourseResult cr = (AuditCourseResult)groupResult.getCourseResult(taker.course()).getOrElse(() -> AuditCourseTakerListener.$anonfun$4(taker));
        cr.taking_$eq(true);
        groupResult.addCourseResult(cr);
        cr.addRemark("\u5728\u8bfb");
        CourseType courseType = taker.courseType();
        if (courseType == null) {
            courseType = taker.clazz().courseType();
        }
        if (isLast) {
            CourseType courseType2 = courseType;
            CourseType courseType3 = groupResult.courseType();
            if (courseType2 == null ? courseType3 != null : !courseType2.equals(courseType3)) {
                cr.addRemark("\u539f" + courseType.name());
                return;
            }
        }
    }

    private Option<AuditGroupResult> getTargetGroupResult(AuditPlanContext context) {
        AuditPlanResult result = context.result();
        return context.coursePlan().program().offsetType().map((Function1 & Serializable)electiveType -> {
            AuditGroupResult groupResult = (AuditGroupResult)result.getGroupResult(electiveType.name()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (groupResult == null) {
                AuditGroupResult groupRs = new AuditGroupResult(electiveType.name(), electiveType);
                groupRs.indexno_$eq("99.99");
                groupResult = groupRs;
                result.addGroupResult(groupResult);
            }
            return groupResult;
        });
    }

    private static final Option $anonfun$3(Option last$2) {
        return last$2;
    }

    private static final AuditCourseResult $anonfun$4(CourseTaker taker$1) {
        return new AuditCourseResult(taker$1.course());
    }
}

