/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.filters;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.openurp.base.edu.model.Course;
import org.openurp.code.edu.model.CourseTakeType$;
import org.openurp.code.edu.model.GradeType$;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.service.filters.AlternativeGradeFilter;
import org.openurp.edu.program.model.AlternativeCourse;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.FloatRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;

public final class AlternativeGradeFilter$
implements Serializable {
    public static final AlternativeGradeFilter$ MODULE$ = new AlternativeGradeFilter$();

    private AlternativeGradeFilter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AlternativeGradeFilter$.class);
    }

    public Seq<AlternativeGradeFilter.AlternativeGroup> analysis(Seq<AlternativeCourse> substituteCourses, Map<Course, CourseGrade> gradeMap) {
        if (substituteCourses.isEmpty() || gradeMap.isEmpty()) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        Buffer groups = Collections$.MODULE$.newBuffer();
        scala.collection.mutable.Map alternativeGradeMap = Collections$.MODULE$.newMap();
        for (AlternativeCourse subCourse : substituteCourses) {
            AlternativeGradeFilter.AlternativeGrade oGrade = (AlternativeGradeFilter.AlternativeGrade)alternativeGradeMap.getOrElseUpdate((Object)subCourse.olds(), () -> AlternativeGradeFilter$.$anonfun$1(subCourse, gradeMap));
            AlternativeGradeFilter.AlternativeGrade nGrade = (AlternativeGradeFilter.AlternativeGrade)alternativeGradeMap.getOrElseUpdate((Object)subCourse.news(), () -> AlternativeGradeFilter$.$anonfun$2(subCourse, gradeMap));
            Option matched = groups.find((Function1 & Serializable)group -> {
                Option rs = group.alternatives().find((Function1 & Serializable)sc -> {
                    scala.collection.mutable.Set set = subCourse.news();
                    scala.collection.mutable.Set set2 = sc.olds();
                    if (set == null) {
                        if (set2 == null) return true;
                    } else if (set.equals(set2)) return true;
                    scala.collection.mutable.Set set3 = subCourse.olds();
                    scala.collection.mutable.Set set4 = sc.news();
                    if (set3 != null) {
                        if (!set3.equals(set4)) return false;
                        return true;
                    }
                    if (set4 == null) return true;
                    return false;
                });
                return rs.nonEmpty();
            });
            Option option = matched;
            if (None$.MODULE$.equals(option)) {
                AlternativeGradeFilter.AlternativeGroup ng = new AlternativeGradeFilter.AlternativeGroup();
                groups.addOne((Object)ng);
                ng.add(subCourse, oGrade, nGrade);
                continue;
            }
            if (option instanceof Some) {
                AlternativeGradeFilter.AlternativeGroup group2 = (AlternativeGradeFilter.AlternativeGroup)((Some)option).value();
                group2.add(subCourse, oGrade, nGrade);
                continue;
            }
            throw new MatchError((Object)option);
        }
        return groups;
    }

    private AlternativeGradeFilter.AlternativeGrade build(Set<Course> origins, Map<Course, CourseGrade> gradeMap) {
        FloatRef score = FloatRef.create((float)0.0f);
        double gp = 0.0;
        float credits = 0.0f;
        DoubleRef gs = DoubleRef.create((double)0.0);
        boolean fullGrade = true;
        LocalDate acquiredOn = null;
        for (Course course : origins) {
            Option option = gradeMap.get((Object)course);
            if (option instanceof Some) {
                CourseGrade grade = (CourseGrade)((Some)option).value();
                if (BoxesRunTime.unboxToInt((Object)grade.courseTakeType().id()) == CourseTakeType$.MODULE$.Exemption()) continue;
                if (acquiredOn == null) {
                    acquiredOn = grade.semester().endOn();
                } else if (grade.semester().endOn().isAfter(acquiredOn)) {
                    acquiredOn = grade.semester().endOn();
                }
                float c = grade.credits();
                grade.score().foreach((Function1)(JFunction1.mcVF.sp & Serializable)x -> {
                    score$1.elem += x;
                    gs$1.elem += (double)(c * x);
                });
                gp += (double)(c * BoxesRunTime.unboxToFloat((Object)grade.gp().getOrElse(AlternativeGradeFilter$::build$$anonfun$2)));
                credits += c;
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                fullGrade = false;
                continue;
            }
            throw new MatchError((Object)option);
        }
        if (acquiredOn == null) {
            acquiredOn = LocalDate.now();
        }
        if (0.0f == credits) {
            return new AlternativeGradeFilter.AlternativeGrade(score.elem, credits, gp, gs.elem, false, (scala.collection.immutable.Set<Course>)Predef$.MODULE$.Set().empty(), acquiredOn);
        }
        return new AlternativeGradeFilter.AlternativeGrade(score.elem, credits, gp, gs.elem, fullGrade, (scala.collection.immutable.Set<Course>)origins.toSet(), acquiredOn);
    }

    public static final /* synthetic */ boolean org$openurp$edu$grade$service$filters$AlternativeGradeFilter$AlternativeGrade$$_$gaPassed$$anonfun$1(scala.collection.immutable.Map gradeMap$1, Course c) {
        Option option = gradeMap$1.get(c.id());
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        if (option instanceof Some) {
            CourseGrade g = (CourseGrade)((Some)option).value();
            return !g.gaGrades().exists((Function1 & Serializable)x -> BoxesRunTime.unboxToInt((Object)x.gradeType().id()) != GradeType$.MODULE$.MakeupGa() && x.passed());
        }
        throw new MatchError((Object)option);
    }

    private static final AlternativeGradeFilter.AlternativeGrade $anonfun$1(AlternativeCourse subCourse$1, Map gradeMap$2) {
        return MODULE$.build((Set<Course>)subCourse$1.olds(), (Map<Course, CourseGrade>)gradeMap$2);
    }

    private static final AlternativeGradeFilter.AlternativeGrade $anonfun$2(AlternativeCourse subCourse$2, Map gradeMap$3) {
        return MODULE$.build((Set<Course>)subCourse$2.news(), (Map<Course, CourseGrade>)gradeMap$3);
    }

    private static final float build$$anonfun$2() {
        return 0.0f;
    }
}

