/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.filters;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.openurp.base.edu.model.Course;
import org.openurp.edu.grade.domain.GradeComparator$;
import org.openurp.edu.grade.domain.GradeFilter;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.program.domain.AlternativeCourseProvider;
import org.openurp.edu.program.model.AlternativeCourse;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.package$;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class BestOriginGradeFilter
implements GradeFilter {
    private AlternativeCourseProvider alternativeCourseProvider;

    public AlternativeCourseProvider alternativeCourseProvider() {
        return this.alternativeCourseProvider;
    }

    public void alternativeCourseProvider_$eq(AlternativeCourseProvider x$1) {
        this.alternativeCourseProvider = x$1;
    }

    private Map<Course, CourseGrade> buildGradeMap(Iterable<CourseGrade> grades) {
        Map gradesMap = Collections$.MODULE$.newMap();
        ObjectRef old = ObjectRef.create(null);
        grades.foreach((Function1)(JProcedure1 & Serializable)grade -> {
            old$1.elem = (CourseGrade)gradesMap.get((Object)grade.course()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (GradeComparator$.MODULE$.betterThan(grade, (CourseGrade)old$1.elem)) {
                if ((CourseGrade)old$1.elem != null) {
                    CourseGrade cloned = grade;
                    if (grade.semester().beginOn().isAfter(((CourseGrade)old$1.elem).semester().beginOn())) {
                        cloned = this.clone((CourseGrade)grade);
                        cloned.semester_$eq(((CourseGrade)old$1.elem).semester());
                    }
                    gradesMap.put((Object)grade.course(), (Object)cloned);
                    return;
                }
                gradesMap.put((Object)grade.course(), grade);
                return;
            }
        });
        return gradesMap;
    }

    private CourseGrade clone(CourseGrade grade) {
        CourseGrade cloned = new CourseGrade();
        cloned.std_$eq(grade.std());
        cloned.course_$eq(grade.course());
        cloned.semester_$eq(grade.semester());
        cloned.clazz_$eq(grade.clazz());
        cloned.crn_$eq(grade.crn());
        cloned.courseType_$eq(grade.courseType());
        cloned.courseTakeType_$eq(grade.courseTakeType());
        cloned.freeListening_$eq(grade.freeListening());
        cloned.examMode_$eq(grade.examMode());
        cloned.gradingMode_$eq(grade.gradingMode());
        cloned.project_$eq(grade.project());
        cloned.gp_$eq(grade.gp());
        cloned.passed_$eq(grade.passed());
        cloned.score_$eq(grade.score());
        cloned.scoreText_$eq(grade.scoreText());
        cloned.status_$eq(grade.status());
        cloned.examGrades().$plus$plus$eq((IterableOnce)grade.examGrades());
        return cloned;
    }

    public Iterable<CourseGrade> filter(Iterable<CourseGrade> grades) {
        Map<Course, CourseGrade> gradesMap = this.buildGradeMap(grades);
        Seq<AlternativeCourse> substituteCourses = this.getAlternatives(grades);
        substituteCourses.foreach((Function1)(JProcedure1 & Serializable)subCourse -> {
            CourseGrade origin = (CourseGrade)gradesMap.get(subCourse.olds().head()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            CourseGrade sub = (CourseGrade)gradesMap.get(subCourse.news().head()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (origin != null && sub != null && GradeComparator$.MODULE$.betterThan(sub, origin)) {
                gradesMap.remove((Object)sub.course());
                CourseGrade subClone = this.clone(sub);
                subClone.semester_$eq(origin.semester());
                subClone.course_$eq(origin.course());
                gradesMap.put((Object)origin.course(), (Object)subClone);
                return;
            }
        });
        return gradesMap.values().toSeq();
    }

    private Seq<AlternativeCourse> getAlternatives(Iterable<CourseGrade> grades) {
        if (grades.isEmpty()) {
            return package$.MODULE$.List().empty();
        }
        return this.alternativeCourseProvider().getAlternatives(((CourseGrade)grades.head()).std());
    }
}

