/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.filters;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.openurp.base.edu.model.Course;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradeType$;
import org.openurp.edu.grade.domain.GradeFilter;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.GaGrade;
import org.openurp.edu.program.model.AlternativeCourse;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.math.Ordering$;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class FirstGradeFilter
implements GradeFilter {
    private final Seq<AlternativeCourse> alternativeCourses;

    public FirstGradeFilter(Seq<AlternativeCourse> alternativeCourses) {
        this.alternativeCourses = alternativeCourses;
    }

    private Iterable<CourseGrade> findRemoveGrades(Map<Course, LocalDate> gradeDates, Set<Course> olds, Set<Course> news, Iterable<CourseGrade> grades) {
        if (olds.forall((Function1 & Serializable)x -> gradeDates.contains(x))) {
            LocalDate minAcquiredOn = (LocalDate)this.getMinAccquiredOn(gradeDates, olds).get();
            Option<LocalDate> option = this.getMinAccquiredOn(gradeDates, news);
            if (None$.MODULE$.equals(option)) {
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            if (option instanceof Some) {
                LocalDate newMinAcquiredOn = (LocalDate)((Some)option).value();
                if (newMinAcquiredOn.isBefore(minAcquiredOn)) {
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return (Iterable)grades.filter((Function1 & Serializable)x -> news.contains((Object)x.course()));
            }
            throw new MatchError(option);
        }
        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
    }

    public Iterable<CourseGrade> filter(Iterable<CourseGrade> grades) {
        scala.collection.immutable.Map gradeCourses = (scala.collection.immutable.Map)grades.groupBy((Function1 & Serializable)_$1 -> _$1.course()).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x._1(), ((IterableOnceOps)((IterableOps)x._2()).map((Function1 & Serializable)_$2 -> _$2.semester().beginOn())).min(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))));
        scala.collection.mutable.Set removed = Collections$.MODULE$.newSet();
        this.alternativeCourses.foreach((Function1 & Serializable)alt -> {
            removed.addAll(this.findRemoveGrades((Map<Course, LocalDate>)gradeCourses, (Set<Course>)alt.olds(), (Set<Course>)alt.news(), grades));
            return (scala.collection.mutable.Set)removed.addAll(this.findRemoveGrades((Map<Course, LocalDate>)gradeCourses, (Set<Course>)alt.news(), (Set<Course>)alt.olds(), grades));
        });
        Buffer rs = Collections$.MODULE$.newBuffer();
        GradeType endGaType = new GradeType(GradeType$.MODULE$.EndGa());
        GradeType delayGaType = new GradeType(GradeType$.MODULE$.DelayGa());
        grades.foreach((Function1)(JProcedure1 & Serializable)grade -> {
            if (!removed.contains(grade)) {
                Option finalGa;
                Option option;
                Option delayGa = grade.getGaGrade(delayGaType);
                Option endGa = grade.getGaGrade(endGaType);
                Option option2 = delayGa;
                if (None$.MODULE$.equals(option2)) {
                    option = endGa;
                } else if (option2 instanceof Some) {
                    GaGrade ga = (GaGrade)((Some)option2).value();
                    option = ga.published() ? delayGa : endGa;
                } else {
                    throw new MatchError((Object)option2);
                }
                Option option3 = finalGa = option;
                if (None$.MODULE$.equals(option3)) {
                    rs.addOne(grade);
                    return;
                }
                if (option3 instanceof Some) {
                    GaGrade ga = (GaGrade)((Some)option3).value();
                    Option option4 = ga.scoreText();
                    Option option5 = grade.scoreText();
                    if (option4 == null ? option5 != null : !option4.equals(option5)) {
                        CourseGrade g = this.clone((CourseGrade)grade);
                        g.gp_$eq(ga.gp());
                        g.score_$eq(ga.score());
                        g.scoreText_$eq(ga.scoreText());
                        g.passed_$eq(ga.passed());
                        rs.addOne((Object)g);
                        return;
                    }
                    rs.addOne(grade);
                    return;
                }
                throw new MatchError((Object)option3);
            }
        });
        return rs;
    }

    private Option<LocalDate> getMinAccquiredOn(Map<Course, LocalDate> gradeCourses, Set<Course> courses) {
        ObjectRef minAccquiredOn = ObjectRef.create(null);
        courses.foreach((Function1)(JProcedure1 & Serializable)course -> {
            LocalDate d = (LocalDate)gradeCourses.get(course).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (d != null && ((LocalDate)minAccquiredOn$1.elem == null || d.isBefore((LocalDate)minAccquiredOn$1.elem))) {
                minAccquiredOn$1.elem = d;
                return;
            }
        });
        return Option$.MODULE$.apply((Object)((LocalDate)minAccquiredOn.elem));
    }

    private CourseGrade clone(CourseGrade ag) {
        CourseGrade g = new CourseGrade();
        g.project_$eq(ag.project());
        g.id_$eq(ag.id());
        g.semester_$eq(ag.semester());
        g.course_$eq(ag.course());
        g.courseTakeType_$eq(ag.courseTakeType());
        g.courseType_$eq(ag.courseType());
        g.status_$eq(ag.status());
        g.std_$eq(ag.std());
        g.score_$eq(ag.score());
        g.scoreText_$eq(ag.scoreText());
        g.passed_$eq(ag.passed());
        g.gp_$eq(ag.gp());
        g.gradingMode_$eq(ag.gradingMode());
        g.clazz_$eq(ag.clazz());
        g.crn_$eq(ag.crn());
        g.freeListening_$eq(ag.freeListening());
        g.operator_$eq(ag.operator());
        g.createdAt_$eq(ag.createdAt());
        g.updatedAt_$eq(ag.updatedAt());
        g.examMode_$eq(ag.examMode());
        return g;
    }
}

