/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.util;

import java.io.Serializable;
import org.beangle.data.model.NumId;
import org.openurp.base.edu.model.Terms;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.edu.program.model.CourseGroup;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.math.Ordering;

public class GroupCredit {
    private final CourseGroup group;
    private final float credits;
    private final int creditHours;
    private final Map hours;
    private final float[] termCredits;
    private final Terms terms;

    public GroupCredit(CourseGroup group, float credits, int creditHours, Map<TeachingNature, Object> hours, float[] termCredits, Terms terms) {
        this.group = group;
        this.credits = credits;
        this.creditHours = creditHours;
        this.hours = hours;
        this.termCredits = termCredits;
        this.terms = terms;
    }

    public CourseGroup group() {
        return this.group;
    }

    public float credits() {
        return this.credits;
    }

    public int creditHours() {
        return this.creditHours;
    }

    public Map<TeachingNature, Object> hours() {
        return this.hours;
    }

    public float[] termCredits() {
        return this.termCredits;
    }

    public Terms terms() {
        return this.terms;
    }

    public String termCreditString() {
        return Predef$.MODULE$.wrapFloatArray(this.termCredits()).mkString(",");
    }

    public String hourRatios() {
        return ((IterableOnceOps)((IterableOnceOps)this.hours().map((Function1 & Serializable)x -> ((NumId)x._1()).id() + ":" + x._2())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString(",");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasDiff() {
        if (this.group().credits() != this.credits()) return true;
        if (this.group().creditHours() != this.creditHours()) return true;
        String string = this.group().hourRatios();
        String string2 = this.hourRatios();
        if (string == null) {
            if (string2 != null) {
                return true;
            }
        } else if (!string.equals(string2)) return true;
        String string3 = this.group().termCredits();
        String string4 = this.termCreditString();
        if (string3 == null) {
            if (string4 != null) {
                return true;
            }
        } else if (!string3.equals(string4)) return true;
        Terms terms = this.group().terms();
        Terms terms2 = this.terms();
        if (terms == null) {
            if (terms2 == null) return false;
            return true;
        } else if (terms.equals(terms2)) return false;
        return true;
    }

    public String toString() {
        return this.group().indexno() + " " + this.group().name() + " " + this.credits() + "\u5b66\u5206 " + this.creditHours() + "\u5b66\u65f6 " + this.hourRatios() + " " + Predef$.MODULE$.wrapFloatArray(this.termCredits()).mkString(",");
    }
}

