/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.impl;

import java.io.Serializable;
import org.openurp.base.model.Semester;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.domain.CourseGradeProvider;
import org.openurp.edu.grade.domain.GpaPolicy;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.StdGpa;
import org.openurp.edu.grade.model.StdSemesterGpa;
import org.openurp.edu.grade.model.StdYearGpa;
import org.openurp.edu.grade.service.GpaStatService;
import org.openurp.edu.grade.service.filters.BestGradeFilter;
import org.openurp.edu.grade.service.impl.MultiStdGpa;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.runtime.function.JProcedure1;

public class BestGpaStatService
implements GpaStatService {
    private CourseGradeProvider courseGradeProvider;
    private GpaPolicy gpaPolicy;
    private BestGradeFilter bestGradeFilter;

    public CourseGradeProvider courseGradeProvider() {
        return this.courseGradeProvider;
    }

    public void courseGradeProvider_$eq(CourseGradeProvider x$1) {
        this.courseGradeProvider = x$1;
    }

    public GpaPolicy gpaPolicy() {
        return this.gpaPolicy;
    }

    public void gpaPolicy_$eq(GpaPolicy x$1) {
        this.gpaPolicy = x$1;
    }

    public BestGradeFilter bestGradeFilter() {
        return this.bestGradeFilter;
    }

    public void bestGradeFilter_$eq(BestGradeFilter x$1) {
        this.bestGradeFilter = x$1;
    }

    @Override
    public void refresh(StdGpa stdGpa) {
        StdGpa newer = this.stat(stdGpa.std());
        this.merge(stdGpa, newer);
    }

    private void merge(StdGpa target, StdGpa source) {
        target.wms_$eq(source.wms());
        target.ams_$eq(source.ams());
        target.gpa_$eq(source.gpa());
        target.gradeCount_$eq(source.gradeCount());
        target.credits_$eq(source.credits());
        target.totalCredits_$eq(source.totalCredits());
        Map<Semester, StdSemesterGpa> existedTerms = this.semesterGpa2Map((Iterable<StdSemesterGpa>)target.semesterGpas());
        Map<Semester, StdSemesterGpa> sourceTerms = this.semesterGpa2Map((Iterable<StdSemesterGpa>)source.semesterGpas());
        sourceTerms.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Semester key = (Semester)tuple2._1();
                StdSemesterGpa value = (StdSemesterGpa)tuple2._2();
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                StdSemesterGpa value;
                Semester key = (Semester)tuple2._1();
                StdSemesterGpa sourceTerm = value = (StdSemesterGpa)tuple2._2();
                Option option = existedTerms.get((Object)key);
                if (None$.MODULE$.equals(option)) {
                    source.semesterGpas().$minus$eq((Object)sourceTerm);
                    target.add(sourceTerm);
                    return;
                }
                if (option instanceof Some) {
                    StdSemesterGpa targetTerm = (StdSemesterGpa)((Some)option).value();
                    targetTerm.wms_$eq(sourceTerm.wms());
                    targetTerm.ams_$eq(sourceTerm.ams());
                    targetTerm.gpa_$eq(sourceTerm.gpa());
                    targetTerm.gradeCount_$eq(sourceTerm.gradeCount());
                    targetTerm.credits_$eq(sourceTerm.credits());
                    targetTerm.totalCredits_$eq(sourceTerm.totalCredits());
                    return;
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        });
        existedTerms.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Semester key = (Semester)tuple2._1();
                StdSemesterGpa value = (StdSemesterGpa)tuple2._2();
                return true;
            }
            return false;
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Semester key = (Semester)tuple2._1();
                StdSemesterGpa value = (StdSemesterGpa)tuple2._2();
                return sourceTerms.get((Object)key) == null;
            }
            throw new MatchError((Object)tuple2);
        }).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                StdSemesterGpa value;
                Semester key = (Semester)tuple2._1();
                StdSemesterGpa targetTerm = value = (StdSemesterGpa)tuple2._2();
                targetTerm.stdGpa_$eq(null);
                return (Buffer)target.semesterGpas().$minus$eq((Object)targetTerm);
            }
            throw new MatchError((Object)tuple2);
        });
        Map<String, StdYearGpa> existedYears = this.yearGpa2Map((Iterable<StdYearGpa>)target.yearGpas());
        Map<String, StdYearGpa> sourceYears = this.yearGpa2Map((Iterable<StdYearGpa>)source.yearGpas());
        sourceYears.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                StdYearGpa value = (StdYearGpa)tuple2._2();
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                StdYearGpa value;
                String key = (String)tuple2._1();
                StdYearGpa sourceTerm = value = (StdYearGpa)tuple2._2();
                Option option = existedYears.get((Object)key);
                if (None$.MODULE$.equals(option)) {
                    source.yearGpas().$minus$eq((Object)sourceTerm);
                    target.add(sourceTerm);
                    return;
                }
                if (option instanceof Some) {
                    StdYearGpa targetTerm = (StdYearGpa)((Some)option).value();
                    targetTerm.wms_$eq(sourceTerm.wms());
                    targetTerm.ams_$eq(sourceTerm.ams());
                    targetTerm.gpa_$eq(sourceTerm.gpa());
                    targetTerm.gradeCount_$eq(sourceTerm.gradeCount());
                    targetTerm.credits_$eq(sourceTerm.credits());
                    targetTerm.totalCredits_$eq(sourceTerm.totalCredits());
                    return;
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        });
        existedYears.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                StdYearGpa value = (StdYearGpa)tuple2._2();
                return true;
            }
            return false;
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                StdYearGpa value = (StdYearGpa)tuple2._2();
                return sourceYears.get((Object)key) == null;
            }
            throw new MatchError((Object)tuple2);
        }).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                StdYearGpa value;
                String key = (String)tuple2._1();
                StdYearGpa targetTerm = value = (StdYearGpa)tuple2._2();
                targetTerm.stdGpa_$eq(null);
                return (Buffer)target.yearGpas().$minus$eq((Object)targetTerm);
            }
            throw new MatchError((Object)tuple2);
        });
        target.updatedAt_$eq(source.updatedAt());
    }

    private Map<Semester, StdSemesterGpa> semesterGpa2Map(Iterable<StdSemesterGpa> gpas) {
        return ((IterableOnceOps)gpas.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.semester(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, StdYearGpa> yearGpa2Map(Iterable<StdYearGpa> gpas) {
        return ((IterableOnceOps)gpas.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.schoolYear(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public StdGpa stat(Student std) {
        return this.stat(std, (Seq<CourseGrade>)this.courseGradeProvider().getPublished(std));
    }

    @Override
    public StdGpa stat(Student std, Seq<CourseGrade> grades) {
        StdGpa stdGpa = this.gpaPolicy().calc(std, grades, true);
        StdGpa stdGpa2 = this.gpaPolicy().calc(std, this.bestGradeFilter().filter((Iterable<CourseGrade>)grades), false);
        stdGpa.gradeCount_$eq(stdGpa2.gradeCount());
        stdGpa.credits_$eq(stdGpa2.credits());
        stdGpa.totalCredits_$eq(stdGpa2.totalCredits());
        stdGpa.wms_$eq(stdGpa2.wms());
        stdGpa.ams_$eq(stdGpa2.ams());
        stdGpa.gpa_$eq(stdGpa2.gpa());
        return stdGpa;
    }

    @Override
    public void refresh(StdGpa stdGpa, Seq<CourseGrade> grades) {
        StdGpa newer = this.stat(stdGpa.std(), grades);
        this.merge(stdGpa, newer);
    }

    @Override
    public MultiStdGpa stat(Iterable<Student> stds) {
        MultiStdGpa multiStdGpa = new MultiStdGpa();
        stds.foreach((Function1)(JProcedure1 & Serializable)std -> {
            StdGpa stdGpa = this.stat((Student)std);
            if (stdGpa != null) {
                multiStdGpa.stdGpas().$plus$eq((Object)stdGpa);
                return;
            }
        });
        multiStdGpa.statSemestersFromStdGpa();
        return multiStdGpa;
    }

    @Override
    public MultiStdGpa statBySemester(Iterable<Student> stds, Seq<Semester> semesters) {
        MultiStdGpa multiStdGpa = new MultiStdGpa();
        stds.foreach((Function1)(JProcedure1 & Serializable)std -> {
            StdGpa stdGpa = this.statBySemester((Student)std, semesters);
            if (stdGpa != null) {
                multiStdGpa.stdGpas().$plus$eq((Object)stdGpa);
                return;
            }
        });
        multiStdGpa.statSemestersFromStdGpa();
        return multiStdGpa;
    }

    @Override
    public StdGpa statBySemester(Student std, Seq<Semester> semesters) {
        return this.stat(std, (Seq<CourseGrade>)this.courseGradeProvider().getPublished(std, semesters));
    }
}

