/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.service.filters;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.openurp.base.edu.model.Course;
import org.openurp.edu.grade.domain.GradeComparator$;
import org.openurp.edu.grade.domain.GradeFilter;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.service.filters.AlternativeGradeFilter$;
import org.openurp.edu.program.model.AlternativeCourse;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class AlternativeGradeFilter
implements GradeFilter {
    private final Seq<AlternativeCourse> alternativeCourses;

    public static Seq<AlternativeGroup> analysis(Seq<AlternativeCourse> seq, Map<Course, CourseGrade> map) {
        return AlternativeGradeFilter$.MODULE$.analysis(seq, map);
    }

    public AlternativeGradeFilter(Seq<AlternativeCourse> alternativeCourses) {
        this.alternativeCourses = alternativeCourses;
    }

    public scala.collection.mutable.Map<Course, CourseGrade> buildGradeMap(Iterable<CourseGrade> grades) {
        scala.collection.mutable.Map gradesMap = Collections$.MODULE$.newMap();
        ObjectRef old = ObjectRef.create(null);
        grades.foreach((Function1)(JProcedure1 & Serializable)grade -> {
            old$1.elem = (CourseGrade)gradesMap.get((Object)grade.course()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (GradeComparator$.MODULE$.betterThan(grade, (CourseGrade)old$1.elem)) {
                gradesMap.put((Object)grade.course(), grade);
                return;
            }
        });
        return gradesMap;
    }

    public Iterable<CourseGrade> filter(Iterable<CourseGrade> grades) {
        scala.collection.mutable.Map<Course, CourseGrade> newMap = this.buildGradeMap(grades);
        Seq<AlternativeGroup> groups = AlternativeGradeFilter$.MODULE$.analysis(this.alternativeCourses, (Map<Course, CourseGrade>)newMap);
        groups.foreach((Function1)(JProcedure1 & Serializable)group -> {
            if (group.grades().exists((Function1 & Serializable)_$1 -> _$1.fullGrade())) {
                Buffer groupGrades = (Buffer)group.grades().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                AlternativeGrade last = (AlternativeGrade)groupGrades.remove(groupGrades.size() - 1);
                groupGrades.withFilter((Function1 & Serializable)sgg -> sgg.fullGrade()).foreach((Function1)(JProcedure1 & Serializable)sgg -> sgg.courses().foreach((Function1)(JProcedure1 & Serializable)course -> {
                    if (!last.courses().contains(course)) {
                        newMap.remove(course);
                        return;
                    }
                }));
                return;
            }
        });
        return newMap.values();
    }

    public static class AlternativeGrade
    implements Ordered<AlternativeGrade> {
        private final float score;
        private final float credits;
        private final boolean fullGrade;
        private final scala.collection.immutable.Set courses;
        private final LocalDate lastAcquiredOn;
        private final double gpa;
        private final double ga;

        public AlternativeGrade(float score, float credits, double gp, double gs, boolean fullGrade, scala.collection.immutable.Set<Course> courses, LocalDate lastAcquiredOn) {
            this.score = score;
            this.credits = credits;
            this.fullGrade = fullGrade;
            this.courses = courses;
            this.lastAcquiredOn = lastAcquiredOn;
            Ordered.$init$((Ordered)this);
            this.gpa = 0.0f == credits ? gp : gp / (double)credits;
            this.ga = 0.0f == credits ? gs : gs / (double)credits;
        }

        public float score() {
            return this.score;
        }

        public float credits() {
            return this.credits;
        }

        public boolean fullGrade() {
            return this.fullGrade;
        }

        public scala.collection.immutable.Set<Course> courses() {
            return this.courses;
        }

        public LocalDate lastAcquiredOn() {
            return this.lastAcquiredOn;
        }

        public double gpa() {
            return this.gpa;
        }

        public double ga() {
            return this.ga;
        }

        public boolean gaPassed(scala.collection.immutable.Map<Object, CourseGrade> gradeMap) {
            if (!this.fullGrade()) {
                return false;
            }
            return !this.courses().exists(arg_0 -> AlternativeGradeFilter$.org$openurp$edu$grade$service$filters$AlternativeGradeFilter$AlternativeGrade$$_$gaPassed$$anonfun$1(gradeMap, arg_0));
        }

        public int compare(AlternativeGrade other) {
            if (!this.fullGrade() && other.fullGrade()) {
                return -1;
            }
            if (this.fullGrade() && !other.fullGrade()) {
                return 1;
            }
            int gpaCmp = Double.compare(this.gpa(), other.gpa());
            if (gpaCmp == 0) {
                int gaCmp = Double.compare(this.ga(), other.ga());
                if (gaCmp == 0 && (gaCmp = Float.compare(this.score(), other.score())) == 0) {
                    gaCmp = other.lastAcquiredOn().compareTo(this.lastAcquiredOn());
                }
                return gaCmp;
            }
            return gpaCmp;
        }
    }

    public static class AlternativeGroup {
        private final Buffer alternatives = Collections$.MODULE$.newBuffer();
        private final Buffer grades = Collections$.MODULE$.newBuffer();
        private final Set<scala.collection.immutable.Set<Course>> courses = Collections$.MODULE$.newSet();

        public Buffer<AlternativeCourse> alternatives() {
            return this.alternatives;
        }

        public Buffer<AlternativeGrade> grades() {
            return this.grades;
        }

        public void add(AlternativeCourse sc, AlternativeGrade oGrade, AlternativeGrade nGrade) {
            this.alternatives().addOne((Object)sc);
            if (!this.courses.contains(oGrade.courses())) {
                this.courses.addOne(oGrade.courses());
                this.grades().addOne((Object)oGrade);
            }
            if (!this.courses.contains(nGrade.courses())) {
                this.courses.addOne(nGrade.courses());
                this.grades().addOne((Object)nGrade);
                return;
            }
        }
    }
}

