/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.schedule.service;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.collection.Properties;
import org.openurp.base.model.Semester;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.ClazzActivity;
import org.openurp.edu.schedule.service.ClazzTask;
import org.openurp.edu.schedule.service.LessonSchedule;
import org.openurp.edu.schedule.service.ScheduleDigestor$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.math.Ordering$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class LessonSchedule$
implements Serializable {
    public static final LessonSchedule$ MODULE$ = new LessonSchedule$();

    private LessonSchedule$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LessonSchedule$.class);
    }

    public Seq<LessonSchedule> convert(Clazz clazz) {
        Map schedules = Collections$.MODULE$.newMap();
        Seq<ClazzActivity> merged = ScheduleDigestor$.MODULE$.merge(clazz.semester(), (Iterable<ClazzActivity>)clazz.schedule().activities(), true, true);
        merged.foreach((Function1)(JProcedure1 & Serializable)activity -> {
            LocalTime beginTime = activity.time().beginAt().toLocalTime();
            LocalTime endTime = activity.time().endAt().toLocalTime();
            activity.time().dates().foreach((Function1)(JProcedure1 & Serializable)date -> {
                LocalDateTime s1 = date.atTime(beginTime);
                LocalDateTime e2 = date.atTime(endTime);
                if (!schedules.contains((Object)s1)) {
                    LessonSchedule schedule = MODULE$.apply((ClazzActivity)activity, (LocalDate)date, beginTime, endTime);
                    schedules.put((Object)s1, (Object)schedule);
                    return;
                }
            });
        });
        return (Seq)schedules.values().toSeq().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    public Seq<LessonSchedule> convert(Iterable<ClazzActivity> activities, LocalDateTime beginAt, LocalDateTime endAt) {
        Map schedules = Collections$.MODULE$.newMap();
        activities.foreach((Function1)(JProcedure1 & Serializable)activity -> {
            LocalTime beginTime = activity.time().beginAt().toLocalTime();
            LocalTime endTime = activity.time().endAt().toLocalTime();
            activity.time().dates().foreach((Function1)(JProcedure1 & Serializable)date -> {
                LocalDateTime s1 = date.atTime(beginTime);
                LocalDateTime e2 = date.atTime(endTime);
                String key = activity.clazz().id().toString() + s1.toString();
                if (s1.isBefore(endAt) && beginAt.isBefore(e2) && !schedules.contains((Object)key)) {
                    LessonSchedule schedule = MODULE$.apply((ClazzActivity)activity, (LocalDate)date, beginTime, endTime);
                    schedules.put((Object)key, (Object)schedule);
                    return;
                }
            });
        });
        return schedules.values().toSeq();
    }

    public LessonSchedule apply(ClazzActivity ca, LocalDate date, LocalTime beginAt, LocalTime endAt) {
        LessonSchedule s = new LessonSchedule();
        s.id_$eq(ca.id());
        s.date_$eq(date);
        s.time_$eq(beginAt.toString() + "~" + endAt.toString());
        ClazzTask task = new ClazzTask();
        Clazz clazz = ca.clazz();
        task.id_$eq(clazz.id().toString());
        Semester t = clazz.semester();
        Object[] objectArray = new Tuple2[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)t.id().toString());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)t.code());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"schoolYear");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)t.schoolYear());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)t.name());
        task.semester_$eq(new Properties((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        Object[] objectArray2 = new Tuple2[3];
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)clazz.course().id().toString());
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)clazz.course().code());
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)clazz.course().name());
        task.subject_$eq(new Properties((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        task.people_$eq((scala.collection.immutable.Seq<Properties>)((IterableOnceOps)ca.teachers().map((Function1 & Serializable)x -> {
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)x.id().toString());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)x.code());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)x.name());
            return new Properties((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        })).toSeq());
        task.crn_$eq(clazz.crn());
        s.units_$eq(ca.beginUnit() + "-" + ca.endUnit());
        s.hours_$eq(ca.endUnit() - ca.beginUnit() + 1);
        s.room_$eq(((IterableOnceOps)ca.rooms().map((Function1 & Serializable)_$1 -> _$1.name())).mkString(","));
        s.task_$eq(task);
        return s;
    }
}

