/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.service;

import java.io.Serializable;
import java.util.Arrays;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.model.NumId;
import org.beangle.data.model.pojo.Named;
import org.openurp.base.edu.model.Terms;
import org.openurp.code.edu.model.CourseRank;
import org.openurp.code.edu.model.TeachingNature;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class CategoryStat {
    private final String name;
    private final Option rank;
    private boolean practical;
    private boolean compulsory;
    private boolean inner;
    private double credits;
    private int hours;
    private float[] termCredits;
    private final scala.collection.mutable.Map typeHours;

    public CategoryStat(String name, Option<CourseRank> rank) {
        this.name = name;
        this.rank = rank;
        this.practical = false;
        this.compulsory = false;
        this.inner = false;
        this.credits = 0.0;
        this.hours = 0;
        this.termCredits = null;
        this.typeHours = Collections$.MODULE$.newMap();
    }

    public String name() {
        return this.name;
    }

    public Option<CourseRank> rank() {
        return this.rank;
    }

    public boolean practical() {
        return this.practical;
    }

    public void practical_$eq(boolean x$1) {
        this.practical = x$1;
    }

    public boolean compulsory() {
        return this.compulsory;
    }

    public void compulsory_$eq(boolean x$1) {
        this.compulsory = x$1;
    }

    public boolean inner() {
        return this.inner;
    }

    public void inner_$eq(boolean x$1) {
        this.inner = x$1;
    }

    public double credits() {
        return this.credits;
    }

    public void credits_$eq(double x$1) {
        this.credits = x$1;
    }

    public int hours() {
        return this.hours;
    }

    public void hours_$eq(int x$1) {
        this.hours = x$1;
    }

    public float[] termCredits() {
        return this.termCredits;
    }

    public void termCredits_$eq(float[] x$1) {
        this.termCredits = x$1;
    }

    public scala.collection.mutable.Map<TeachingNature, Object> typeHours() {
        return this.typeHours;
    }

    public CategoryStat(CategoryStat o) {
        this(o.name(), (Option<CourseRank>)None$.MODULE$);
        this.practical_$eq(o.practical());
        this.compulsory_$eq(o.compulsory());
        this.credits_$eq(o.credits());
        this.hours_$eq(o.hours());
        this.termCredits_$eq(Arrays.copyOf(o.termCredits(), o.termCredits().length));
        this.typeHours().addAll(o.typeHours());
    }

    public CategoryStat(String name, CourseRank rank, boolean compulsory, boolean practical, boolean inner, int maxTerm) {
        this(name, (Option<CourseRank>)Option$.MODULE$.apply((Object)rank));
        this.compulsory_$eq(compulsory);
        this.practical_$eq(practical);
        this.inner_$eq(inner);
        this.termCredits_$eq(new float[maxTerm]);
    }

    public void merge(CategoryStat o) {
        this.credits_$eq(this.credits() + o.credits());
        this.hours_$eq(this.hours() + o.hours());
        Object object = Predef$.MODULE$.floatArrayOps(o.termCredits());
        ArrayOps$.MODULE$.indices$extension(object).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            float[] fArray = this.termCredits();
            fArray[i] = fArray[i] + o.termCredits()[i];
        });
        o.typeHours().foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                TeachingNature n = (TeachingNature)tuple2._1();
                int h = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return this.typeHours().put((Object)n, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.typeHours().getOrElse((Object)n, CategoryStat::merge$$anonfun$2$$anonfun$1)) + h)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void addCourse(float credit, Map<TeachingNature, Object> typeHour, Terms term) {
        this.credits_$eq(this.credits() + (double)credit);
        typeHour.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                TeachingNature n = (TeachingNature)tuple2._1();
                int h = BoxesRunTime.unboxToInt((Object)tuple2._2());
                this.hours_$eq(this.hours() + h);
                return this.typeHours().put((Object)n, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.typeHours().getOrElse((Object)n, CategoryStat::addCourse$$anonfun$1$$anonfun$1)) + h)));
            }
            throw new MatchError((Object)tuple2);
        });
        int tt = term.first() - 1;
        if (tt >= 0 && tt < this.termCredits().length) {
            float[] fArray = this.termCredits();
            fArray[tt] = fArray[tt] + credit;
            return;
        }
    }

    public void addGroup(float credit, Map<TeachingNature, Object> typeHour, String termCredits) {
        this.credits_$eq(this.credits() + (double)credit);
        typeHour.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                TeachingNature n = (TeachingNature)tuple2._1();
                int h = BoxesRunTime.unboxToInt((Object)tuple2._2());
                this.hours_$eq(this.hours() + h);
                return this.typeHours().put((Object)n, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.typeHours().getOrElse((Object)n, CategoryStat::addGroup$$anonfun$1$$anonfun$1)) + h)));
            }
            throw new MatchError((Object)tuple2);
        });
        if (Strings$.MODULE$.isNotEmpty((CharSequence)termCredits)) {
            String[] optionTermCredits = Strings$.MODULE$.split(termCredits, ",");
            int terms = Math.min(this.termCredits().length, optionTermCredits.length);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), terms).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                float[] fArray = this.termCredits();
                fArray[i] = fArray[i] + StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(optionTermCredits[i]));
            });
            return;
        }
    }

    public String toString() {
        String natureHours = ((IterableOnceOps)this.typeHours().map((Function1 & Serializable)x -> ((Named)x._1()).name() + ":" + x._2())).mkString(" ");
        return this.name() + " " + this.credits() + "credits " + this.hours() + "hours(" + natureHours + ")";
    }

    public int getHour(TeachingNature t) {
        return BoxesRunTime.unboxToInt((Object)this.typeHours().getOrElse((Object)t, CategoryStat::getHour$$anonfun$1));
    }

    public int getHour(String natureId) {
        return BoxesRunTime.unboxToInt((Object)this.typeHours().find((Function1 & Serializable)_$1 -> {
            String string = ((NumId)_$1._1()).id().toString();
            String string2 = natureId;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).map((Function1 & Serializable)_$2 -> BoxesRunTime.unboxToInt((Object)_$2._2())).getOrElse(CategoryStat::getHour$$anonfun$4));
    }

    private static final int merge$$anonfun$2$$anonfun$1() {
        return 0;
    }

    private static final int addCourse$$anonfun$1$$anonfun$1() {
        return 0;
    }

    private static final int addGroup$$anonfun$1$$anonfun$1() {
        return 0;
    }

    private static final int getHour$$anonfun$1() {
        return 0;
    }

    private static final int getHour$$anonfun$4() {
        return 0;
    }
}

