/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.portal.action

import org.beangle.webmvc.api.action.{ ActionSupport, ServletSupport }
import org.beangle.webmvc.api.view.View
import org.openurp.app.web.NavContext
import org.openurp.app.UrpApp
import org.openurp.app.security.RemoteService
import org.beangle.security.Securities
import org.beangle.webmvc.api.context.ActionContext
import org.openurp.app.Urp
import org.beangle.commons.io.IOs
import java.net.URL
import org.openurp.app.web.App
import org.beangle.commons.lang.Strings
import org.beangle.data.dao.OqlBuilder
import org.openurp.platform.bulletin.model.Doc
import org.openurp.platform.user.model.User
import org.beangle.data.dao.EntityDao
import org.openurp.platform.bulletin.model.Notice

class IndexAction extends ActionSupport with ServletSupport {
  var entityDao: EntityDao = _

  def index(): View = {
    val ctx = new NavContext
    var apps = IOs.readString(new URL(Urp.api + "/platform/security/func/edu/menus/user/" + Securities.user + ".json").openStream())
    ctx.menusJson = apps
    ctx.org = RemoteService.getOrg()
    ctx.app = App(UrpApp.name, request.getContextPath)
    ctx.params += ("openurp.webapp" -> Urp.webapp)
    ActionContext.current.params foreach {
      case (k, v) =>
        ctx.params += (k -> v.toString)
    }
    put("nav", ctx)
    val url = Urp.api + "/platform/user/profiles/" + Securities.user + ".json?domain=edu&resolved=1";
    val profiles = IOs.readString(new URL(url).openStream());
    put("profiles", profiles)

    put("urp", Urp)
    forward()
  }

  def welcome(): View = {
    val me: User = entityDao.findBy(classOf[User], "code", List(Securities.user)).head
    val docQuery = OqlBuilder.from(classOf[Doc], "doc")
    docQuery.where("doc.userCategory=:category", me.category)
    docQuery.where("doc.archived=false")
    docQuery.limit(1, 20)
    docQuery.orderBy("doc.updatedAt desc")
    val docs = entityDao.search(docQuery)

    val noticeQuery = OqlBuilder.from(classOf[Notice], "notice")
    noticeQuery.where("notice.userCategory=:category", me.category)
    noticeQuery.where("notice.archived=false")
    noticeQuery.limit(1, 20)
    noticeQuery.orderBy("notice.createdAt desc")
    val notices = entityDao.search(noticeQuery)

    put("docs", docs)
    put("notices", notices)
    put("webappBase", Urp.webapp)
    forward()
  }

  def logout(): View = {
    redirect(to(Urp.cas + "/logout"), null)
  }
}
