/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web;

import com.opensymphony.xwork2.ActionContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.sql.Date;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.beangle.commons.bean.comparators.PropertyComparator;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.lang.Strings;
import org.beangle.ems.app.security.SecurityUtils;
import org.beangle.security.Securities;
import org.beangle.security.authz.AccessDeniedException;
import org.beangle.security.core.userdetail.Profile;
import org.beangle.security.data.Permission;
import org.beangle.security.data.ProfileService;
import org.beangle.struts2.helper.Params;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.model.Department;
import org.openurp.base.model.User;
import org.openurp.base.service.ProjectContext;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.code.StdType;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.service.EamsException;
import org.openurp.web.EmsCookie;

public class ProjectContextImpl
implements ProjectContext {
    private EntityDao entityDao;
    protected ProfileService profileService;
    private SemesterService semesterService;
    protected final String prefix = "---+++";
    protected final Predicate collegePredicate = new Predicate(){

        public boolean evaluate(Object obj) {
            Department depart = (Department)obj;
            return depart.isTeaching();
        }
    };
    protected final Predicate teachPredicate = new Predicate(){

        public boolean evaluate(Object obj) {
            Department depart = (Department)obj;
            return depart.isTeaching();
        }
    };
    protected final Transformer idTransformer = new Transformer(){

        public Object transform(Object input) {
            return ((Entity)input).getId();
        }
    };

    public Project getProject() {
        HttpServletRequest request = this.getRequest();
        Project p = (Project)request.getAttribute("project");
        if (null != p) {
            return p;
        }
        Profile currentProfile = this.getCurrentProfile();
        String projectId = currentProfile.getProperty("project");
        if (projectId == null || projectId.contains(",")) {
            throw new RuntimeException("Invalid project value:" + projectId);
        }
        Project r = (Project)this.entityDao.get(Project.class, (Serializable)Integer.valueOf(projectId));
        request.setAttribute("project", (Object)r);
        return r;
    }

    private HttpServletRequest getRequest() {
        ActionContext ac = ActionContext.getContext();
        return (HttpServletRequest)ac.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
    }

    private HttpServletResponse getResponse() {
        ActionContext ac = ActionContext.getContext();
        return (HttpServletResponse)ac.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
    }

    public boolean isRoot() {
        return Securities.isRoot();
    }

    public User getUser() {
        if (null != ProjectContextImpl.retreive("---+++getUser")) {
            return (User)ProjectContextImpl.retreive("---+++getUser");
        }
        List users = this.entityDao.get(User.class, "code", new Object[]{Securities.getUsername()});
        if (users.isEmpty()) {
            System.out.println("Cannot find user:" + Securities.getUsername());
        }
        ProjectContextImpl.cache("---+++getUser", users.get(0));
        return (User)users.get(0);
    }

    public Semester getSemester() {
        if (null != ProjectContextImpl.retreive("---+++getSemester")) {
            return (Semester)ProjectContextImpl.retreive("---+++getSemester");
        }
        Semester r = this.getSemester_internal();
        ProjectContextImpl.cache("---+++getSemester", r);
        return r;
    }

    protected Semester getSemester_internal() {
        Semester semester;
        Project project = this.getProject();
        HttpServletRequest request = this.getRequest();
        EmsCookie cookie = EmsCookie.get(request, this.getResponse());
        String semesterId = Strings.isEmpty((CharSequence)Params.get((String)"semester.id")) ? cookie.get("semester") : Params.get((String)"semester.id");
        Semester semester2 = semester = semesterId == null ? null : (Semester)this.entityDao.get(Semester.class, (Serializable)Integer.valueOf(semesterId));
        if (semester == null) {
            semester = this.semesterService.getCurSemester(project);
        } else if (!project.getCalendar().equals((Object)semester.getCalendar())) {
            semester = this.semesterService.getCurSemester(project);
        }
        if (!(semester == null || cookie.contains("semester") && ((Integer)semester.getId()).toString().equals(cookie.get("semester")))) {
            this.rememberSemester((Integer)semester.getId());
        }
        return semester;
    }

    public void rememberSemester(Integer semesterId) {
        HttpServletRequest request = this.getRequest();
        EmsCookie cookie = EmsCookie.get(request, this.getResponse());
        cookie.put("semester", semesterId.toString());
        EmsCookie.set(request, this.getResponse(), cookie);
    }

    public void forgetSemester() {
        HttpServletRequest request = this.getRequest();
        EmsCookie cookie = EmsCookie.get(request, this.getResponse());
        if (cookie.contains("semester")) {
            cookie.remove("semester");
            EmsCookie.set(request, this.getResponse(), cookie);
        }
    }

    public List<EducationLevel> getEducationLevels() {
        String v = this.get("eduLevel");
        if (v == null || v.equals("*")) {
            return this.getProjectThings(this.getProject(), "eduLevel");
        }
        List resultList = this.entityDao.get(EducationLevel.class, (Serializable[])Strings.splitToInt((String)v));
        Collections.sort(resultList, new PropertyComparator("code"));
        return resultList;
    }

    public List<StdType> getStdTypes() {
        String v = this.get("stdType");
        if (v == null || v.equals("*")) {
            return this.getProjectThings(this.getProject(), "stdType");
        }
        List resultList = this.entityDao.get(StdType.class, (Serializable[])Strings.splitToInt((String)v));
        Collections.sort(resultList, new PropertyComparator("code"));
        return resultList;
    }

    public List<Department> getDeparts() {
        String v = this.get("department");
        if (v == null || v.equals("*")) {
            return this.getProjectThings(this.getProject(), "department");
        }
        List resultList = this.entityDao.get(Department.class, (Serializable[])Strings.splitToInt((String)v));
        Collections.sort(resultList, new PropertyComparator("code"));
        List departs = CollectUtils.newArrayList();
        Date now = new Date(System.currentTimeMillis());
        for (Department depart : resultList) {
            if (depart.getEndOn() != null && !depart.getEndOn().after(now)) continue;
            departs.add(depart);
        }
        return departs;
    }

    public List<Department> getColleges() {
        List<Department> departs = this.getDeparts();
        return (List)CollectionUtils.select(departs, (Predicate)this.collegePredicate);
    }

    public List<Department> getTeachDeparts() {
        List<Department> departs = this.getDeparts();
        CollectionUtils.filter(departs, (Predicate)this.teachPredicate);
        return departs;
    }

    public String getEducationIdSeq() {
        List ids = (List)CollectionUtils.collect(this.getEducationLevels(), (Transformer)this.idTransformer);
        return Strings.join((Object[])ids.toArray(new Integer[0]), (char)',');
    }

    public String getStdTypeIdSeq() {
        List ids = (List)CollectionUtils.collect(this.getStdTypes(), (Transformer)this.idTransformer);
        return Strings.join((Object[])ids.toArray(new Integer[0]), (char)',');
    }

    public String getDepartIdSeq() {
        List ids = (List)CollectionUtils.collect(this.getDeparts(), (Transformer)this.idTransformer);
        return Strings.join((Object[])ids.toArray(new Integer[0]), (char)',');
    }

    public String getCollegeIdSeq() {
        List ids = (List)CollectionUtils.collect(this.getColleges(), (Transformer)this.idTransformer);
        return Strings.join((Object[])ids.toArray(new Integer[0]), (char)',');
    }

    public String getTeachDepartIdSeq() {
        List ids = (List)CollectionUtils.collect(this.getTeachDeparts(), (Transformer)this.idTransformer);
        return Strings.join((Object[])ids.toArray(new Integer[0]), (char)',');
    }

    public List<Project> getProjects() {
        List ps;
        List resultList = this.getAllProjects();
        if (resultList.isEmpty() && (ps = this.entityDao.getAll(Project.class)).size() == 1) {
            return ps;
        }
        return resultList;
    }

    private String get(String fieldName) {
        String cache = (String)ProjectContextImpl.retreive("---+++" + fieldName);
        if (cache != null) {
            return cache;
        }
        Profile currentProfile = this.getCurrentProfile();
        String value = currentProfile.getProperty(fieldName);
        ProjectContextImpl.cache("---+++" + fieldName, value);
        return value;
    }

    private List getProjectThings(Project contextProject, String fieldName) {
        List res = null;
        if ("eduLevel".equals(fieldName)) {
            res = CollectUtils.newArrayList((Collection)contextProject.getLevels());
        } else if ("stdType".equals(fieldName)) {
            res = CollectUtils.newArrayList((Collection)contextProject.getStdTypes());
        } else if ("department".equals(fieldName)) {
            res = CollectUtils.newArrayList((Collection)contextProject.getDepartments());
        } else if ("stdLabel".equals(fieldName)) {
            res = CollectUtils.newArrayList((Collection)contextProject.getStdLabels());
        }
        if (res == null) {
            throw new EamsException("\u7cfb\u7edf\u4e0d\u652f\u6301 " + fieldName + " \u7ef4\u5ea6\u7684\u6570\u636e\u7ea7\u6743\u9650");
        }
        return res;
    }

    public List<Profile> getProfiles() {
        return this.profileService.getProfiles(Securities.getUsername(), null);
    }

    public Profile getCurrentProfile() {
        List profiles;
        Profile cache = (Profile)ProjectContextImpl.retreive("---+++getCurrentProfile");
        if (cache != null) {
            return cache;
        }
        HttpServletRequest request = this.getRequest();
        EmsCookie cookie = EmsCookie.get(request, this.getResponse());
        long cookieProfileId = cookie.getProfile();
        String contextProfileId = request.getParameter("contextProfileId");
        if (Strings.isNotBlank((CharSequence)contextProfileId)) {
            cookieProfileId = Long.parseLong(contextProfileId);
        }
        if ((profiles = this.profileService.getProfiles(Securities.getUsername(), null)).isEmpty()) {
            throw new EamsException("\u7528\u6237\u7f3a\u5c11\u6570\u636e\u7ea7\u6743\u9650\u914d\u7f6e");
        }
        Profile result = null;
        if (cookieProfileId > 0L) {
            for (Profile p : profiles) {
                if (p.id != cookieProfileId) continue;
                result = p;
                break;
            }
            if (null == result) {
                result = (Profile)profiles.get(0);
            }
        } else {
            result = (Profile)profiles.get(0);
        }
        ProjectContextImpl.cache("---+++getCurrentProfile", result);
        if (cookie.getProfile() != result.id) {
            cookie.setProfile(result.id);
            EmsCookie.set(request, this.getResponse(), cookie);
        }
        return result;
    }

    private List getAllProjects() {
        List cache = (List)ProjectContextImpl.retreive("---+++project");
        if (cache != null) {
            return cache;
        }
        List profiles = this.profileService.getProfiles(Securities.getUsername(), null);
        if (CollectionUtils.isEmpty((Collection)profiles)) {
            throw new EamsException("\u7528\u6237\u7f3a\u5c11\u6570\u636e\u7ea7\u6743\u9650\u914d\u7f6e");
        }
        Set res = CollectUtils.newHashSet();
        for (Profile profile : profiles) {
            if (null == profile.getProperty("project")) continue;
            String value = profile.getProperty("project");
            if (value.equals("*")) {
                res.addAll(this.entityDao.getAll(Project.class));
                break;
            }
            res.addAll(this.entityDao.get(Project.class, (Serializable[])Strings.splitToInt((String)value)));
        }
        List list = CollectUtils.newArrayList((Collection)res);
        ProjectContextImpl.cache("---+++project", list);
        return list;
    }

    public void applyRestriction(OqlBuilder<?> query) {
        String userCode = Securities.getUsername();
        if (Securities.isRoot()) {
            return;
        }
        Permission dp = this.profileService.getPermission(userCode, query.getEntityClass().getName(), Securities.getResource());
        if (null == dp) {
            return;
        }
        List profiles = this.profileService.getProfiles(userCode, null);
        if (profiles.isEmpty()) {
            throw new AccessDeniedException((Object)Securities.getResource(), "error.security.errorprofile");
        }
        SecurityUtils.apply(query, (Permission)dp, (List)profiles);
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setSemesterService(SemesterService semesterService) {
        this.semesterService = semesterService;
    }

    static void cache(String key, Object value) {
        if (ActionContext.getContext() != null) {
            ActionContext.getContext().getContextMap().put(key, value);
        }
    }

    static Object retreive(String key) {
        if (ActionContext.getContext() != null) {
            return ActionContext.getContext().getContextMap().get(key);
        }
        return null;
    }
}

