/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.action;

import com.opensymphony.xwork2.util.ValueStack;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.beangle.commons.bean.comparators.PropertyComparator;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.beangle.ems.dictionary.model.CodeMeta;
import org.beangle.security.Securities;
import org.beangle.security.core.context.SecurityContext;
import org.beangle.security.core.userdetail.DefaultAccount;
import org.beangle.security.core.userdetail.Profile;
import org.beangle.struts2.annotation.Action;
import org.openurp.base.edu.model.Classroom;
import org.openurp.base.edu.model.Direction;
import org.openurp.base.edu.model.Major;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.edu.model.Teacher;
import org.openurp.base.model.Building;
import org.openurp.base.model.Department;
import org.openurp.base.std.model.Student;
import org.openurp.edu.web.action.RestrictionSupportAction;
import org.openurp.service.EamsException;
import org.openurp.service.security.EamsUserCategory;
import org.openurp.web.view.component.semester.SemesterCalendar;

@Action(value="/dataQuery")
public class DataQueryAction
extends RestrictionSupportAction {
    @Override
    public String index() {
        String view = this.get("dataType");
        if (view == null) {
            view = "project";
        }
        DataType type = this.getDataType(view);
        this.getDatas(type);
        return this.forward(this.getView(view));
    }

    protected void getDatas(DataType type) {
        this.put("entityId", this.getLong("entityId"));
        if (type == DataType.PROJECT) {
            List projects = CollectUtils.newArrayList((int)0);
            DefaultAccount account = (DefaultAccount)SecurityContext.get().getSession().getPrincipal();
            Profile[] profiles = account.getProfiles();
            if (null == profiles || profiles.length == 0) {
                if (account.getCategoryId() == EamsUserCategory.STD_USER.intValue()) {
                    OqlBuilder builder = OqlBuilder.from((String)Student.class.getName(), (String)"std");
                    builder.where("std.code = :usercode", (Object)Securities.getUsername());
                    builder.select("select distinct std.project");
                    projects = this.entityDao.search((QueryBuilder)builder);
                    if (projects.isEmpty()) {
                        throw new EamsException("\u7528\u6237\u7f3a\u5c11\u6570\u636e\u7ea7\u6743\u9650\u914d\u7f6e");
                    }
                } else {
                    OqlBuilder builder = OqlBuilder.from((String)Teacher.class.getName(), (String)"teacher");
                    builder.where("teacher.staff.code = :me", (Object)Securities.getUsername()).join("teacher.projects", "project").where("project.endOn is null");
                    builder.select("project");
                    projects = this.entityDao.search((QueryBuilder)builder);
                    if (null != projects) {
                        throw new EamsException("\u7528\u6237\u7f3a\u5c11\u6570\u636e\u7ea7\u6743\u9650\u914d\u7f6e");
                    }
                }
            } else {
                projects = this.getProjects();
            }
            this.put("datas", projects);
            this.put("entityId", projects.get(0).getId());
        } else if (type == DataType.PROJECTID) {
            this.put("datas", this.projectContext.getProject().getId());
        } else if (type == DataType.CURRPROJECT) {
            this.put("datas", this.projectContext.getProject());
        } else if (type == DataType.DEPARTMENT) {
            this.put("datas", this.getDeparts());
        } else if (type == DataType.COLLEGE) {
            this.put("datas", this.getColleges());
        } else if (type == DataType.MAJOR) {
            this.put("datas", this.getMajors());
        } else if (type == DataType.STDTYPE) {
            this.put("datas", this.getStdTypes());
        } else if (type == DataType.EDUCATION) {
            this.put("datas", this.getLevels());
        } else if (type == DataType.SEMESTER) {
            this.put("datas", this.getSemesters(this.getInt("projectId")));
        } else if (type == DataType.MAJORCASCADE) {
            this.put("datas", this.getMajorsCasCade());
        } else if (type == DataType.DIRECTIONCASCADE) {
            this.put("datas", this.getDirectionCascade());
        } else if (type == DataType.BUILDINGCASCADE) {
            this.put("datas", this.getBuildingCascade());
        } else if (type == DataType.SEMESTERCALENDAR) {
            Semester semester;
            List<Semester> semesters;
            Integer projectId = this.getIntId("project");
            if (null == projectId) {
                projectId = (Integer)this.projectContext.getProject().getId();
            }
            Map<String, List<Semester>> semesterCalendar = this.getSemesterCalendar(projectId);
            Integer semesterId = this.getInt("value");
            if (null != semesterId && null != (semesters = semesterCalendar.get((semester = (Semester)this.entityDao.get(Semester.class, (Serializable)semesterId)).getSchoolYear()))) {
                for (Semester s : semesters) {
                    if (!semester.equals((Object)s)) continue;
                    this.put("value", s);
                    break;
                }
            }
            this.put("semesterId", semesterId);
            this.put("datas", semesterCalendar);
            this.put("tagId", this.get("tagId"));
            this.put("uiType", StringUtils.lowerCase((String)this.get("uiType")));
        } else if (type == DataType.BASECODE) {
            this.put("datas", this.getBasecodes());
        } else {
            this.put("datas", this.getDatas());
        }
    }

    protected List<Semester> getSemesters(Integer projectId) {
        if (projectId == null) {
            return Collections.emptyList();
        }
        Project p = (Project)this.entityDao.get(Project.class, (Serializable)projectId);
        OqlBuilder builder = OqlBuilder.from(Semester.class, (String)"s").where("s.calendar = :calendar", (Object)p.getCalendar()).orderBy("s.beginOn").cacheable();
        return this.entityDao.search((QueryBuilder)builder);
    }

    protected Map<String, List<Semester>> getSemesterCalendar(Integer projectId) {
        HttpServletRequest request = this.getRequest();
        SemesterCalendar calendar = new SemesterCalendar((ValueStack)request.getAttribute("struts.valueStack"), false);
        calendar.setEmpty(this.get("empty"));
        calendar.setFormat(this.get("format"));
        calendar.setItems(this.getSemesters(projectId));
        calendar.setMulti(this.get("multi"));
        calendar.setYearRules(this.get("yearRules"));
        calendar.setTermRules(this.get("termRules"));
        return calendar.getSemesterTree();
    }

    protected List<?> getBasecodes() {
        Iterator it;
        String simpleName = this.get("className");
        if (Strings.isNotBlank((CharSequence)simpleName) && (it = this.entityDao.get(CodeMeta.class, "name", new Object[]{simpleName}).iterator()).hasNext()) {
            try {
                return this.entityDao.getAll(Class.forName(((CodeMeta)it.next()).getClassName()));
            }
            catch (ClassNotFoundException e) {
                return CollectUtils.newArrayList();
            }
        }
        return CollectUtils.newArrayList();
    }

    protected Object getDatas() {
        Iterator it;
        String simpleName = this.get("className");
        if (Strings.isNotBlank((CharSequence)simpleName) && (it = this.entityDao.get(CodeMeta.class, "name", new Object[]{simpleName}).iterator()).hasNext()) {
            try {
                this.entityDao.getAll(Class.forName(((CodeMeta)it.next()).getClassName()));
            }
            catch (ClassNotFoundException e) {
                return CollectUtils.newArrayList();
            }
        }
        return CollectUtils.newArrayList();
    }

    protected List<Major> getMajors() {
        List<Department> departs = this.getDeparts();
        if (CollectUtils.isEmpty(departs)) {
            return CollectUtils.newArrayList();
        }
        OqlBuilder builder = OqlBuilder.from(Major.class).where("exists(from major.journals md where md.depart in (:departs))", departs).where("major.beginOn <= :now and (major.endOn is null or major.endOn >= :now)", (Object)new Date());
        return this.entityDao.search((QueryBuilder)builder);
    }

    private List<Major> getMajorsCasCade() {
        Integer departId = this.getInt("departId");
        Integer levelId = this.getInt("levelId");
        OqlBuilder builder = OqlBuilder.from(Major.class, (String)"major").where("major.beginOn <= :now and (major.endOn is null or major.endOn >= :now)", (Object)new Date());
        if (null != levelId) {
            builder.where("exists(from major.journals md where md.level.id =:levelId)", (Object)levelId);
        }
        if (null != departId) {
            builder.where("exists(from major.journals md where md.depart.id =:departId)", (Object)departId);
            return this.entityDao.search((QueryBuilder)builder);
        }
        return CollectUtils.newArrayList();
    }

    private List<Building> getBuildingCascade() {
        OqlBuilder builder = OqlBuilder.from((String)Classroom.class.getName(), (String)"cl").where("cl.room.building.beginOn <= :now and (cl.room.building.endOn is null or cl.room.building.endOn >= :now)", (Object)new Date());
        Integer campusId = this.getInt("campusId");
        if (campusId == null) {
            return CollectUtils.newArrayList();
        }
        builder.where("cl.room.building.campus.id =:campusId", (Object)campusId);
        builder.select("distinct cl.room.building");
        List buildings = this.entityDao.search((QueryBuilder)builder);
        Collections.sort(buildings, new PropertyComparator("code"));
        return buildings;
    }

    private List<Direction> getDirectionCascade() {
        OqlBuilder builder = OqlBuilder.from(Direction.class, (String)"direction").where("direction.beginOn <= :now and (direction.endOn is null or direction.endOn >= :now)", (Object)new Date());
        Integer majorId = this.getInt("majorId");
        if (majorId == null) {
            return CollectUtils.newArrayList();
        }
        builder.where("direction.major.id =:majorId", (Object)majorId);
        return this.entityDao.search((QueryBuilder)builder);
    }

    protected DataType getDataType() {
        String dataType = this.get("dataType");
        return this.getDataType(dataType);
    }

    protected DataType getDataType(String dataType) {
        if (null == dataType) {
            dataType = this.get("dataType");
        }
        if (Strings.isBlank((CharSequence)dataType)) {
            return DataType.PROJECT;
        }
        return DataType.valueOf(dataType.toUpperCase());
    }

    protected String getView(String view) {
        String upperView = view.toUpperCase();
        if (DataType.PROJECT.toString().equals(upperView)) {
            return "project";
        }
        if (DataType.DEPARTMENT.toString().equals(upperView)) {
            return "department";
        }
        if (DataType.MAJOR.toString().equals(upperView)) {
            return "major";
        }
        if (DataType.STDTYPE.toString().equals(upperView)) {
            return "stdtype";
        }
        if (DataType.EDUCATION.toString().equals(upperView)) {
            return "level";
        }
        if (DataType.COLLEGE.toString().equals(upperView)) {
            return "college";
        }
        if (DataType.SEMESTER.toString().equals(upperView)) {
            return "semester";
        }
        if (DataType.SEMESTERCALENDAR.toString().equals(upperView)) {
            return "semesterCalendar";
        }
        if (DataType.BASECODE.toString().equals(upperView)) {
            return "baseCode";
        }
        if (DataType.PROJECTID.toString().equals(upperView)) {
            return "projectId";
        }
        if (DataType.CURRPROJECT.toString().equals(upperView)) {
            return view;
        }
        if (DataType.MAJORCASCADE.toString().equals(upperView)) {
            return "majorCascade";
        }
        if (DataType.DIRECTIONCASCADE.toString().equals(upperView)) {
            return "directionCascade";
        }
        if (DataType.BUILDINGCASCADE.toString().equals(upperView)) {
            return "buildingCascade";
        }
        return view;
    }

    static enum DataType {
        PROJECT,
        DEPARTMENT,
        MAJOR,
        STDTYPE,
        EDUCATION,
        COLLEGE,
        SEMESTER,
        SEMESTERCALENDAR,
        BASECODE,
        PROJECTID,
        CURRPROJECT,
        MAJORCASCADE,
        DIRECTIONCASCADE,
        BUILDINGCASCADE;


        public String toString() {
            return this == STDTYPE ? "stdType" : super.toString();
        }
    }
}

