/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.openurp.base.space.model.Classroom;

public class ClassroomBeanGsonAdapter
implements JsonSerializer<Classroom>,
JsonDeserializer<Classroom> {
    public JsonElement serialize(Classroom src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("id", src.getId());
        json.addProperty("code", src.getCode());
        json.addProperty("name", src.getName());
        json.addProperty("capacity", (Number)src.getCourseCapacity());
        if (src.getCampus() != null) {
            JsonObject campusJson = new JsonObject();
            campusJson.addProperty("id", src.getCampus().getId());
            campusJson.addProperty("name", src.getCampus().getName());
            campusJson.addProperty("code", src.getCampus().getCode());
            json.add("campus", (JsonElement)campusJson);
        } else {
            json.add("campus", (JsonElement)JsonNull.INSTANCE);
        }
        if (src.getBuilding() != null) {
            JsonObject buildingJson = new JsonObject();
            buildingJson.addProperty("id", src.getBuilding().getId());
            buildingJson.addProperty("name", src.getBuilding().getName());
            buildingJson.addProperty("code", src.getBuilding().getCode());
            json.add("building", (JsonElement)buildingJson);
        } else {
            json.add("building", (JsonElement)JsonNull.INSTANCE);
        }
        if (src.getRoomType() != null) {
            JsonObject typeJson = new JsonObject();
            typeJson.addProperty("id", src.getRoomType().getId());
            typeJson.addProperty("name", src.getRoomType().getName());
            typeJson.addProperty("code", src.getRoomType().getCode());
            json.add("classroomType", (JsonElement)typeJson);
        } else {
            json.add("classroomType", (JsonElement)JsonNull.INSTANCE);
        }
        return json;
    }

    public Classroom deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return null;
    }
}

