/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.util;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.web.util.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadHelper {
    private static Logger logger = LoggerFactory.getLogger(DownloadHelper.class);

    public static void download(HttpServletRequest request, HttpServletResponse response, File file) {
        DownloadHelper.download(request, response, file, file.getName());
    }

    public static void download(HttpServletRequest request, HttpServletResponse response, URL url, String display) {
        try {
            DownloadHelper.download(request, response, url.openStream(), url.getFile(), display);
        }
        catch (Exception e) {
            logger.warn("download file error=" + display, (Throwable)e);
        }
    }

    public static void download(HttpServletRequest request, HttpServletResponse response, File file, String display) {
        try {
            DownloadHelper.download(request, response, new FileInputStream(file), file.getAbsolutePath(), display);
        }
        catch (Exception e) {
            logger.warn("download file error=" + display, (Throwable)e);
        }
    }

    public static void download(HttpServletRequest request, HttpServletResponse response, InputStream inStream, String name, String display) {
        Object attch_name = "";
        byte[] b = new byte[1024];
        int len = 0;
        try {
            String ext = Strings.substringAfterLast((String)name, (String)".");
            if (Strings.isBlank((CharSequence)display)) {
                attch_name = DownloadHelper.getAttachName(name);
            } else {
                attch_name = display;
                if (!((String)attch_name).endsWith("." + ext)) {
                    attch_name = (String)attch_name + "." + ext;
                }
            }
            response.reset();
            String contentType = response.getContentType();
            if (null == contentType) {
                contentType = "application/x-msdownload";
                response.setContentType(contentType);
                logger.debug("set content stdType {} for {}", (Object)contentType, attch_name);
            }
            response.addHeader("Content-Disposition", "attachment; filename=\"" + RequestUtils.encodeAttachName((HttpServletRequest)request, (String)attch_name) + "\"");
            while ((len = inStream.read(b)) > 0) {
                response.getOutputStream().write(b, 0, len);
            }
            inStream.close();
        }
        catch (Exception e) {
            logger.warn("download file error=" + (String)attch_name, (Throwable)e);
        }
    }

    public static String getAttachName(String file_name) {
        if (file_name == null) {
            return "";
        }
        file_name = file_name.trim();
        int iPos = 0;
        iPos = file_name.lastIndexOf("\\");
        if (iPos > -1) {
            file_name = file_name.substring(iPos + 1);
        }
        if ((iPos = file_name.lastIndexOf("/")) > -1) {
            file_name = file_name.substring(iPos + 1);
        }
        if ((iPos = file_name.lastIndexOf(File.separator)) > -1) {
            file_name = file_name.substring(iPos + 1);
        }
        return file_name;
    }
}

