/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.dwr;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.Project;
import org.openurp.base.service.CourseService;

public class CourseDwr {
    private CourseService courseService;
    private EntityDao entityDao;

    public Course getCourse(Project project, String code) {
        return this.courseService.getCourse(project, code);
    }

    public String[] getCourseByCodes(String courseCodes) {
        if (Strings.isNotEmpty((CharSequence)courseCodes)) {
            OqlBuilder query = OqlBuilder.from(Course.class).where("code  in (:codes)", (Object)Strings.split((String)courseCodes.toUpperCase(), (char)','));
            List list = this.entityDao.search((QueryBuilder)query);
            String[] courseinfos = new String[list.size()];
            if (!list.isEmpty()) {
                int i = 0;
                for (Course course : list) {
                    courseinfos[i] = course.getName() + "(" + course.getDefaultCredits() + ")";
                    ++i;
                }
            }
            return courseinfos;
        }
        return null;
    }

    public Map<String, Object> getCourseByIdDwr(Long id) {
        List list = this.entityDao.search((QueryBuilder)OqlBuilder.from(Course.class, (String)"course").where("course.id=:id", (Object)id).cacheable());
        if (CollectUtils.isEmpty((Collection)list)) {
            return null;
        }
        return this.convert((Course)list.get(0));
    }

    private Map<String, Object> convert(Course c) {
        Map data = CollectUtils.newHashMap();
        data.put("id", ((Long)c.getId()).toString());
        Map depart = CollectUtils.newHashMap();
        depart.put("id", c.getDepartment().getId());
        depart.put("name", c.getDepartment().getName());
        data.put("department", depart);
        data.put("code", c.getCode());
        data.put("name", c.getName());
        data.put("enName", c.getEnName());
        data.put("defaultCredits", Float.valueOf(c.getDefaultCredits()));
        data.put("creditHours", c.getCreditHours());
        data.put("weeks", c.getWeeks());
        data.put("weekHours", c.getWeekHours());
        return data;
    }

    private List<Map<String, Object>> convert(List<Course> cs) {
        List rs = CollectUtils.newArrayList();
        for (Course c : cs) {
            rs.add(this.convert(c));
        }
        return rs;
    }

    public List<Map<String, Object>> searchCoursesByCodeOrName(String codeOrName) {
        String[] str;
        String like = "%" + codeOrName + "%";
        if (Strings.isNotBlank((CharSequence)codeOrName) && codeOrName.contains("(") && (str = codeOrName.split("\\(")).length > 1) {
            String code = str[1].trim();
            if (code.endsWith(")")) {
                code = code.substring(0, code.length() - 1);
            }
            return this.convert(this.entityDao.search((QueryBuilder)OqlBuilder.from(Course.class, (String)"course").where("(course.name like :name and course.code like :code) or course.code like :codeOrName or course.name like :codeOrName", (Object)("%" + str[0].trim() + "%"), (Object)("%" + code + "%"), (Object)like, new Object[0]).where("course.endOn is null").orderBy("course.code").orderBy("course.name").limit(1, 10)));
        }
        return this.convert(this.entityDao.search((QueryBuilder)OqlBuilder.from(Course.class, (String)"course").where("course.code like :code or course.name like :code", (Object)like).where("course.endOn is null").orderBy("course.code").orderBy("course.name").limit(1, 10)));
    }

    public List<Map<String, Object>> searchCourseByProjectAndCodeOrName(String studentCode, String codeOrName, String projectId) {
        String like = "%" + codeOrName + "%";
        Long proId = Long.parseLong(projectId);
        return this.convert(this.entityDao.search((QueryBuilder)OqlBuilder.from(Course.class, (String)"course").where("course.code like :code or course.name like :code", (Object)like).where("course.project.id=:projectId", (Object)proId).orderBy("course.code").orderBy("course.name").limit(1, 10)));
    }

    public void setCourseService(CourseService courseService) {
        this.courseService = courseService;
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }
}

