/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.rule;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.entity.metadata.EntityType;
import org.beangle.commons.entity.metadata.Model;
import org.beangle.commons.lang.Arrays;
import org.beangle.commons.lang.Strings;
import org.beangle.ems.rule.Rule;
import org.beangle.ems.rule.RuleParameter;
import org.beangle.struts2.helper.Params;
import org.beangle.struts2.helper.PopulateHelper;

public class RuleParameterPopulator {
    private EntityDao entityDao;

    public Set<RuleParameter> populateParams(Rule rule, String prefix) {
        int size = Params.getInt((String)(prefix + "_param_size"));
        Set params = CollectUtils.newHashSet();
        for (int i = 0; i < size; ++i) {
            RuleParameter ruleParam = this.populateEntity(RuleParameter.class, prefix + "_" + i);
            if (Strings.isBlank((CharSequence)ruleParam.getName())) continue;
            ruleParam.setChildren(this.populateParams(rule, prefix + "_" + i));
            ruleParam.setRule(rule);
            params.add(ruleParam);
        }
        return params;
    }

    protected <T> T populateEntity(Class<T> entityClass, String shortName) {
        EntityType type = null;
        type = entityClass.isInterface() ? Model.getType((String)entityClass.getName()) : Model.getType(entityClass);
        return (T)this.populateEntity(type.getEntityName(), shortName);
    }

    protected Entity<?> populateEntity(String entityName, String shortName) {
        Serializable entityId = (Serializable)this.getId(shortName, Model.getType((String)entityName).getIdType());
        Entity<?> entity = null;
        if (null == entityId) {
            entity = (Entity<?>)PopulateHelper.populate((String)entityName, (String)shortName);
        } else {
            entity = this.getModel(entityName, entityId);
            this.populate(entity, entityName, Params.sub((String)shortName));
        }
        return entity;
    }

    private final void populate(Entity<?> entity, String entityName, Map<String, Object> params) {
        Model.getPopulator().populate(entity, Model.getType((String)entityName), params);
    }

    private final <T> T getId(String name, Class<T> clazz) {
        Object[] entityIds = Params.getAll((String)(name + ".id"));
        if (Arrays.isEmpty((Object[])entityIds)) {
            entityIds = Params.getAll((String)(name + "Id"));
        }
        if (Arrays.isEmpty((Object[])entityIds)) {
            entityIds = Params.getAll((String)"id");
        }
        if (Arrays.isEmpty((Object[])entityIds)) {
            return null;
        }
        String entityId = entityIds[0].toString();
        int commaIndex = entityId.indexOf(44);
        if (commaIndex != -1) {
            entityId = entityId.substring(0, commaIndex);
        }
        return (T)Params.converter.convert((Object)entityId, clazz);
    }

    private Entity<?> getModel(String entityName, Serializable id) {
        return (Entity)this.entityDao.get(entityName, id);
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }
}

