/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.action.api;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.openurp.code.std.model.StdType;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.web.action.AdminBaseAction;

public class ProgramAction
extends AdminBaseAction {
    public String json() {
        String directionStr;
        String majorStr;
        String departStr;
        String levelStr;
        String grade;
        String[] conds;
        OqlBuilder query = OqlBuilder.from(Program.class, (String)"program");
        this.populateConditions(query, "program.grade");
        query.where("program.major.project.id = :projectId", (Object)this.getIntId("project"));
        query.where(":now >= program.beginOn and (program.endOn is null or :now <= program.endOn)", (Object)new Date()).orderBy("program.name");
        query.limit(this.getPageLimit());
        String names = this.get("term");
        if (Strings.isNotEmpty((CharSequence)names) && null != (conds = Strings.split((String)(names = names.replace('\uff0c', ',').replaceAll(",+", ",")))) && conds.length != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("(\n");
            for (int i = 0; i < conds.length; ++i) {
                String like = "'%" + conds[i] + "%'";
                if (Strings.isEmpty((CharSequence)like)) continue;
                if (i != 0) {
                    sb.append("\n or ");
                }
                sb.append("program.name like ").append(like);
            }
            sb.append("\n)");
            query.where(sb.toString());
        }
        if (Strings.isNotBlank((CharSequence)(grade = this.get("grade"))) && !grade.equals("null")) {
            query.where("program.grade in (:grades)", (Object)Strings.split((String)grade));
        }
        if (Strings.isNotBlank((CharSequence)(levelStr = this.get("levels"))) && !levelStr.equals("null")) {
            Integer[] levels = Strings.splitToInt((String)levelStr);
            query.where("program.level.id in (:levels)", (Object)levels);
        }
        if (Strings.isNotBlank((CharSequence)(departStr = this.get("departs"))) && !departStr.equals("null")) {
            Integer[] departs = Strings.splitToInt((String)departStr);
            query.where("program.department.id in (:departs)", (Object)departs);
        }
        if (Strings.isNotBlank((CharSequence)(majorStr = this.get("majors"))) && !majorStr.equals("null")) {
            Integer[] majors = Strings.splitToInt((String)majorStr);
            query.where("program.major.id in (:majors)", (Object)majors);
        }
        if (Strings.isNotBlank((CharSequence)(directionStr = this.get("directions"))) && !directionStr.equals("null")) {
            Integer[] directions = Strings.splitToInt((String)directionStr);
            query.where("program.direction.id in (:directions)", (Object)directions);
        }
        String stdTypeStr = this.get("stdTypes");
        HashSet stdTypes = new HashSet();
        if (Strings.isNotBlank((CharSequence)stdTypeStr) && !stdTypeStr.equals("null")) {
            stdTypes = new HashSet(this.entityDao.get(StdType.class, (Serializable[])Strings.splitToInt((String)stdTypeStr)));
        }
        List result = CollectUtils.newArrayList();
        List programs = this.entityDao.search((QueryBuilder)query);
        for (Program program : programs) {
            boolean stdTypeMatched = true;
            if (!stdTypes.isEmpty() && CollectUtils.intersection((Set)program.getStdTypes(), stdTypes).isEmpty()) {
                stdTypeMatched = false;
            }
            if (!stdTypeMatched) continue;
            Map entity = CollectUtils.newHashMap();
            entity.put("id", program.getId());
            entity.put("name", program.getName());
            result.add(entity);
        }
        this.put("programsJSON", new Gson().toJson((Object)result));
        return this.forward();
    }
}

