/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.helper;

import com.opensymphony.xwork2.ActionContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.ems.app.security.SecurityUtils;
import org.beangle.security.Securities;
import org.beangle.security.authz.AccessDeniedException;
import org.beangle.security.core.userdetail.Profile;
import org.beangle.security.data.Permission;
import org.beangle.security.data.ProfileService;
import org.openurp.web.EmsCookie;

public class SecurityHelper {
    private ProfileService profileService;

    public List<Profile> getProfiles() {
        return this.getProfiles(Securities.getUsername(), Securities.getResource());
    }

    private HttpServletRequest getRequest() {
        ActionContext ac = ActionContext.getContext();
        return (HttpServletRequest)ac.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
    }

    private List<Profile> getProfiles(String user, String path) {
        List profiles = this.profileService.getProfiles(user, path);
        EmsCookie cookie = EmsCookie.get(this.getRequest(), null);
        long cookieProfileId = cookie.getProfile();
        if (profiles.isEmpty()) {
            return profiles;
        }
        Profile result = null;
        if (cookieProfileId > 0L) {
            for (Profile p : profiles) {
                if (p.id != cookieProfileId) continue;
                result = p;
                break;
            }
            if (null == result) {
                result = (Profile)profiles.get(0);
            }
        } else {
            result = (Profile)profiles.get(0);
        }
        return Collections.singletonList(result);
    }

    protected boolean isAdmin() {
        return Securities.isRoot();
    }

    public <T> List<T> getProperties(String name) {
        List<Profile> profiles = this.getProfiles(Securities.getUsername(), Securities.getResource());
        Set results = CollectUtils.newHashSet();
        for (Profile profile : profiles) {
            String prop = profile.getProperty(name);
            if (prop instanceof Collection) {
                results.addAll((Collection)((Object)prop));
                continue;
            }
            results.add(prop);
        }
        return CollectUtils.newArrayList((Collection)results);
    }

    public void applyPermission(OqlBuilder<?> query) {
        String user = Securities.getUsername();
        if (Securities.isRoot()) {
            return;
        }
        Permission dp = this.profileService.getPermission(user, query.getEntityClass().getName(), Securities.getResource());
        if (null == dp) {
            return;
        }
        List<Profile> profiles = this.getProfiles(user, Securities.getResource());
        if (profiles.isEmpty()) {
            throw new AccessDeniedException((Object)Securities.getResource(), "error.security.errorprofile");
        }
        SecurityUtils.apply(query, (Permission)dp, profiles);
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public ProfileService getProfileService() {
        return this.profileService;
    }
}

