/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web;

import com.google.gson.Gson;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.web.util.CookieUtils;

public class EmsCookie {
    Map<String, String> data;
    public static final String CookieName = "URP_PROFILE";
    public static final int COOKIE_AGE = 604800;

    public EmsCookie(Map<String, String> data) {
        this.data = data;
    }

    public static final EmsCookie parse(String cookieValue) {
        Gson gson = new Gson();
        Map v = (Map)gson.fromJson(cookieValue, Map.class);
        return new EmsCookie(v);
    }

    public String toJson() {
        Gson gson = new Gson();
        return gson.toJson(this.data);
    }

    public static final EmsCookie get(HttpServletRequest request, HttpServletResponse response) {
        String cv = CookieUtils.getCookieValue((HttpServletRequest)request, (String)CookieName);
        EmsCookie cookie = null;
        cookie = Strings.isEmpty((CharSequence)cv) ? new EmsCookie(new HashMap<String, String>()) : EmsCookie.parse(cv);
        String profileId = request.getParameter("contextProfileId");
        if (Strings.isNotBlank((CharSequence)profileId) && null != response) {
            cookie.setProfile(Long.valueOf(profileId));
            EmsCookie.set(request, response, cookie);
        }
        return cookie;
    }

    public static final void set(HttpServletRequest request, HttpServletResponse response, EmsCookie ec) {
        CookieUtils.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)CookieName, (String)ec.toJson(), (String)"/", (int)604800);
    }

    public long getProfile() {
        String p = this.data.get("profile");
        if (Strings.isBlank((CharSequence)p)) {
            return 0L;
        }
        return Long.parseLong(p);
    }

    public void setProfile(long id) {
        this.data.put("profile", String.valueOf(id));
    }

    public void put(String key, String value) {
        this.data.put(key, value);
    }

    public String get(String key) {
        return this.data.get(key);
    }

    public void remove(String key) {
        this.data.remove(key);
    }

    public boolean contains(String key) {
        return this.data.containsKey(key);
    }
}

