/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.action;

import com.opensymphony.xwork2.ActionContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URL;
import java.sql.Date;
import java.util.List;
import java.util.Map;
import org.apache.struts2.dispatcher.SessionMap;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.web.url.UrlBuilder;
import org.beangle.commons.web.util.CookieUtils;
import org.beangle.commons.web.util.HttpUtils;
import org.beangle.commons.web.util.RequestUtils;
import org.beangle.ems.app.Ems;
import org.beangle.ems.app.EmsApp;
import org.beangle.security.Securities;
import org.beangle.security.codec.EncryptUtil;
import org.beangle.security.core.AuthenticationException;
import org.beangle.security.ids.Cas;
import org.beangle.security.ids.CasConfig;
import org.beangle.struts2.annotation.Result;
import org.beangle.struts2.annotation.Results;
import org.openurp.base.model.User;
import org.openurp.edu.web.action.AdminBaseAction;
import org.openurp.service.security.EamsUserCategory;
import org.openurp.web.EmsCookie;
import org.openurp.web.action.NavContext;

@Results(value={@Result(name="logout_success", type="redirectAction", location="login")})
public class HomeAction
extends AdminBaseAction {
    private CasConfig casConfig;

    public String index() throws Exception {
        String userCode = Securities.getUsername();
        if (null == userCode) {
            throw new AuthenticationException("without login");
        }
        List users = this.entityDao.search((QueryBuilder)OqlBuilder.from(User.class, (String)"u").where("u.code=:code", (Object)userCode));
        User user = users.isEmpty() ? null : (User)users.get(0);
        NavContext nav = new NavContext();
        nav.setPrincipal(Securities.getPrincipal());
        nav.setUsername(Securities.getUsername());
        this.put("user", user);
        this.put("nav", nav);
        String debug = this.get("debug");
        if (null != debug) {
            System.out.println("-----------------");
            System.out.println(Securities.getUsername());
            Map sessions = ActionContext.getContext().getSession();
            for (Map.Entry e : sessions.entrySet()) {
                System.out.println((String)e.getKey() + "->" + e.getValue().toString());
            }
            System.out.println("-----------------");
        }
        String menuUrl = Ems.Instance.getApi() + "/platform/security/func/" + EmsApp.getName() + "/menus/user/" + Securities.getUsername() + ".json?forDomain=1";
        String menuJson = HttpUtils.getResponseText((URL)new URL(menuUrl), (String)"UTF-8");
        nav.setMenusJson(menuJson);
        nav.setEms(Ems.getInstance());
        nav.fetchDomain();
        this.put("thisAppName", EmsApp.getName());
        this.put("webappBase", Ems.Instance.getWebapp());
        this.put("urpBase", Ems.Instance.getBase());
        HttpServletRequest request = this.getRequest();
        UrlBuilder ub = new UrlBuilder(request.getContextPath());
        ub.scheme(RequestUtils.isHttps((HttpServletRequest)request) ? "https" : "http");
        ub.serverName(request.getServerName());
        ub.port(RequestUtils.getServerPort((HttpServletRequest)request));
        this.put("appBase", ub.buildUrl());
        this.put("isManager", false);
        if (EamsUserCategory.MANAGER_USER.equals(user.getCategory().getId())) {
            this.put("isManager", true);
        }
        nav.setAvatarUrl(Ems.Instance.getApi() + "/platform/user/avatars/" + EncryptUtil.encode((String)userCode));
        this.put("casconfig", this.casConfig);
        String url = Ems.Instance.getApi() + "/platform/user/profiles/" + user.getCode() + ".json?domain=edu&resolved=1";
        String profiles = HttpUtils.getResponseText((String)url);
        nav.setProfiles(profiles);
        nav.setCookie(EmsCookie.get(request, this.getResponse()).toJson());
        return this.forward();
    }

    public String welcome() {
        this.put("date", new Date(System.currentTimeMillis()));
        return this.forward();
    }

    public String logout() {
        String result = this.determineTarget(this.getRequest());
        Cas.cleanup((CasConfig)this.casConfig, (HttpServletRequest)this.getRequest(), (HttpServletResponse)this.getResponse());
        ActionContext.getContext().getSession().clear();
        CookieUtils.deleteCookieByName((HttpServletRequest)this.getRequest(), (HttpServletResponse)this.getResponse(), (String)"project_id");
        CookieUtils.deleteCookieByName((HttpServletRequest)this.getRequest(), (HttpServletResponse)this.getResponse(), (String)"semester.id");
        ((SessionMap)ActionContext.getContext().getSession()).invalidate();
        return result;
    }

    protected String determineTarget(HttpServletRequest request) {
        Object target = this.get("redirect");
        target = null == target ? "redirect:" + this.casConfig.getCasServer() + "/logout" : "redirect:" + (String)target;
        return target;
    }

    public void setCasConfig(CasConfig casConfig) {
        this.casConfig = casConfig;
    }
}

