/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.dwr;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.beangle.commons.dao.EntityDao;
import org.beangle.orm.hibernate.udt.WeekState;
import org.openurp.base.time.NumberRangeDigestor;
import org.openurp.edu.program.model.ExecutivePlanCourse;
import org.openurp.edu.program.model.MajorPlanCourse;
import org.openurp.edu.program.model.StdPlanCourse;

public class PlanCourseServiceDwr {
    private EntityDao entityDao;

    public StdPlanCourse getPersonalPlanCourse(Long id) {
        return (StdPlanCourse)this.entityDao.get(StdPlanCourse.class, (Serializable)id);
    }

    public Map<String, Object> getExecutivePlanCourse(Long id) {
        ExecutivePlanCourse pc = (ExecutivePlanCourse)this.entityDao.get(ExecutivePlanCourse.class, (Serializable)id);
        HashMap<String, Object> datas = new HashMap<String, Object>();
        datas.put("id", ((Long)pc.getId()).toString());
        datas.put("course", pc.getCourse());
        datas.put("department", pc.getCourse().getDepartment());
        datas.put("terms", pc.getTerms().toString());
        if (pc.getWeekstate() != null) {
            datas.put("weekstate", NumberRangeDigestor.digest((WeekState)pc.getWeekstate()));
        }
        datas.put("compulsory", pc.isCompulsory());
        return datas;
    }

    public Map<String, Object> getMajorPlanCourse(Long id) {
        MajorPlanCourse pc = (MajorPlanCourse)this.entityDao.get(MajorPlanCourse.class, (Serializable)id);
        HashMap<String, Object> datas = new HashMap<String, Object>();
        datas.put("id", ((Long)pc.getId()).toString());
        datas.put("course", pc.getCourse());
        datas.put("department", pc.getCourse().getDepartment());
        datas.put("terms", pc.getTerms().toString());
        if (pc.getWeekstate() != null) {
            datas.put("weekstate", NumberRangeDigestor.digest((WeekState)pc.getWeekstate()));
        }
        datas.put("compulsory", pc.isCompulsory());
        return datas;
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }
}

