/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.dwr;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.std.model.Student;

public class StudentDwrServiceImpl
extends BaseServiceImpl {
    public Map getStudentByProjectAndCode(String code, Integer projectId) {
        List students;
        OqlBuilder builder = OqlBuilder.from(Student.class, (String)"student");
        builder.where("student.code =:code", (Object)code);
        if (null != projectId) {
            builder.where("student.project.id=:projectId", (Object)projectId);
        }
        if ((students = this.entityDao.search((QueryBuilder)builder)).size() > 0) {
            return this.toMap((Student)students.get(0));
        }
        return null;
    }

    public boolean stdExists(String code) {
        return this.entityDao.count(Student.class, "code", (Object)code) == 1L;
    }

    public Map getStudent(String code, Integer projectId) {
        OqlBuilder query = OqlBuilder.from(Student.class, (String)"student");
        query.where("student.code = :code and student.project.id=:projectId", (Object)code, (Object)projectId);
        List list = this.entityDao.search((QueryBuilder)query);
        if (list.isEmpty()) {
            return null;
        }
        return this.toMap((Student)list.get(0));
    }

    private Map toMap(Student std) {
        HashMap<String, Object> stdMap = new HashMap<String, Object>();
        stdMap.put("id", std.getId());
        stdMap.put("code", std.getCode());
        HashMap<String, String> person = new HashMap<String, String>();
        person.put("formattedName", std.getPerson().getFormattedName());
        stdMap.put("person", person);
        HashMap state = new HashMap();
        person.put("grade", (String)std.getState().getGrade());
        stdMap.put("state", state);
        stdMap.put("stdId", std.getId());
        stdMap.put("name", std.getName());
        HashMap user = new HashMap();
        stdMap.put("name", std.getName());
        stdMap.put("squad", null != std.getSquad() ? std.getSquad().getName() : "");
        stdMap.put("major", null != std.getMajor() ? std.getMajor().getName() : "");
        stdMap.put("grade", std.getGrade());
        stdMap.put("inSchool", std.getState().isInschool());
        stdMap.put("department", null != std.getDepartment() ? std.getDepartment().getName() : "");
        return stdMap;
    }

    public Map getStudentMap(String code, Integer projectId) {
        OqlBuilder query = OqlBuilder.from(Student.class, (String)"student");
        query.where("student.code = :code and student.project.id=:projectId", (Object)code, (Object)projectId);
        List list = this.entityDao.search((QueryBuilder)query);
        if (list.isEmpty()) {
            return null;
        }
        return this.toMap((Student)list.get(0));
    }
}

