/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.helper;

import java.util.Collection;
import java.util.Date;
import org.beangle.commons.collection.Order;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.beangle.struts2.helper.Params;
import org.beangle.struts2.helper.QueryHelper;
import org.openurp.base.edu.model.Direction;
import org.openurp.base.edu.model.Major;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.resource.model.Building;
import org.openurp.base.resource.model.Classroom;
import org.openurp.base.std.model.Squad;
import org.openurp.web.helper.SearchHelper;

public class BaseInfoSearchHelper
extends SearchHelper {
    public Collection<Squad> searchSquad(Project project, Semester semester) {
        return this.entityDao.search(this.buildSquadQuery(project, semester));
    }

    public Collection<Teacher> searchTeacher(Project project) {
        return this.entityDao.search(this.buildTeacherQuery(project));
    }

    public Collection<Classroom> searchClassroom(Project project) {
        return this.entityDao.search(this.buildClassroomQuery(project));
    }

    public OqlBuilder<Squad> buildSquadQuery(Project project) {
        OqlBuilder builder = OqlBuilder.from(Squad.class, (String)"squad");
        builder.where("squad.project=:project", (Object)project);
        QueryHelper.populateConditions((OqlBuilder)builder);
        builder.where("squad.stdType in (:stdTyps)", (Object)this.projectContext.getStdTypes());
        builder.where("squad.department in (:departments)", (Object)this.projectContext.getDeparts());
        Boolean enabled = Params.getBoolean((String)"enabled");
        if (Boolean.TRUE.equals(enabled)) {
            builder.where("squad.beginOn <= :now and (squad.endOn is null or squad.endOn >= :now)", (Object)new Date());
        } else if (Boolean.FALSE.equals(enabled)) {
            builder.where("squad.beginOn > :now or squad.endOn < :now", (Object)new Date());
        }
        builder.limit(QueryHelper.getPageLimit());
        String orderByPras = Params.get((String)"orderBy");
        if (Strings.isEmpty((CharSequence)orderByPras)) {
            orderByPras = "squad.code";
            builder.orderBy(new Order("squad.grade", false));
            builder.orderBy(new Order("squad.code"));
        } else {
            builder.orderBy(orderByPras);
        }
        return builder;
    }

    public OqlBuilder<Squad> buildSquadQuery(Project project, Semester semester) {
        OqlBuilder builder = OqlBuilder.from(Squad.class, (String)"squad");
        builder.where("squad.project=:project", (Object)project);
        QueryHelper.populateConditions((OqlBuilder)builder);
        builder.where("squad.stdType in (:stdTyps)", (Object)this.projectContext.getStdTypes());
        builder.where("squad.department in (:departments)", (Object)this.projectContext.getDeparts());
        Boolean enabled = Params.getBoolean((String)"enabled");
        if (null == enabled) {
            enabled = Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(enabled)) {
            builder.where("squad.beginOn <= :endOn and (squad.endOn is null or squad.endOn >= :beginOn)", (Object)semester.getEndOn(), (Object)semester.getBeginOn());
        } else if (Boolean.FALSE.equals(enabled)) {
            builder.where("squad.beginOn > :endOn or squad.endOn < :beginOn", (Object)semester.getEndOn(), (Object)semester.getBeginOn());
        }
        builder.limit(QueryHelper.getPageLimit());
        String orderByPras = Params.get((String)"orderBy");
        if (Strings.isEmpty((CharSequence)orderByPras)) {
            orderByPras = "squad.code";
            builder.orderBy(new Order("squad.grade", false));
            builder.orderBy(new Order("squad.code"));
        } else {
            builder.orderBy(orderByPras);
        }
        return builder;
    }

    public OqlBuilder<Teacher> buildTeacherQuery(Project project) {
        OqlBuilder builder = OqlBuilder.from(Teacher.class, (String)"teacher");
        builder.where(":project in elements(teacher.projects)", (Object)project);
        QueryHelper.populateConditions((OqlBuilder)builder);
        builder.limit(QueryHelper.getPageLimit());
        String orderByPras = Params.get((String)"orderBy");
        if (Strings.isEmpty((CharSequence)orderByPras)) {
            orderByPras = "teacher.staff.code";
        }
        builder.orderBy(orderByPras);
        return builder;
    }

    public OqlBuilder<Classroom> buildClassroomQuery(Project project) {
        OqlBuilder query = OqlBuilder.from(Classroom.class, (String)"classroom");
        query.where(":projects in elements(classroom.projects)", (Object)project);
        QueryHelper.populateConditions((OqlBuilder)query);
        query.limit(QueryHelper.getPageLimit());
        String orderByPras = Params.get((String)"orderBy");
        if (Strings.isEmpty((CharSequence)orderByPras)) {
            orderByPras = "classroom.name";
        }
        query.orderBy(orderByPras);
        return query;
    }

    public OqlBuilder<Building> buildBuildingQuery() {
        OqlBuilder builder = OqlBuilder.from(Building.class, (String)"building");
        builder.where("building.department in (:departs)", (Object)this.projectContext.getDeparts());
        QueryHelper.populateConditions((OqlBuilder)builder);
        builder.limit(QueryHelper.getPageLimit());
        String orderByPras = Params.get((String)"orderBy");
        if (Strings.isEmpty((CharSequence)orderByPras)) {
            orderByPras = "building.code";
        }
        builder.orderBy(orderByPras);
        return builder;
    }

    public OqlBuilder<Major> buildMajorQuery(Project project) {
        OqlBuilder builder = OqlBuilder.from(Major.class, (String)"major");
        builder.where("major.project=:project", (Object)project);
        QueryHelper.populateConditions((OqlBuilder)builder);
        builder.limit(QueryHelper.getPageLimit());
        String orderByPras = Params.get((String)"orderBy");
        if (Strings.isEmpty((CharSequence)orderByPras)) {
            orderByPras = "major.code";
        }
        builder.orderBy(orderByPras);
        return builder;
    }

    public OqlBuilder<Major> buildMajorQuery(Project project, Long levelId) {
        OqlBuilder builder = OqlBuilder.from(Major.class, (String)"major");
        builder.where("major.project=:project", (Object)project);
        QueryHelper.populateConditions((OqlBuilder)builder);
        builder.limit(QueryHelper.getPageLimit());
        String orderByPras = Params.get((String)"orderBy");
        if (Strings.isEmpty((CharSequence)orderByPras)) {
            orderByPras = "major.code";
        }
        if (null != levelId) {
            builder.where("exists (from major.journals j where j.level.id=:eduId)", (Object)levelId);
        }
        builder.orderBy(orderByPras);
        return builder;
    }

    public OqlBuilder<Direction> buildDirectionQuery(Project project) {
        OqlBuilder builder = OqlBuilder.from(Direction.class, (String)"direction");
        builder.where("direction.project=:project", (Object)project);
        QueryHelper.populateConditions((OqlBuilder)builder);
        builder.limit(QueryHelper.getPageLimit());
        String orderByPras = Params.get((String)"orderBy");
        if (Strings.isEmpty((CharSequence)orderByPras)) {
            orderByPras = "direction.code";
        }
        builder.orderBy(orderByPras);
        return builder;
    }

    public OqlBuilder<Direction> buildDirectionQuery(Project project, Long levelId) {
        OqlBuilder builder = OqlBuilder.from(Direction.class, (String)"direction");
        builder.where("direction.project=:project", (Object)project);
        QueryHelper.populateConditions((OqlBuilder)builder);
        builder.limit(QueryHelper.getPageLimit());
        String orderByPras = Params.get((String)"orderBy");
        if (Strings.isEmpty((CharSequence)orderByPras)) {
            orderByPras = "direction.code";
        }
        if (null != levelId) {
            String hql = "exists (from direction.journals dd where dd.level.id = :levelId)";
            builder.where(hql, (Object)levelId);
        }
        builder.orderBy(orderByPras);
        return builder;
    }
}

