/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.util;

import java.io.PrintWriter;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.text.i18n.TextResource;
import org.openurp.service.OutputMessage;
import org.openurp.service.OutputObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputProcessObserver
implements OutputObserver {
    protected PrintWriter writer;
    protected TextResource textResource;
    protected Logger logger = LoggerFactory.getLogger(OutputProcessObserver.class);

    public OutputProcessObserver() {
    }

    public OutputProcessObserver(PrintWriter writer, TextResource textResource) {
        this.writer = writer;
        this.textResource = textResource;
    }

    public void setSummary(String msg) {
        try {
            this.writer.write("<script>setSummary('" + msg + "')</script>\n");
            this.writer.flush();
        }
        catch (Exception e) {
            this.logger.warn("exception", (Throwable)e);
        }
    }

    public void setOverallCount(int count) {
        try {
            this.writer.write("<script>count=" + count + "</script>\n");
            this.writer.flush();
        }
        catch (Exception e) {
            this.logger.warn("exception", (Throwable)e);
        }
    }

    public void notifyStart(String summary, int count, String[] msgs) {
        try {
            this.setSummary(summary);
            this.setOverallCount(count);
            if (null != msgs) {
                for (int i = 0; i < msgs.length; ++i) {
                    this.writer.write("<script>addProcessMsg('" + msgs[i] + "');</script>\n");
                }
                this.writer.flush();
            }
        }
        catch (Exception e) {
            this.logger.warn("exception", (Throwable)e);
        }
    }

    public void outputNotify(int level, OutputMessage msgObj, boolean increaceProcess) {
        try {
            if (increaceProcess) {
                this.writer.print("<script>addProcessMsg(" + level + ",\"" + this.message(msgObj) + "\",1);</script>\n");
            } else {
                this.writer.print("<script>addProcessMsg(" + level + ",\"" + this.message(msgObj) + "\",0);</script>\n");
            }
            this.writer.flush();
        }
        catch (Exception e) {
            this.logger.warn("exception", (Throwable)e);
        }
    }

    public void outputNotify(int level, OutputMessage msgObj) {
        this.outputNotify(level, msgObj, true);
    }

    public String message(OutputMessage msgObj) {
        return msgObj.getMessage(this.textResource);
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public String messageOf(String key) {
        if (Strings.isNotEmpty((CharSequence)key)) {
            return this.textResource.getText(key);
        }
        return "";
    }

    public String messageOf(String key, Object arg0) {
        if (Strings.isNotEmpty((CharSequence)key)) {
            return this.textResource.getText(key, key, new Object[]{arg0});
        }
        return "";
    }

    public void notifyFinish() {
        this.writer.println("finish");
    }

    public void notifyStart() {
        this.writer.println("start");
    }

    public TextResource getTextResource() {
        return this.textResource;
    }

    public void setTextResource(TextResource textResource) {
        this.textResource = textResource;
    }
}

