/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.web.action;

import java.util.Date;
import java.util.List;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.entity.pojo.Code;
import org.beangle.commons.lang.Assert;
import org.beangle.security.Securities;
import org.openurp.base.edu.model.Project;
import org.openurp.base.model.BaseInfo;
import org.openurp.base.std.model.Student;
import org.openurp.edu.web.action.MultiProjectSupportAction;

public abstract class StudentProjectSupport
extends MultiProjectSupportAction {
    @Override
    protected void addBasecode(String key, Class<? extends Code<Integer>> clazz) {
        Assert.notEmpty((CharSequence)key);
        this.put(key, this.codeService.getCodes(clazz));
    }

    @Override
    protected void addBaseInfo(String key, Class<? extends BaseInfo> clazz) {
        this.put(key, this.baseInfoService.getBaseInfos(clazz, this.getProject().getSchool()));
    }

    @Override
    protected List getBaseInfos(Class<? extends BaseInfo> clazz) {
        return this.baseInfoService.getBaseInfos(clazz, this.getProject().getSchool());
    }

    @Override
    protected List<Project> getProjects() {
        OqlBuilder builder = OqlBuilder.from((String)Student.class.getName(), (String)"std");
        builder.where("std.code = :usercode", (Object)Securities.getUsername()).select("select distinct std.project");
        builder.where("(std.project.endOn >:now or std.project.endOn is null)", (Object)new Date());
        return this.entityDao.search((QueryBuilder)builder);
    }

    public Student getLoginStudent(Project project) {
        OqlBuilder stdQuery = OqlBuilder.from(Student.class, (String)"std");
        if (null != project) {
            stdQuery.where("std.project =:project ", (Object)project);
        }
        stdQuery.where("std.code = :usercode", (Object)Securities.getUsername());
        List stds = this.entityDao.search((QueryBuilder)stdQuery);
        if (stds.isEmpty()) {
            return null;
        }
        return (Student)stds.get(0);
    }
}

