/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.dwr;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.service.StudentService;
import org.openurp.base.std.model.Student;
import org.openurp.std.register.model.Register;

public class RegisterServiceDwr {
    private EntityDao entityDao;
    private StudentService studentService;

    public Map<String, Object> getRegister1(String stdId, Integer projectId, Integer semesterId) {
        Student std = (Student)this.entityDao.get(Student.class, (Serializable)Long.valueOf(Long.parseLong(stdId)));
        HashMap<String, Object> registerMap = new HashMap<String, Object>();
        OqlBuilder query = OqlBuilder.from(Register.class, (String)"register");
        query.where("register.std.code=:code", (Object)std.getCode());
        query.where("register.semester.id=:semesterId", (Object)semesterId);
        query.where("register.std.project.id=:projectId", (Object)projectId);
        List collection = this.entityDao.search((QueryBuilder)query);
        registerMap.put("stdId", std.getId());
        registerMap.put("stdName", std.getName());
        registerMap.put("gender", null != std.getGender() ? std.getGender().getName() : "");
        registerMap.put("major", null != std.getMajor() ? std.getMajor().getName() : "");
        registerMap.put("grade", std.getGrade());
        registerMap.put("active", this.studentService.isActive(std));
        registerMap.put("inSchool", this.studentService.isInschool(std));
        if (CollectUtils.isEmpty((Collection)collection)) {
            registerMap.put("UnregistReason", "unregister");
        } else {
            Register register = (Register)collection.get(0);
            registerMap.put("UnregistReason", register.getUnregisteredReason());
        }
        return registerMap;
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    public void setStudentService(StudentService studentService) {
        this.studentService = studentService;
    }
}

