/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.web.action;

import com.opensymphony.xwork2.ActionContext;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.HttpParameters;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.event.Event;
import org.beangle.commons.event.EventMulticaster;
import org.beangle.commons.lang.Objects;
import org.beangle.commons.lang.Strings;
import org.beangle.security.Securities;
import org.beangle.struts2.convention.route.Action;
import org.openurp.base.model.User;
import org.openurp.base.service.BaseInfoService;
import org.openurp.base.service.DepartmentService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.service.CodeService;
import org.openurp.web.action.SecurityActionSupport;
import org.openurp.web.helper.LogHelper;
import org.openurp.web.util.OutputProcessObserver;
import org.openurp.web.util.OutputWebObserver;

public abstract class BaseAction
extends SecurityActionSupport {
    protected CodeService codeService;
    protected BaseInfoService baseInfoService;
    protected EventMulticaster eventMulticaster;
    protected SemesterService semesterService;
    protected DepartmentService departmentService;
    protected LogHelper logHelper;

    protected User getLoginUser() {
        OqlBuilder builder = OqlBuilder.from(User.class, (String)"user");
        builder.where("user.code =:code", (Object)Securities.getUsername());
        List users = this.entityDao.search((QueryBuilder)builder);
        if (users.isEmpty()) {
            return null;
        }
        return (User)users.get(0);
    }

    protected String forwardError(String message) {
        this.addError(message, new Object[0]);
        return "error";
    }

    protected String forwardError(String[] messages) {
        int i = 0;
        while (i < messages.length) {
            this.addMessage(messages[i++], new Object[0]);
        }
        return "error";
    }

    protected OutputWebObserver getOutputProcessObserver(String forwardName, Class<? extends OutputWebObserver> observerClass) {
        OutputWebObserver observer;
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("text/html; charset=utf-8");
        try {
            observer = observerClass.newInstance();
            observer.setBase(ServletActionContext.getRequest().getContextPath());
            observer.setTextResource(this.getTextResource());
            observer.setWriter(response.getWriter());
            observer.setPath(forwardName);
            observer.outputTemplate();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return observer;
    }

    protected String redirect(Action action, String message, String[] prefixes) {
        HttpParameters params = ActionContext.getContext().getParameters();
        if (null != prefixes && prefixes.length > 0) {
            block0: for (String key : params.keySet()) {
                if (Objects.equals((Object)"params", (Object)key)) continue;
                for (int i = 0; i < prefixes.length; ++i) {
                    if (!key.startsWith(prefixes[i])) continue;
                    String value = this.get(key);
                    if (!Strings.isNotEmpty((CharSequence)value)) continue block0;
                    action.getParams().put(key, value);
                    continue block0;
                }
            }
        }
        return this.redirect(action, message);
    }

    protected OutputProcessObserver getOutputProcessObserver() {
        return this.getOutputProcessObserver("processDisplay.ftl", OutputWebObserver.class);
    }

    protected OutputProcessObserver getOutputProcessObserver(Class<? extends OutputWebObserver> observerClass) {
        return this.getOutputProcessObserver("processDisplay.ftl", observerClass);
    }

    protected void publish(Event event) {
        this.eventMulticaster.multicast(event);
    }

    public void setCodeService(CodeService codeService) {
        this.codeService = codeService;
    }

    public void setBaseInfoService(BaseInfoService baseInfoService) {
        this.baseInfoService = baseInfoService;
    }

    protected SemesterService getSemesterService() {
        return this.semesterService;
    }

    public void setSemesterService(SemesterService semesterService) {
        this.semesterService = semesterService;
    }

    protected DepartmentService getDepartmentService() {
        return this.departmentService;
    }

    public void setDepartmentService(DepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    public void setLogHelper(LogHelper logHelper) {
        this.logHelper = logHelper;
    }

    protected void debug(Object debubObj) {
        this.logger.debug(String.valueOf(debubObj));
    }

    protected void debug(Object debubObj, Exception e) {
        this.logger.debug(String.valueOf(debubObj), (Throwable)e);
    }

    protected void info(Object infoObj) {
        this.logger.info(String.valueOf(infoObj));
    }

    protected void info(Object infoObj, Exception e) {
        this.logger.info(String.valueOf(infoObj), (Throwable)e);
    }

    protected void error(Object errorObj) {
        this.logger.error(String.valueOf(errorObj));
    }

    protected void error(Object errorObj, Exception e) {
        this.logger.error(String.valueOf(errorObj), (Throwable)e);
    }

    public void setEventMulticaster(EventMulticaster eventMulticaster) {
        this.eventMulticaster = eventMulticaster;
    }
}

