/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.web.action;

import java.io.Serializable;
import java.util.List;
import org.beangle.commons.entity.pojo.Code;
import org.beangle.commons.lang.Assert;
import org.beangle.struts2.convention.route.Action;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.model.BaseInfo;
import org.openurp.edu.web.action.BaseAction;
import org.openurp.service.security.EamsUserCategory;

public abstract class MultiProjectSupportAction
extends BaseAction {
    protected void addBasecode(String key, Class<? extends Code<Integer>> clazz) {
        Assert.notEmpty((CharSequence)key);
        this.put(key, this.codeService.getCodes(clazz));
    }

    protected void addBaseInfo(String key, Class<? extends BaseInfo> clazz) {
        this.put(key, this.baseInfoService.getBaseInfos(clazz, this.getProject().getSchool()));
    }

    protected List getBaseInfos(Class<? extends BaseInfo> clazz) {
        return this.baseInfoService.getBaseInfos(clazz, this.getProject().getSchool());
    }

    public final String index() {
        List<Project> projects = this.getProjects();
        if (projects.size() == 0) {
            this.put("isStudent", ((Integer)this.getLoginUser().getCategory().getId()).equals(EamsUserCategory.STD_USER));
            return this.forward("noproject");
        }
        if (projects.size() == 1) {
            this.put("project", projects.get(0));
            return this.redirect(new Action(((Object)((Object)this)).getClass(), "innerIndex", "&projectId=" + String.valueOf(projects.get(0).getId())), null, null);
        }
        Integer defaultProjectId = (Integer)projects.get(0).getId();
        Integer givenProjectId = this.getInt("projectId");
        if (null != givenProjectId) {
            for (Project p : projects) {
                if (!((Integer)p.getId()).equals(givenProjectId)) continue;
                defaultProjectId = givenProjectId;
                break;
            }
        }
        this.put("defaultProjectId", defaultProjectId);
        this.put("projects", projects);
        return this.forward();
    }

    public abstract String innerIndex();

    protected abstract List<Project> getProjects();

    protected Project getProject() {
        Project project = (Project)this.getAttribute("project");
        if (null != project) {
            return project;
        }
        Integer projectId = this.getIntId("project");
        if (null == projectId) {
            List<Project> projects = this.getProjects();
            if (!projects.isEmpty()) {
                project = projects.get(0);
            }
        } else {
            project = (Project)this.entityDao.get(Project.class, (Serializable)projectId);
        }
        if (null != project) {
            this.put("project", project);
        }
        return project;
    }

    public Semester getSemester() {
        Semester semester;
        Project project = this.getProject();
        String semesterId = this.get("semester.id");
        Semester semester2 = semester = semesterId == null ? null : (Semester)this.entityDao.get(Semester.class, (Serializable)Integer.valueOf(semesterId));
        if (semester == null) {
            semester = this.semesterService.getCurSemester(project);
        } else if (!project.getCalendar().equals((Object)semester.getCalendar())) {
            semester = this.semesterService.getCurSemester(project);
        }
        return semester;
    }
}

