/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.web.helper;

import java.util.Date;
import org.beangle.commons.collection.Order;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.beangle.struts2.helper.Params;
import org.beangle.struts2.helper.QueryHelper;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.model.AuditStatus;
import org.openurp.edu.program.model.ExecutivePlan;
import org.openurp.edu.program.model.Program;
import org.openurp.web.helper.SearchHelper;

public class ExecutivePlanSearchHelper
extends SearchHelper {
    public OqlBuilder<Program> buildProgramQuery() {
        OqlBuilder query = OqlBuilder.from(Program.class, (String)"program").where("program.majorProgram = true");
        QueryHelper.populateConditions((OqlBuilder)query);
        if (Strings.isEmpty((CharSequence)Params.get((String)"orderBy"))) {
            query.orderBy(new Order("program.grade desc"));
        } else {
            query.orderBy(Params.get((String)"orderBy"));
        }
        query.limit(QueryHelper.getPageLimit());
        String status = Params.get((String)"fake.status");
        if (Strings.isNotBlank((CharSequence)status)) {
            query.where("program.status = :status", (Object)AuditStatus.valueOf((String)status.toUpperCase()));
        }
        Date now = new Date();
        Boolean valid = Params.getBoolean((String)"fake.valid");
        if (valid != null && valid.booleanValue()) {
            query.where("(program.endOn is null or :now1 < program.endOn)", (Object)now);
        } else if (valid != null && !valid.booleanValue()) {
            query.where(":now1 >= program.endOn", (Object)now);
        }
        return query;
    }

    public OqlBuilder<ExecutivePlan> buildPlanQuery() {
        OqlBuilder query = OqlBuilder.from(ExecutivePlan.class, (String)"plan");
        QueryHelper.populateConditions((OqlBuilder)query);
        if (Strings.isEmpty((CharSequence)Params.get((String)"orderBy"))) {
            query.orderBy(new Order("plan.program.grade desc"));
        } else {
            query.orderBy(Params.get((String)"orderBy"));
        }
        query.limit(QueryHelper.getPageLimit());
        String status = Params.get((String)"fake.status");
        if (Strings.isNotBlank((CharSequence)status)) {
            query.where("plan.program.status = :status", (Object)AuditStatus.valueOf((String)status.toUpperCase()));
        }
        Date now = new Date();
        Boolean valid = Params.getBoolean((String)"fake.valid");
        if (valid != null && valid.booleanValue()) {
            query.where("(plan.program.endOn is null or :now1 < plan.program.endOn)", (Object)now);
        } else if (valid != null && !valid.booleanValue()) {
            query.where(":now1 >= plan.program.endOn", (Object)now);
        }
        query.join("left outer", "plan.program.direction", "direction");
        return query;
    }

    public void addSemesterActiveCondition(OqlBuilder<ExecutivePlan> query, Semester semester) {
        java.sql.Date semesterBeg = semester.getBeginOn();
        java.sql.Date semesterEnd = semester.getEndOn();
        query.where("((plan.program.endOn is null     and :semesterEnd1 >= plan.program.beginOn) or (plan.program.endOn is not null and :semesterEnd2 >= plan.program.beginOn and :semesterBeg <= plan.program.endOn))", (Object)semesterEnd, (Object)semesterEnd, (Object)semesterBeg, new Object[0]);
    }
}

