/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.dwr;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.sql.Date;
import java.util.Collections;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.security.core.userdetail.Profile;
import org.openurp.base.edu.model.Direction;
import org.openurp.base.edu.model.Major;
import org.openurp.base.edu.model.Project;
import org.openurp.base.service.ProjectContext;
import org.openurp.base.std.model.Squad;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.code.std.model.StdType;
import org.openurp.web.dwr.AbstractDwr;

public class ProjectMajorDwr
extends AbstractDwr {
    EntityDao entityDao;
    ProjectContext projectContext;

    public String projects() {
        return null;
    }

    public List[] levelAndDeparts(HttpServletRequest request, Integer projectId, String resourceName) {
        try {
            this.prepareSecurity(request, null);
            Project project = (Project)this.entityDao.get(Project.class, (Serializable)projectId);
            Profile profile = null;
            if (!this.projectContext.getProfiles().isEmpty()) {
                profile = this.projectContext.getCurrentProfile();
            }
            List departInfos = CollectUtils.newArrayList();
            Date now = new Date(System.currentTimeMillis());
            for (Object depart : null == profile ? project.getDepartments() : this.projectContext.getDeparts()) {
                if (depart.getEndOn() != null && !depart.getEndOn().after(now)) continue;
                departInfos.add(new Object[]{depart.getId(), depart.getName()});
            }
            List levelInfos = CollectUtils.newArrayList();
            for (EducationLevel level : null == profile ? project.getLevels() : this.projectContext.getEducationLevels()) {
                levelInfos.add(new Object[]{level.getId(), level.getName()});
            }
            List stdTypeInfos = CollectUtils.newArrayList();
            for (StdType stdType : null == profile ? project.getStdTypes() : this.projectContext.getStdTypes()) {
                stdTypeInfos.add(new Object[]{stdType.getId(), stdType.getName()});
            }
            this.cleanSecurity();
            return new List[]{levelInfos, departInfos, stdTypeInfos};
        }
        catch (Exception e) {
            e.printStackTrace();
            return new List[]{Collections.emptyList(), Collections.emptyList(), Collections.emptyList()};
        }
    }

    public List majors(Integer projectId, Integer levelId, Integer departId) {
        if (projectId == null) {
            return Collections.emptyList();
        }
        java.util.Date now = new java.util.Date();
        OqlBuilder query = OqlBuilder.from(Major.class, (String)"s");
        query.select("str(s.id), s.code,s.name, s.enName").where("s.beginOn<=:now", (Object)now).where("(s.endOn is null or s.endOn >= :now)", (Object)now).where("s.project.id = :projectId", (Object)projectId);
        if (null != levelId && null != departId) {
            query.where("exists(from s.journals md where md.major=s and md.depart.id = :departId and md.level.id = :levelId)", (Object)departId, (Object)levelId);
        } else if (null != departId) {
            query.where("exists(from s.journals md where md.major=s and md.depart.id = :departId)", (Object)departId);
        } else if (null != levelId) {
            query.where("exists(from s.journals md where md.major=s and md.level.id = :levelId)", (Object)levelId);
        }
        query.orderBy("s.name");
        return this.entityDao.search((QueryBuilder)query);
    }

    public List<Object[]> directions(Integer levelId, Integer departId, Long majorId) {
        if (null == majorId) {
            return Collections.emptyList();
        }
        java.util.Date now = new java.util.Date();
        OqlBuilder query = OqlBuilder.from(Direction.class, (String)"s");
        query.select("str(s.id),s.code, s.name, s.enName").where("s.beginOn<=:now", (Object)now).where("(s.endOn is null or s.endOn >= :now)", (Object)now).where("s.major.id = :majorId", (Object)majorId);
        if (null != levelId) {
            query.where("exists(from s.journals as j where j.level.id=:levelId)", (Object)levelId);
        }
        if (null != departId) {
            query.where("exists(from s.journals as j where j.depart.id=:departId)", (Object)departId);
        }
        query.orderBy("s.name");
        return this.entityDao.search((QueryBuilder)query);
    }

    public List<Object[]> adminClasses(String grade, Long directionId, Long majorId) {
        if (null == majorId) {
            return Collections.emptyList();
        }
        String hql = "select str(s.id), s.name from " + Squad.class.getName() + " as s where s.beginOn<=:now and (s.endOn is null or s.endOn>=:now) and s.major.id=:majorId";
        if (null != directionId) {
            hql = hql + " and s.direction.id =:directionId";
        }
        if (null != grade) {
            hql = hql + " and s.grade = :grade";
        }
        hql = hql + " order by s.name";
        OqlBuilder builder = OqlBuilder.from((String)hql);
        builder.param("majorId", (Object)majorId);
        builder.param("now", (Object)new java.util.Date());
        if (null != directionId) {
            builder.param("directionId", (Object)directionId);
        }
        if (null != grade) {
            builder.param("grade", (Object)grade);
        }
        return this.entityDao.search((QueryBuilder)builder);
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    public void setProjectContext(ProjectContext projectContext) {
        this.projectContext = projectContext;
    }
}

