/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.util;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.text.i18n.TextResource;
import org.openurp.service.OutputMessage;
import org.openurp.web.util.OutputProcessObserver;
import org.springframework.core.io.ClassPathResource;

public class OutputWebObserver
extends OutputProcessObserver {
    protected String path;
    protected String base;

    public OutputWebObserver() {
    }

    public OutputWebObserver(String base, PrintWriter writer, TextResource textResource, String path) {
        super(writer, textResource);
        this.base = base;
        this.path = path;
        this.outputTemplate();
    }

    public void outputTemplate() {
        try {
            ClassPathResource cpr = new ClassPathResource("/template/" + this.path);
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(cpr.getInputStream(), "UTF-8"));
            String lineContent = null;
            do {
                if (null == (lineContent = reader.readLine())) continue;
                lineContent = Strings.replace((String)lineContent, (String)"${base}", (String)this.base);
                this.writer.write(lineContent + "\r\n");
            } while (null != lineContent);
            this.writer.flush();
        }
        catch (Exception e) {
            this.logger.warn("exception", (Throwable)e);
        }
    }

    public OutputWebObserver(PrintWriter writer, TextResource textResource) {
        this.writer = writer;
        this.textResource = textResource;
    }

    @Override
    public void outputNotify(int level, OutputMessage msgObj) {
        try {
            switch (level) {
                case 1: {
                    this.writer.print(this.message(msgObj));
                    this.writer.flush();
                    break;
                }
                case 2: {
                    this.writer.print("<font color=blue>");
                    this.writer.print(this.message(msgObj));
                    this.writer.print("</font>");
                    this.writer.flush();
                    break;
                }
                case 3: {
                    this.writer.print("<font color=red>");
                    this.writer.print(this.message(msgObj));
                    this.writer.print("</font>");
                    this.writer.flush();
                    break;
                }
                case 4: {
                    this.writer.print("<font color='green'>");
                    this.writer.print(this.message(msgObj));
                    this.writer.print("</font>");
                    this.writer.flush();
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("exception", (Throwable)e);
        }
    }

    public void outputNotify(OutputMessage msgObj) {
        this.outputNotify(1, msgObj);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setBase(String base) {
        this.base = base;
    }
}

