/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.web.helper;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.collection.Order;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.BitStrings;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.tuple.Pair;
import org.beangle.orm.hibernate.udt.HourMinute;
import org.beangle.orm.hibernate.udt.WeekDay;
import org.beangle.orm.hibernate.udt.WeekState;
import org.beangle.struts2.helper.Params;
import org.beangle.struts2.helper.QueryHelper;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.edu.model.WeekTimeBuilder;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.Department;
import org.openurp.base.std.model.Squad;
import org.openurp.code.edu.model.ClazzTag;
import org.openurp.code.edu.model.ExamType;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.ClazzRestrictionMeta;
import org.openurp.edu.clazz.model.Schedule;
import org.openurp.edu.clazz.model.ScheduleSuggest;
import org.openurp.edu.exam.model.ExamTaker;
import org.openurp.web.helper.SearchHelper;

public class ClazzSearchHelper
extends SearchHelper {
    public OqlBuilder<Clazz> buildQuery() {
        return this.buildQuery(true);
    }

    public OqlBuilder<Clazz> buildQuery(boolean applyRestriction) {
        String grade;
        Integer genderId;
        Integer directionId;
        Integer majorId;
        Integer departId;
        Integer stdTypeId;
        Integer examTypeId;
        Integer compare;
        Boolean crossdepart;
        Integer stdCountEnd;
        Integer stdCountStart;
        Integer limitCountEnd;
        Integer limitCountStart;
        Float weekHours;
        Integer weeks;
        String courseScheduleStatus;
        String status;
        Integer semesterId;
        OqlBuilder query = OqlBuilder.from(Clazz.class, (String)"clazz");
        if (applyRestriction) {
            boolean shouldApply = true;
            if (this.projectContext.isRoot() || this.projectContext.getDeparts().containsAll(this.projectContext.getProject().getDepartments())) {
                shouldApply = false;
            }
            if (shouldApply) {
                query.where("clazz.teachDepart in(:departs)", (Object)this.projectContext.getDeparts());
            }
        }
        if ((semesterId = Params.getInt((String)"clazz.semester.id")) == null) {
            semesterId = Params.getInt((String)"semesterId");
        }
        Semester semester = (Semester)this.entityDao.get(Semester.class, (Serializable)semesterId);
        String clazzIdSeq = Params.get((String)"splitIds");
        if (Strings.isNotEmpty((CharSequence)clazzIdSeq)) {
            query.where("clazz.id in (:clazzIds)", (Object)Strings.splitToLong((String)clazzIdSeq));
            query.limit(QueryHelper.getPageLimit());
            return query;
        }
        Project project = this.projectContext.getProject();
        query.where("clazz.project=:project", (Object)project);
        QueryHelper.populateConditions((OqlBuilder)query, (String)"clazz.project.id,clazz.schedule.status,clazz.id,clazz.courseType.name");
        String courseTypeName = Params.get((String)"clazz.courseType.name");
        boolean courseTypeNameNotLike = Params.getBool((String)"fake.courseType.name.notLike");
        if (Strings.isNotBlank((CharSequence)Strings.trim((String)courseTypeName))) {
            if (courseTypeNameNotLike) {
                query.where("clazz.courseType.name not like :courseTypeName", (Object)("%" + courseTypeName + "%"));
            } else {
                query.where("clazz.courseType.name like :courseTypeName", (Object)("%" + courseTypeName + "%"));
            }
        }
        Boolean teacherIsNull = Params.getBoolean((String)"fake.teacher.null");
        Integer teacherDepart = Params.getInt((String)"fake.teacher.department.id");
        String teacherName = Params.get((String)"teacher.name");
        if (Strings.isBlank((CharSequence)teacherName)) {
            teacherName = Params.get((String)"clazz.teacher.name");
        }
        if ((teacherDepart != null || Strings.isNotBlank((CharSequence)teacherName)) && null == teacherIsNull) {
            teacherIsNull = false;
        }
        if (teacherIsNull != null) {
            if (Boolean.TRUE.equals(teacherIsNull)) {
                query.where("size(clazz.teachers) = 0");
            } else if (teacherDepart == null && Strings.isBlank((CharSequence)teacherName)) {
                query.where("size(clazz.teachers) > 0");
            } else if (null != teacherDepart && Strings.isBlank((CharSequence)teacherName)) {
                query.where("exists (from clazz.teachers tt where tt.department = :teacherDepartment)", (Object)this.entityDao.get(Department.class, (Serializable)teacherDepart));
            } else if (null == teacherDepart && Strings.isNotBlank((CharSequence)teacherName)) {
                query.where("exists (from clazz.teachers tt where tt.name like :tname)", (Object)("%" + teacherName + "%"));
            } else {
                query.where("exists (from clazz.teachers tt where tt.name like :tname adn tt.department =:teacherDepartment)", (Object)("%" + teacherName + "%"), (Object)this.entityDao.get(Department.class, (Serializable)teacherDepart));
            }
        }
        if (Strings.isNotBlank((CharSequence)(status = Params.get((String)"fake.state")))) {
            query.where("clazz.status = :status", (Object)AuditStatus.valueOf((String)status.toUpperCase()));
        }
        Long buildingId = Params.getLong((String)"fack.building.id");
        Integer weekday = Params.getInt((String)"fake.time.weekday");
        String courseUnit = Params.get((String)"courseActivity.time.beginAt");
        if (null == courseUnit) {
            courseUnit = Params.get((String)"fake.time.unit");
        }
        Integer activityWeekStart = Params.getInt((String)"fake.time.weekstart");
        Integer activityWeekEnd = Params.getInt((String)"fake.time.weekend");
        Long activityWeekState = null;
        if (null != activityWeekStart || null != activityWeekEnd) {
            if (null == activityWeekStart) {
                activityWeekStart = activityWeekEnd;
            }
            if (null == activityWeekEnd) {
                activityWeekEnd = activityWeekStart;
            }
            if (activityWeekEnd >= activityWeekStart && activityWeekEnd < 52 && activityWeekStart > 0) {
                StringBuilder sb = new StringBuilder(Strings.repeat((String)"0", (int)53));
                for (int i = activityWeekStart.intValue(); i <= activityWeekEnd; ++i) {
                    sb.setCharAt(i, '1');
                }
                activityWeekState = BitStrings.binValueOf((String)sb.toString());
            }
        }
        if (null != buildingId || Strings.isNotBlank((CharSequence)courseUnit) || null != weekday || null != activityWeekState) {
            StringBuilder activityQuery = new StringBuilder("exists( from clazz.schedule.activities as courseActivity where 1=1 ");
            if (Strings.isNotBlank((CharSequence)courseUnit)) {
                if (courseUnit.contains(":")) {
                    activityQuery.append("and courseActivity.time.beginAt <= :beginAt and courseActivity.time.endAt >= :beginAt ");
                    query.param("beginAt", (Object)new HourMinute(courseUnit));
                } else {
                    activityQuery.append("and courseActivity.beginUnit <= :beginAt and courseActivity.endUnit >= :beginAt ");
                    query.param("beginAt", (Object)Short.valueOf(courseUnit));
                }
            }
            if (null != weekday) {
                activityQuery.append(" and courseActivity.time.startOn in (:startOn)");
                query.param("startOn", (Object)WeekTimeBuilder.getYearStartOns((Semester)semester, (WeekDay)WeekDay.get((int)weekday)));
            }
            if (null != activityWeekState) {
                activityQuery.append(" and bitand(courseActivity.time.weekstate," + activityWeekState + ")>0");
            }
            if (null != buildingId) {
                activityQuery.append(" and exists(from courseActivity.rooms as cr where cr.room.building.id=" + buildingId + ")");
            }
            activityQuery.append(")");
            query.where(activityQuery.toString());
        }
        if (Strings.isNotEmpty((CharSequence)(courseScheduleStatus = Params.get((String)"clazz.schedule.status")))) {
            Schedule.Status s = Schedule.Status.valueOf((String)courseScheduleStatus);
            if (s.equals((Object)Schedule.Status.DONT_ARRANGE)) {
                query.where("clazz.schedule.creditHours =0");
            } else if (s.equals((Object)Schedule.Status.NEED_ARRANGE)) {
                query.where("clazz.schedule.creditHours >0 and size(clazz.schedule.activities)=0");
            } else {
                query.where("clazz.schedule.creditHours >0 and size(clazz.schedule.activities)>0");
            }
        }
        if (null != (weeks = Params.getInt((String)"fake.weeks"))) {
            query.where("week_state_weeks(clazz.schedule.weekstate)=:weeks", (Object)weeks);
        }
        if (null != (weekHours = Params.getFloat((String)"fake.weekHours"))) {
            query.where("week_state_weeks(clazz.schedule.weekstate) >0 and  (clazz.schedule.creditHours / week_state_weeks(clazz.schedule.weekstate) ) = :weekHours", (Object)weekHours.intValue());
        }
        Integer startWeek = Params.getInt((String)"fake.week.start");
        Integer endWeek = Params.getInt((String)"fake.week.end");
        if (null != startWeek || null != endWeek) {
            List weekIndecies = CollectUtils.newArrayList();
            if (null == startWeek) {
                startWeek = 1;
            }
            if (null == endWeek) {
                endWeek = semester.getWeeks();
            }
            while (startWeek <= endWeek) {
                weekIndecies.add(startWeek);
                startWeek = startWeek + 1;
            }
            query.where("bitand(clazz.schedule.weekstate,:weekstate)>0", (Object)WeekState.of((List)weekIndecies).value);
        }
        if (null != (limitCountStart = Params.getInt((String)"fake.limitCount.start"))) {
            query.where("clazz.enrollment.capacity >= :limitCountStart", (Object)limitCountStart);
        }
        if (null != (limitCountEnd = Params.getInt((String)"fake.limitCount.end"))) {
            query.where("clazz.enrollment.capacity <= :limitCountEnd", (Object)limitCountEnd);
        }
        if (null != (stdCountStart = Params.getInt((String)"fake.stdCount.start"))) {
            query.where("clazz.enrollment.stdCount >= :stdCountStart", (Object)stdCountStart);
        }
        if (null != (stdCountEnd = Params.getInt((String)"fake.stdCount.end"))) {
            query.where("clazz.enrollment.stdCount <= :stdCountEnd", (Object)stdCountEnd);
        }
        if (Boolean.TRUE.equals(crossdepart = Params.getBoolean((String)"fake.crossdepart"))) {
            query.where("(clazz.enrollment.depart != clazz.teachDepart or clazz.enrollment.depart is null)");
        } else if (Boolean.FALSE.equals(crossdepart)) {
            query.where("clazz.enrollment.depart = clazz.teachDepart");
        }
        Boolean guapai = Params.getBoolean((String)"fake.guapai");
        if (Boolean.TRUE.equals(guapai)) {
            query.where("exists (select tag.id from clazz.tags tag where tag.id=:guaPai)", (Object)ClazzTag.PredefinedTags.GUAPAI.getId());
        } else if (Boolean.FALSE.equals(guapai)) {
            query.where("not exists (select tag.id from clazz.tags tag where tag.id=:guaPai)", (Object)ClazzTag.PredefinedTags.GUAPAI.getId());
        }
        String squadName = Params.get((String)"fake.squad.name");
        if (Strings.isNotBlank((CharSequence)squadName)) {
            OqlBuilder squadQuery = OqlBuilder.from(Squad.class, (String)"squad");
            squadQuery.where("squad.name like :name", (Object)("%" + squadName + "%")).where("squad.project = :project", (Object)project);
            List squades = this.entityDao.search((QueryBuilder)squadQuery);
            if (CollectUtils.isNotEmpty((Collection)squades)) {
                StringBuilder squadCondition = new StringBuilder();
                squadCondition.append("exists (").append("select litem.id from clazz.enrollment.restrictions lgroup join lgroup.items litem where").append(" litem.meta=").append(ClazzRestrictionMeta.Squad.getId()).append(" and ").append(" litem.included=true ").append(" and (");
                Iterator iter = squades.iterator();
                while (iter.hasNext()) {
                    Squad squad = (Squad)iter.next();
                    squadCondition.append("locate(',").append(((Long)squad.getId()).toString()).append(",',litem.contents) > 0").append(" or litem.contents ='").append(((Long)squad.getId()).toString()).append("' ");
                    if (!iter.hasNext()) continue;
                    squadCondition.append(" or ");
                }
                squadCondition.append(")").append(")");
                query.where(squadCondition.toString());
            }
        }
        if (null != (compare = Params.getInt((String)"electInfo.electCountCompare"))) {
            String op = "";
            op = compare == 0 ? "=" : (compare < 0 ? "<" : ">");
            query.where("clazz.enrollment.stdCount " + op + " clazz.enrollment.capacity");
        }
        if ((examTypeId = Params.getInt((String)"examType.id")) != null && examTypeId.equals(ExamType.DELAY)) {
            query.where("1=0");
        }
        if (examTypeId != null && examTypeId.equals(ExamType.MAKEUP)) {
            query.where("exists (from " + ExamTaker.class.getName() + " examTaker where examTaker.examType.id in (:examTypeIds) and examTaker.clazz.project.id = :projectId and examTaker.semester.id = :semesterId and examTaker.clazz = clazz)", (Object)new Integer[]{ExamType.MAKEUP, ExamType.DELAY}, (Object)Params.getInt((String)"clazz.project.id"), (Object)semesterId, new Object[0]);
        }
        query.limit(QueryHelper.getPageLimit());
        if (Strings.isEmpty((CharSequence)Params.get((String)"orderBy"))) {
            query.orderBy("clazz.crn");
        } else if ("fake.weekHours asc".equals(Params.get((String)"orderBy"))) {
            query.orderBy("(clazz.course.creditHours / (clazz.schedule.lastWeek + 1 - clazz.schedule.firstWeek)) asc");
        } else if ("fake.weekHours desc".equals(Params.get((String)"orderBy"))) {
            query.orderBy("(clazz.course.creditHours / (clazz.schedule.lastWeek + 1 - clazz.schedule.firstWeek)) desc");
        } else if ("clazz.schedule.weeks asc".equals(Params.get((String)"orderBy"))) {
            query.orderBy("(clazz.schedule.lastWeek - clazz.schedule.firstWeek + 1) asc");
        } else if ("clazz.schedule.weeks desc".equals(Params.get((String)"orderBy"))) {
            query.orderBy("(clazz.schedule.lastWeek - clazz.schedule.firstWeek + 1) desc");
        } else if ("clazz.fake.state asc".equals(Params.get((String)"orderBy"))) {
            query.orderBy("str(clazz.status) asc");
        } else if ("clazz.fake.state desc".equals(Params.get((String)"orderBy"))) {
            query.orderBy("str(clazz.status) desc");
        } else {
            query.orderBy(Order.parse((String)Params.get((String)"orderBy")));
        }
        Boolean isPreScheduled = Params.getBoolean((String)"fake.arrangeSuggest.status");
        if (isPreScheduled != null) {
            if (isPreScheduled.booleanValue()) {
                query.where("exists(from " + ScheduleSuggest.class.getName() + " suggest where suggest.clazz = clazz)");
            } else {
                query.where("not exists(from " + ScheduleSuggest.class.getName() + " suggest where suggest.clazz = clazz)");
            }
        }
        List limitItemConditions = CollectUtils.newArrayList();
        Integer levelId = Params.getInt((String)"limitGroup.level.id");
        if (null != levelId) {
            limitItemConditions.add(new Pair((Object)ClazzRestrictionMeta.Level, (Object)levelId));
        }
        if (null != (stdTypeId = Params.getInt((String)"limitGroup.stdType.id"))) {
            limitItemConditions.add(new Pair((Object)ClazzRestrictionMeta.StdType, (Object)stdTypeId));
        }
        if (null != (departId = Params.getInt((String)"limitGroup.depart.id"))) {
            limitItemConditions.add(new Pair((Object)ClazzRestrictionMeta.Department, (Object)departId));
        }
        if (null != (majorId = Params.getInt((String)"limitGroup.major.id"))) {
            limitItemConditions.add(new Pair((Object)ClazzRestrictionMeta.Major, (Object)majorId));
        }
        if (null != (directionId = Params.getInt((String)"limitGroup.direction.id"))) {
            limitItemConditions.add(new Pair((Object)ClazzRestrictionMeta.Direction, (Object)directionId));
        }
        if (null != (genderId = Params.getInt((String)"limitGroup.gender.id"))) {
            limitItemConditions.add(new Pair((Object)ClazzRestrictionMeta.Gender, (Object)genderId));
        }
        if (StringUtils.isNotBlank((CharSequence)(grade = Params.get((String)"limitGroup.grade")))) {
            limitItemConditions.add(new Pair((Object)ClazzRestrictionMeta.Grade, (Object)grade));
        }
        if (CollectUtils.isNotEmpty((Collection)limitItemConditions)) {
            query.where(this.limitGroupCondition(limitItemConditions));
        }
        return query;
    }

    public List<Clazz> searchClazz() {
        return this.entityDao.search(this.buildQuery());
    }

    private String limitGroupCondition(List<Pair<ClazzRestrictionMeta, Object>> limitItemConditions) {
        StringBuilder condition = new StringBuilder();
        condition.append("exists (").append("select lgroup.id from clazz.enrollment.restrictions lgroup where ");
        for (int i = 0; i < limitItemConditions.size(); ++i) {
            Pair<ClazzRestrictionMeta, Object> limitItemCondition = limitItemConditions.get(i);
            ClazzRestrictionMeta field = (ClazzRestrictionMeta)limitItemCondition._1;
            Object value = limitItemCondition._2;
            condition.append(" exists ( from lgroup.items litem where").append(" litem.meta=").append(field.getId()).append(" and ").append(" litem.included=true").append(" and locate(',").append(value.toString()).append(",' , ',' || litem.contents || ',')>0").append(")");
            if (i >= limitItemConditions.size() - 1) continue;
            condition.append(" and ");
        }
        condition.append(")");
        return condition.toString();
    }
}

