/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.action.api;

import com.google.gson.Gson;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Arrays;
import org.beangle.commons.lang.Strings;
import org.openurp.base.edu.model.Major;
import org.openurp.base.edu.model.MajorJournal;
import org.openurp.edu.web.action.BaseAction;
import org.openurp.web.action.internal.ClazzGsonBuilderHelper;
import org.openurp.web.action.internal.ClazzGsonBuilderWorker;

public class MajorAction
extends BaseAction {
    public String json() throws IOException {
        Object[] levelIds = Strings.splitToInt((String)this.get("levelIds"));
        Object[] departmentIds = Strings.splitToInt((String)this.get("departmentIds"));
        Object warnings = "";
        if (Arrays.isEmpty((Object[])levelIds)) {
            warnings = (String)warnings + "\u8bf7\u5148\u9009\u62e9\u57f9\u517b\u5c42\u6b21\n";
        }
        if (Arrays.isEmpty((Object[])departmentIds)) {
            warnings = (String)warnings + "\u8bf7\u5148\u9009\u62e9\u4e0a\u8bfe\u9662\u7cfb";
        }
        List majors = new ArrayList();
        if (Strings.isBlank((CharSequence)warnings)) {
            OqlBuilder query = OqlBuilder.from(Major.class, (String)"major");
            query.where("major.project.id = :projectId", (Object)this.getIntId("project")).where("exists(from major.journals md where md.depart.id in (:departIds))", (Object)departmentIds).orderBy("major.code, major.name");
            majors = this.entityDao.search((QueryBuilder)query);
        }
        Gson gson = new Gson();
        String json = gson.toJson(ClazzGsonBuilderHelper.genGroupResult(majors, (String)warnings, new ClazzGsonBuilderWorker(){

            @Override
            public void dirtywork(Object object, Map<String, Object> groups) {
                Major major = (Major)object;
                for (MajorJournal md : major.getJournals()) {
                    String groupName = md.getDepart().getName().toString();
                    if (groups.get(groupName) == null) {
                        groups.put(groupName, new ArrayList());
                    }
                    List entities = (List)groups.get(groupName);
                    TreeMap<String, Object> entity = new TreeMap<String, Object>();
                    entity.put("id", major.getId());
                    entity.put("name", major.getName());
                    entity.put("code", major.getCode());
                    if (entities.contains(entity)) continue;
                    entities.add(entity);
                }
            }
        }));
        HttpServletResponse response = this.getResponse();
        response.setContentType("text/plain;charset=UTF-8");
        response.getWriter().write(json);
        response.getWriter().close();
        return null;
    }
}

