/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.helper;

import java.util.Date;
import org.beangle.commons.collection.Order;
import org.beangle.commons.dao.query.builder.Condition;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.lang.Strings;
import org.beangle.struts2.helper.Params;
import org.beangle.struts2.helper.QueryHelper;
import org.openurp.base.std.model.Student;
import org.openurp.web.helper.SearchHelper;

public class StdSearchHelper
extends SearchHelper {
    public OqlBuilder<? extends Entity<Long>> buildStdQuery() {
        return this.buildStdQuery(null);
    }

    public OqlBuilder<? extends Entity<Long>> buildStdQuery(String extraStdTypeAttr) {
        OqlBuilder query = null;
        query = OqlBuilder.from(Student.class, (String)"std");
        query.where("std.project=:project", (Object)this.projectContext.getProject());
        QueryHelper.populateConditions((OqlBuilder)query);
        Boolean stdActive = Params.getBoolean((String)"stdActive");
        if (null != stdActive) {
            if (Boolean.TRUE.equals(stdActive)) {
                query.where("std.state.inschool=true and std.beginOn <= :now and std.endOn >= :now and std.registed = true", (Object)new Date());
            } else {
                query.where("std.state.inschool=false or std.beginOn > :now or std.endOn < :now or std.registed=false", (Object)new Date());
            }
        }
        this.projectContext.applyRestriction(query);
        query.limit(QueryHelper.getPageLimit());
        query.orderBy(Order.parse((String)Params.get((String)"orderBy")));
        String stdIds = Params.get((String)"stdIds");
        if (Strings.isNotEmpty((CharSequence)stdIds)) {
            Long[] ids = Strings.splitToLong((String)stdIds);
            query.where(new Condition[]{new Condition("std.id in (:stdIds)", (Object)ids)});
        }
        return query;
    }

    public static void addMajorConditon(OqlBuilder entityQuery, String stdAttr) {
        Integer levelId = Params.getInt((String)"std.level.id");
        Integer departId = Params.getInt((String)"department.id");
        Integer specialityId = Params.getInt((String)"major.id");
        Integer aspectId = Params.getInt((String)"direction.id");
        if (!new Long(4L).equals(levelId)) {
            entityQuery.join("left", stdAttr + ".major", "major");
            entityQuery.join("left", stdAttr + ".direction", "direction");
            if (null != aspectId) {
                entityQuery.where("direction.id=" + aspectId);
            }
            if (null != specialityId) {
                entityQuery.where("major.id=" + specialityId);
            } else if (null != departId) {
                entityQuery.where(stdAttr + ".department.id=" + departId);
            }
        } else {
            entityQuery.join("left", stdAttr + ".secondAspect", "secondAspect");
            entityQuery.join("left", stdAttr + ".secondMajor", "secondMajor");
            entityQuery.where("secondMajor is not null");
            if (null != aspectId) {
                entityQuery.where("secondAspect.id=" + aspectId);
            } else if (null != specialityId) {
                entityQuery.where("secondMajor.id=" + specialityId);
            } else if (null != departId) {
                entityQuery.where(stdAttr + ".secondMajor.department.id=" + departId);
            }
        }
    }
}

