/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.action.api;

import com.google.gson.Gson;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Arrays;
import org.beangle.commons.lang.Strings;
import org.openurp.base.edu.model.MajorDirection;
import org.openurp.edu.web.action.BaseAction;
import org.openurp.web.action.internal.ClazzGsonBuilderHelper;
import org.openurp.web.action.internal.ClazzGsonBuilderWorker;

public class DirectionAction
extends BaseAction {
    public String json() throws IOException {
        Object[] majorIds = Strings.splitToInt((String)this.get("majorIds"));
        Integer[] departmentIds = Strings.splitToInt((String)this.get("departmentIds"));
        Object warnings = "";
        if (Arrays.isEmpty((Object[])majorIds)) {
            warnings = (String)warnings + "\u8bf7\u5148\u9009\u62e9\u4e13\u4e1a";
        }
        if (Strings.isNotBlank((CharSequence)warnings)) {
            this.put("warnings", warnings);
            return this.forward("directionsJSON");
        }
        List directions = new ArrayList();
        if (Strings.isBlank((CharSequence)warnings)) {
            OqlBuilder query = OqlBuilder.from(MajorDirection.class, (String)"direction");
            query.where("direction.major.project.id = :projectId", (Object)this.getIntId("project")).where("direction.major.id in (:majorIds)", (Object)majorIds).orderBy("direction.code, direction.name");
            if (null != departmentIds && departmentIds.length > 0) {
                query.where("exists(from direction.journals dd where dd.depart.id in (:departIds))", (Object)departmentIds);
            }
            directions = this.entityDao.search((QueryBuilder)query);
        }
        Gson gson = new Gson();
        String json = gson.toJson(ClazzGsonBuilderHelper.genGroupResult(directions, (String)warnings, new ClazzGsonBuilderWorker(){

            @Override
            public void dirtywork(Object object, Map<String, Object> groups) {
                MajorDirection rawEntity = (MajorDirection)object;
                String groupName = rawEntity.getMajor().getName();
                if (groups.get(groupName) == null) {
                    groups.put(groupName, new ArrayList());
                }
                List entities = (List)groups.get(groupName);
                TreeMap<String, Object> entity = new TreeMap<String, Object>();
                entity.put("id", rawEntity.getId());
                entity.put("name", rawEntity.getName());
                entity.put("code", rawEntity.getCode());
                entities.add(entity);
            }
        }));
        HttpServletResponse response = this.getResponse();
        response.setContentType("text/plain;charset=UTF-8");
        response.getWriter().write(json);
        response.getWriter().close();
        return null;
    }
}

