/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.web.dwr;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.beangle.commons.dao.EntityDao;
import org.beangle.orm.hibernate.udt.WeekState;
import org.openurp.base.edu.model.Course;
import org.openurp.base.time.NumberRangeDigestor;
import org.openurp.edu.program.model.ExecutivePlanCourse;
import org.openurp.edu.program.model.MajorPlanCourse;
import org.openurp.edu.program.model.Program;

public class PlanCourseServiceDwr {
    private EntityDao entityDao;

    public Map<String, Object> getExecutivePlanCourse(Long id) {
        ExecutivePlanCourse pc = (ExecutivePlanCourse)this.entityDao.get(ExecutivePlanCourse.class, (Serializable)id);
        HashMap<String, Object> datas = new HashMap<String, Object>();
        datas.put("id", ((Long)pc.getId()).toString());
        datas.put("course", this.convertCourse(pc.getCourse(), pc.getGroup().getPlan().getProgram()));
        datas.put("terms", pc.getTerms().toString());
        if (pc.getWeekstate() != null) {
            datas.put("weekstate", NumberRangeDigestor.digest((WeekState)pc.getWeekstate()));
        }
        datas.put("compulsory", pc.isCompulsory());
        datas.put("remark", pc.getRemark());
        return datas;
    }

    public Map<String, Object> getMajorPlanCourse(Long id) {
        MajorPlanCourse pc = (MajorPlanCourse)this.entityDao.get(MajorPlanCourse.class, (Serializable)id);
        HashMap<String, Object> datas = new HashMap<String, Object>();
        datas.put("id", ((Long)pc.getId()).toString());
        datas.put("course", this.convertCourse(pc.getCourse(), pc.getGroup().getPlan().getProgram()));
        datas.put("terms", pc.getTerms().toString());
        if (pc.getWeekstate() != null) {
            datas.put("weekstate", NumberRangeDigestor.digest((WeekState)pc.getWeekstate()));
        }
        datas.put("compulsory", pc.isCompulsory());
        datas.put("remark", pc.getRemark());
        return datas;
    }

    private Map<String, Object> convertCourse(Course c, Program p) {
        HashMap<String, Object> course = new HashMap<String, Object>();
        course.put("id", c.getId());
        course.put("name", c.getName());
        course.put("defaultCredits", Float.valueOf(c.getCredits(p.getLevel())));
        course.put("creditHours", c.getCreditHours());
        course.put("weekHours", c.getWeekHours());
        if (c.getWeeks() != null) {
            course.put("weeks", c.getWeeks());
        }
        return course;
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }
}

